/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.attachment;

import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.Energy;
import waterpower.common.block.attachment.EnergyStorage;
import waterpower.common.block.attachment.TileEntityAttachment;
import waterpower.common.block.tile.TileEntityBase;
import waterpower.integration.Mod;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J<\u0010\u0011\u001a,\u0012(\u0012&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00020\u0002 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00130\u00130\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J-\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0016H\u0007J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lwaterpower/common/block/attachment/AttachmentRF;", "Lwaterpower/common/block/attachment/TileEntityAttachment;", "Lnet/minecraftforge/energy/IEnergyStorage;", "te", "Lwaterpower/common/block/tile/TileEntityBase;", "energyStroage", "Lwaterpower/common/block/attachment/EnergyStorage;", "(Lwaterpower/common/block/tile/TileEntityBase;Lwaterpower/common/block/attachment/EnergyStorage;)V", "getEnergyStroage", "()Lwaterpower/common/block/attachment/EnergyStorage;", "canExtract", "", "canReceive", "extractEnergy", "", "maxExtract", "simulate", "getCapabilities", "", "Lnet/minecraftforge/common/capabilities/Capability;", "kotlin.jvm.PlatformType", "side", "Lnet/minecraft/util/EnumFacing;", "getCapability", "T", "capability", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getEnergyStored", "getMaxEnergyStored", "getName", "", "onTick", "", "processTileEntity", "Lnet/minecraft/tileentity/TileEntity;", "facing", "receiveEnergy", "maxReceive", "WaterPower_main"})
public final class AttachmentRF
extends TileEntityAttachment
implements IEnergyStorage {
    @NotNull
    private final EnergyStorage energyStroage;

    @Override
    @NotNull
    public String getName() {
        return "rf";
    }

    @Override
    public void onTick() {
        super.onTick();
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        for (int i = 0; i < enumFacingArray.length; ++i) {
            EnumFacing facing = enumFacingArray[i];
            if (this.getEnergyStored() == 0) break;
            EnumFacing opposite = facing.func_176734_d();
            BlockPos pos = this.getMaster().func_174877_v().func_177972_a(facing);
            TileEntity neighbor = this.getMaster().func_145831_w().func_175625_s(pos);
            if (neighbor == null) continue;
            int received = 0;
            boolean flag = false;
            if (Mod.Companion.getRedstoneFlux().isAvailable()) {
                try {
                    if (neighbor instanceof IEnergyReceiver) {
                        received += ((IEnergyReceiver)neighbor).receiveEnergy(opposite, this.getEnergyStored(), false);
                        flag = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (flag || !neighbor.hasCapability(CapabilityEnergy.ENERGY, opposite)) continue;
            received = 0;
            Object object = neighbor.getCapability(CapabilityEnergy.ENERGY, opposite);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.energy.IEnergyStorage");
            }
            IEnergyStorage cap = (IEnergyStorage)object;
            if (cap.canReceive()) {
                received += cap.receiveEnergy(this.getEnergyStored(), false);
            }
            this.extractEnergy(received, false);
        }
    }

    @Optional.Method(modid="redstoneflux")
    public final int processTileEntity(@NotNull TileEntity te, @NotNull EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        if (te instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)te).receiveEnergy(facing, this.getEnergyStored(), false);
        }
        return -1;
    }

    @NotNull
    public Set<Capability<IEnergyStorage>> getCapabilities(@Nullable EnumFacing side) {
        return SetsKt.setOf((Object)CapabilityEnergy.ENERGY);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY)) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    public boolean canExtract() {
        return this.energyStroage.canExtract();
    }

    public boolean canReceive() {
        return false;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)Energy.Companion.EU2RF(this.energyStroage.extractEnergy(Energy.Companion.RF2EU(maxExtract), simulate));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energyStroage.getEnergyStoredRF();
    }

    public int getMaxEnergyStored() {
        return (int)Energy.Companion.EU2RF(this.energyStroage.getMaxEnergyStored());
    }

    @NotNull
    public final EnergyStorage getEnergyStroage() {
        return this.energyStroage;
    }

    public AttachmentRF(@NotNull TileEntityBase te, @NotNull EnergyStorage energyStroage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)te), (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)energyStroage, (String)"energyStroage");
        super(te);
        this.energyStroage = energyStroage;
    }
}

