/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.attachment;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.Energy;
import waterpower.common.block.attachment.EnergyStorage;
import waterpower.common.block.attachment.TileEntityAttachment;
import waterpower.common.block.tile.TileEntityBase;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lwaterpower/common/block/attachment/AttachmentSteam;", "Lwaterpower/common/block/attachment/TileEntityAttachment;", "te", "Lwaterpower/common/block/tile/TileEntityBase;", "energyStorage", "Lwaterpower/common/block/attachment/EnergyStorage;", "fluidTank", "Lnet/minecraftforge/fluids/FluidTank;", "(Lwaterpower/common/block/tile/TileEntityBase;Lwaterpower/common/block/attachment/EnergyStorage;Lnet/minecraftforge/fluids/FluidTank;)V", "getEnergyStorage", "()Lwaterpower/common/block/attachment/EnergyStorage;", "getFluidTank", "()Lnet/minecraftforge/fluids/FluidTank;", "steam", "Lnet/minecraftforge/fluids/Fluid;", "getSteam", "()Lnet/minecraftforge/fluids/Fluid;", "setSteam", "(Lnet/minecraftforge/fluids/Fluid;)V", "getName", "", "onLoaded", "", "onTick", "WaterPower_main"})
public final class AttachmentSteam
extends TileEntityAttachment {
    @Nullable
    private Fluid steam;
    @NotNull
    private final EnergyStorage energyStorage;
    @NotNull
    private final FluidTank fluidTank;

    @Nullable
    public final Fluid getSteam() {
        return this.steam;
    }

    public final void setSteam(@Nullable Fluid fluid) {
        this.steam = fluid;
    }

    @Override
    @NotNull
    public String getName() {
        return "steam";
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.steam = FluidRegistry.isFluidRegistered((String)"steam") ? FluidRegistry.getFluid((String)"steam") : (FluidRegistry.isFluidRegistered((String)"ic2steam") ? FluidRegistry.getFluid((String)"ic2steam") : (Fluid)null);
    }

    @Override
    public void onTick() {
        if (this.steam == null) {
            return;
        }
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (Intrinsics.areEqual((Object)(fluidStack != null ? fluidStack.getFluid() : null), (Object)this.steam) ^ true) {
            this.fluidTank.setFluid((FluidStack)null);
        }
        int remain = this.fluidTank.fill(new FluidStack(this.steam, (int)Energy.Companion.EU2Steam(this.energyStorage.getMaxEnergyExtracted())), false);
        double output = this.energyStorage.extractEnergy(Energy.Companion.Steam2EU(remain), true);
        this.fluidTank.fill(new FluidStack(this.steam, (int)Energy.Companion.EU2Steam(output)), true);
    }

    @NotNull
    public final EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @NotNull
    public final FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public AttachmentSteam(@NotNull TileEntityBase te, @NotNull EnergyStorage energyStorage, @NotNull FluidTank fluidTank) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)te), (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)energyStorage, (String)"energyStorage");
        Intrinsics.checkParameterIsNotNull((Object)fluidTank, (String)"fluidTank");
        super(te);
        this.energyStorage = energyStorage;
        this.fluidTank = fluidTank;
    }
}

