/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.attachment;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import waterpower.common.Energy;
import waterpower.util.INBTSerializable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\tJ\u0018\u0010!\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020#2\u0006\u0010\"\u001a\u00020\tH\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010&\u001a\u00020#J\u0006\u0010'\u001a\u00020#J\u0006\u0010(\u001a\u00020#J\u0006\u0010)\u001a\u00020#J\u0006\u0010*\u001a\u00020\u0004J\b\u0010+\u001a\u00020#H\u0016J\u0016\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\tJ\u0018\u0010,\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020#2\u0006\u0010\"\u001a\u00020\tH\u0016J\b\u0010-\u001a\u00020 H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011\u00a8\u0006."}, d2={"Lwaterpower/common/block/attachment/EnergyStorage;", "Lnet/minecraftforge/energy/IEnergyStorage;", "Lwaterpower/util/INBTSerializable;", "capacity", "", "maxReceive", "maxExtract", "(DDD)V", "active", "", "getActive", "()Z", "setActive", "(Z)V", "getCapacity", "()D", "setCapacity", "(D)V", "energy", "getEnergy", "setEnergy", "getMaxExtract", "setMaxExtract", "getMaxReceive", "setMaxReceive", "canExtract", "canReceive", "clone", "", "deserializeNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "extractEnergy", "simulate", "", "getEnergyStored", "getEnergyStoredEU", "getEnergyStoredMJ", "getEnergyStoredRF", "getEnergyStoredSteam", "getEnergyStoredWater", "getMaxEnergyExtracted", "getMaxEnergyStored", "receiveEnergy", "serializeNBT", "WaterPower_main"})
public final class EnergyStorage
implements IEnergyStorage,
INBTSerializable<EnergyStorage> {
    private double energy;
    private boolean active;
    private double capacity;
    private double maxReceive;
    private double maxExtract;

    protected final double getEnergy() {
        return this.energy;
    }

    protected final void setEnergy(double d) {
        this.energy = d;
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl) {
        this.active = bl;
    }

    public final double receiveEnergy(double maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0.0;
        }
        double d = this.capacity - this.energy;
        double d2 = this.maxReceive;
        d2 = Math.min(d2, maxReceive);
        double energyReceived = Math.min(d, d2);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.receiveEnergy((double)maxReceive, simulate);
    }

    public final double extractEnergy(double maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0.0;
        }
        double d = this.getMaxEnergyExtracted();
        double energyExtracted = Math.min(d, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.extractEnergy((double)maxExtract, simulate);
    }

    public final double getMaxEnergyExtracted() {
        double d = this.energy;
        double d2 = this.maxExtract;
        return Math.min(d, d2);
    }

    public int getEnergyStored() {
        return (int)this.energy;
    }

    public int getMaxEnergyStored() {
        return (int)this.capacity;
    }

    public boolean canExtract() {
        return this.active && this.maxExtract > 0.0;
    }

    public boolean canReceive() {
        return this.active && this.maxReceive > 0.0;
    }

    public final double getEnergyStoredEU() {
        return this.energy;
    }

    public final int getEnergyStoredMJ() {
        return (int)Energy.Companion.EU2MJ(this.energy);
    }

    public final int getEnergyStoredRF() {
        return (int)Energy.Companion.EU2RF(this.energy);
    }

    public final int getEnergyStoredWater() {
        return (int)Energy.Companion.EU2Water(this.energy);
    }

    public final int getEnergyStoredSteam() {
        return (int)Energy.Companion.EU2Steam(this.energy);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("energy", this.energy);
        tag.func_74780_a("capacity", this.capacity);
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (tag.func_74764_b("energy")) {
            this.energy = tag.func_74769_h("energy");
        }
        if (tag.func_74764_b("capacity")) {
            this.capacity = tag.func_74769_h("capacity");
        }
    }

    @Override
    @NotNull
    public Object clone() {
        EnergyStorage v = new EnergyStorage(0.0, 0.0, 0.0, 7, null);
        v.deserializeNBT(this.serializeNBT());
        return v;
    }

    public final double getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(double d) {
        this.capacity = d;
    }

    public final double getMaxReceive() {
        return this.maxReceive;
    }

    public final void setMaxReceive(double d) {
        this.maxReceive = d;
    }

    public final double getMaxExtract() {
        return this.maxExtract;
    }

    public final void setMaxExtract(double d) {
        this.maxExtract = d;
    }

    public EnergyStorage(double capacity, double maxReceive, double maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.active = true;
    }

    public /* synthetic */ EnergyStorage(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = d2;
        }
        this(d, d2, d3);
    }

    public EnergyStorage() {
        this(0.0, 0.0, 0.0, 7, null);
    }
}

