/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.inventory;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;
import waterpower.common.block.tile.TileEntityInventory;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002:;B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0016J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0016J\u0006\u0010'\u001a\u00020(J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\nJ\u0013\u0010*\u001a\u00020\u00022\b\b\u0002\u0010)\u001a\u00020\nH\u0086\u0002J\u0006\u0010+\u001a\u00020#J\u0019\u0010,\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0002\u0010-J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/H\u0096\u0002J\u0006\u00100\u001a\u00020(J\u0006\u00101\u001a\u00020(J\u0016\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0002J\u000e\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020\u0002J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u00020\nJ\b\u00108\u001a\u00020\u0006H\u0016J\u000e\u00109\u001a\u00020(2\u0006\u00105\u001a\u000206R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006<"}, d2={"Lwaterpower/common/block/inventory/InventorySlot;", "", "Lnet/minecraft/item/ItemStack;", "tileEntity", "Lwaterpower/common/block/tile/TileEntityInventory;", "name", "", "access", "Lwaterpower/common/block/inventory/InventorySlot$Access;", "count", "", "preferredSide", "Lwaterpower/common/block/inventory/InventorySlot$InvSide;", "(Lwaterpower/common/block/tile/TileEntityInventory;Ljava/lang/String;Lwaterpower/common/block/inventory/InventorySlot$Access;ILwaterpower/common/block/inventory/InventorySlot$InvSide;)V", "getAccess", "()Lwaterpower/common/block/inventory/InventorySlot$Access;", "contents", "", "getContents", "()[Lnet/minecraft/item/ItemStack;", "[Lnet/minecraft/item/ItemStack;", "copiedContent", "getCopiedContent", "getName", "()Ljava/lang/String;", "getPreferredSide", "()Lwaterpower/common/block/inventory/InventorySlot$InvSide;", "stackSizeLimit", "getStackSizeLimit", "()I", "setStackSizeLimit", "(I)V", "getTileEntity", "()Lwaterpower/common/block/tile/TileEntityInventory;", "accepts", "", "stack", "canInput", "canOutput", "clear", "", "index", "get", "isEmpty", "isEquals", "([Lnet/minecraft/item/ItemStack;)Z", "iterator", "", "markDirty", "organize", "put", "content", "readFromNBT", "nbtTagCompound", "Lnet/minecraft/nbt/NBTTagCompound;", "size", "toString", "writeToNBT", "Access", "InvSide", "WaterPower_main"})
public class InventorySlot
implements Iterable<ItemStack>,
KMappedMarker {
    @NotNull
    private final ItemStack[] contents;
    private int stackSizeLimit;
    @NotNull
    private final TileEntityInventory tileEntity;
    @NotNull
    private final String name;
    @NotNull
    private final Access access;
    @NotNull
    private final InvSide preferredSide;

    @NotNull
    protected final ItemStack[] getContents() {
        return this.contents;
    }

    public final int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public final void setStackSizeLimit(int n) {
        this.stackSizeLimit = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void readFromNBT(@NotNull NBTTagCompound nbtTagCompound) {
        Intrinsics.checkParameterIsNotNull((Object)nbtTagCompound, (String)"nbtTagCompound");
        NBTTagList contentsTag = nbtTagCompound.func_150295_c("Contents", 10);
        int n = 0;
        int n2 = contentsTag.func_74745_c() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                NBTTagCompound contentTag = contentsTag.func_150305_b((int)i);
                int index = contentTag.func_74771_c("Index") & 0xFF;
                ItemStack itemStack = new ItemStack(contentTag);
                this.put(index, itemStack);
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeToNBT(@NotNull NBTTagCompound nbtTagCompound) {
        Intrinsics.checkParameterIsNotNull((Object)nbtTagCompound, (String)"nbtTagCompound");
        NBTTagList contentsTag = new NBTTagList();
        int n = 0;
        int n2 = this.contents.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (!StackUtilKt.isStackEmpty(this.contents[i])) {
                    NBTTagCompound contentTag = new NBTTagCompound();
                    contentTag.func_74774_a("Index", (byte)i);
                    this.contents[i].func_77955_b(contentTag);
                    contentsTag.func_74742_a((NBTBase)contentTag);
                }
                if (i == n2) break;
                ++i;
            }
        }
        nbtTagCompound.func_74782_a("Contents", (NBTBase)contentsTag);
    }

    public final int size() {
        return ((Object[])this.contents).length;
    }

    @NotNull
    public final ItemStack get(int index) {
        return this.contents[index];
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ItemStack get$default(InventorySlot inventorySlot, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return inventorySlot.get(n);
    }

    public final void put(@NotNull ItemStack content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.put(0, content);
    }

    public final void put(int index, @NotNull ItemStack content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.contents[index] = content;
    }

    public final void clear() {
        Arrays.fill(this.contents, StackUtilKt.getEmptyStack());
    }

    public final void clear(int index) {
        this.put(index, StackUtilKt.getEmptyStack());
    }

    public boolean accepts(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    public final void markDirty() {
    }

    public boolean canInput() {
        return Intrinsics.areEqual((Object)((Object)this.access), (Object)((Object)Access.I)) || Intrinsics.areEqual((Object)((Object)this.access), (Object)((Object)Access.IO));
    }

    public boolean canOutput() {
        return Intrinsics.areEqual((Object)((Object)this.access), (Object)((Object)Access.O)) || Intrinsics.areEqual((Object)((Object)this.access), (Object)((Object)Access.IO));
    }

    public final boolean isEmpty() {
        ItemStack[] itemStackArray = this.contents;
        for (int i = 0; i < itemStackArray.length; ++i) {
            ItemStack itemStack = itemStackArray[i];
            if (StackUtilKt.isStackEmpty(itemStack)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void organize() {
        int n = 0;
        int n2 = ((Object[])this.contents).length - 1 - 1;
        if (n <= n2) {
            while (true) {
                int n3;
                void var4_4;
                void dstIndex;
                ItemStack dst;
                if ((StackUtilKt.isStackEmpty(dst = this.contents[dstIndex]) || StackUtilKt.getCount(dst) < dst.func_77976_d()) && (var4_4 = dstIndex + true) <= (n3 = ((Object[])this.contents).length - 1)) {
                    while (true) {
                        void srcIndex;
                        ItemStack src;
                        if (!StackUtilKt.isStackEmpty(src = this.contents[srcIndex])) {
                            if (StackUtilKt.isStackEmpty(dst)) {
                                ItemStack tmp;
                                this.contents[srcIndex] = StackUtilKt.getEmptyStack();
                                dst = tmp = src;
                                this.contents[dstIndex] = tmp;
                            } else if (StackUtilKt.isStackEqual(dst, src)) {
                                int space = dst.func_77976_d() - StackUtilKt.getCount(dst);
                                if (StackUtilKt.getCount(src) <= space) {
                                    this.contents[srcIndex] = StackUtilKt.getEmptyStack();
                                    dst = StackUtilKt.grow(dst, StackUtilKt.getCount(src));
                                } else {
                                    src = StackUtilKt.shrink$default(src, 0, 2, null);
                                    dst = StackUtilKt.grow$default(dst, 0, 2, null);
                                    break;
                                }
                            }
                        }
                        if (srcIndex == n3) break;
                        ++srcIndex;
                    }
                }
                if (dstIndex == n2) break;
                ++dstIndex;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String ret = this.name + "[" + ((Object[])this.contents).length + "]: ";
        int n = 0;
        int n2 = this.contents.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                ret = ret + this.contents[i];
                if (i < ((Object[])this.contents).length - 1) {
                    ret = ret + ", ";
                }
                if (i == n2) break;
                ++i;
            }
        }
        return ret;
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(this){
            private int idx;
            final /* synthetic */ InventorySlot this$0;

            public final int getIdx() {
                return this.idx;
            }

            public final void setIdx(int n) {
                this.idx = n;
            }

            @NotNull
            public ItemStack next() {
                if (this.idx >= ((Object[])this.this$0.getContents()).length) {
                    throw (Throwable)new NoSuchElementException();
                }
                int n = this.idx;
                this.idx = n + 1;
                return this.this$0.getContents()[n];
            }

            public boolean hasNext() {
                return this.idx < ((Object[])this.this$0.getContents()).length;
            }
            {
                this.this$0 = $outer;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @NotNull
    public final ItemStack[] getCopiedContent() {
        return StackUtilKt.getCopiedStacks(this.contents);
    }

    public final boolean isEquals(@NotNull ItemStack[] stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return StackUtilKt.isStacksEqual(stack, this.contents);
    }

    @NotNull
    public final TileEntityInventory getTileEntity() {
        return this.tileEntity;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected final Access getAccess() {
        return this.access;
    }

    @NotNull
    public final InvSide getPreferredSide() {
        return this.preferredSide;
    }

    /*
     * WARNING - void declaration
     */
    public InventorySlot(@NotNull TileEntityInventory tileEntity, @NotNull String name, @NotNull Access access, int count, @NotNull InvSide preferredSide) {
        ItemStack[] itemStackArray;
        Intrinsics.checkParameterIsNotNull((Object)((Object)tileEntity), (String)"tileEntity");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)access), (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)((Object)preferredSide), (String)"preferredSide");
        this.tileEntity = tileEntity;
        this.name = name;
        this.access = access;
        this.preferredSide = preferredSide;
        InventorySlot inventorySlot = this;
        ItemStack[] result$iv = new ItemStack[count];
        int n = 0;
        int n2 = count - 1;
        if (n <= n2) {
            void i$iv;
            do {
                ItemStack itemStack;
                void var9_10 = ++i$iv;
                void var14_12 = i$iv;
                itemStackArray = result$iv;
                itemStackArray[var14_12] = itemStack = StackUtilKt.getEmptyStack();
            } while (i$iv != n2);
        }
        itemStackArray = result$iv;
        inventorySlot.contents = itemStackArray;
        this.stackSizeLimit = 64;
        this.tileEntity.addInvSlot(this);
    }

    public /* synthetic */ InventorySlot(TileEntityInventory tileEntityInventory, String string, Access access, int n, InvSide invSide, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            invSide = InvSide.ANY;
        }
        this(tileEntityInventory, string, access, n, invSide);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lwaterpower/common/block/inventory/InventorySlot$InvSide;", "", "acceptedSides", "", "Lnet/minecraft/util/EnumFacing;", "(Ljava/lang/String;ILjava/util/Set;)V", "getAcceptedSides", "()Ljava/util/Set;", "matches", "", "side", "ANY", "TOP", "BOTTOM", "SIDE", "NOTSIDE", "WaterPower_main"})
    public static final class InvSide
    extends Enum<InvSide> {
        public static final /* enum */ InvSide ANY;
        public static final /* enum */ InvSide TOP;
        public static final /* enum */ InvSide BOTTOM;
        public static final /* enum */ InvSide SIDE;
        public static final /* enum */ InvSide NOTSIDE;
        private static final /* synthetic */ InvSide[] $VALUES;
        @NotNull
        private final Set<EnumFacing> acceptedSides;

        static {
            InvSide[] invSideArray = new InvSide[5];
            InvSide[] invSideArray2 = invSideArray;
            invSideArray[0] = ANY = new InvSide(SetsKt.setOf((Object[])new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}));
            invSideArray[1] = TOP = new InvSide(SetsKt.setOf((Object)EnumFacing.UP));
            invSideArray[2] = BOTTOM = new InvSide(SetsKt.setOf((Object)EnumFacing.DOWN));
            invSideArray[3] = SIDE = new InvSide(SetsKt.setOf((Object[])new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}));
            invSideArray[4] = NOTSIDE = new InvSide(SetsKt.emptySet());
            $VALUES = invSideArray;
        }

        public final boolean matches(@NotNull EnumFacing side) {
            Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
            return this.acceptedSides.contains(side);
        }

        @NotNull
        public final Set<EnumFacing> getAcceptedSides() {
            return this.acceptedSides;
        }

        protected InvSide(Set<? extends EnumFacing> acceptedSides) {
            Intrinsics.checkParameterIsNotNull(acceptedSides, (String)"acceptedSides");
            this.acceptedSides = acceptedSides;
        }

        public static InvSide[] values() {
            return (InvSide[])$VALUES.clone();
        }

        public static InvSide valueOf(String string) {
            return Enum.valueOf(InvSide.class, string);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lwaterpower/common/block/inventory/InventorySlot$Access;", "", "(Ljava/lang/String;I)V", "isInput", "", "isOutput", "NONE", "I", "O", "IO", "WaterPower_main"})
    public static final class Access
    extends Enum<Access> {
        public static final /* enum */ Access NONE;
        public static final /* enum */ Access I;
        public static final /* enum */ Access O;
        public static final /* enum */ Access IO;
        private static final /* synthetic */ Access[] $VALUES;

        static {
            Access[] accessArray = new Access[4];
            Access[] accessArray2 = accessArray;
            accessArray[0] = NONE = new Access();
            accessArray[1] = I = new Access();
            accessArray[2] = O = new Access();
            accessArray[3] = IO = new Access();
            $VALUES = accessArray;
        }

        public final boolean isInput() {
            return Intrinsics.areEqual((Object)((Object)this), (Object)((Object)I)) || Intrinsics.areEqual((Object)((Object)this), (Object)((Object)IO));
        }

        public final boolean isOutput() {
            return Intrinsics.areEqual((Object)((Object)this), (Object)((Object)O)) || Intrinsics.areEqual((Object)((Object)this), (Object)((Object)IO));
        }

        public static Access[] values() {
            return (Access[])$VALUES.clone();
        }

        public static Access valueOf(String string) {
            return Enum.valueOf(Access.class, string);
        }
    }
}

