/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.inventory;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.block.inventory.InventorySlot;
import waterpower.common.block.inventory.InventorySlotConsumable;
import waterpower.common.block.inventory.InventorySlotOutput;
import waterpower.common.block.tile.TileEntityInventory;
import waterpower.util.FluidContainerOutputMode;
import waterpower.util.FluidOperationResult;
import waterpower.util.FluidUtilKt;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001.B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0012H\u0004J0\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010 \u001a\u00020\u0016J&\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010 \u001a\u00020\u0016J\u0016\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000eJ$\u0010,\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010 \u001a\u00020\u0016J$\u0010-\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010 \u001a\u00020\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lwaterpower/common/block/inventory/InventorySlotConsumableLiquid;", "Lwaterpower/common/block/inventory/InventorySlotConsumable;", "base", "Lwaterpower/common/block/tile/TileEntityInventory;", "name", "", "count", "", "(Lwaterpower/common/block/tile/TileEntityInventory;Ljava/lang/String;I)V", "access", "Lwaterpower/common/block/inventory/InventorySlot$Access;", "preferredSide", "Lwaterpower/common/block/inventory/InventorySlot$InvSide;", "opType", "Lwaterpower/common/block/inventory/InventorySlotConsumableLiquid$OpType;", "(Lwaterpower/common/block/tile/TileEntityInventory;Ljava/lang/String;Lwaterpower/common/block/inventory/InventorySlot$Access;ILwaterpower/common/block/inventory/InventorySlot$InvSide;Lwaterpower/common/block/inventory/InventorySlotConsumableLiquid$OpType;)V", "possibleFluids", "", "Lnet/minecraftforge/fluids/Fluid;", "getPossibleFluids", "()Ljava/lang/Iterable;", "accepts", "", "stack", "Lnet/minecraft/item/ItemStack;", "acceptsLiquid", "fluid", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxAmount", "output", "Lorg/apache/commons/lang3/mutable/MutableObject;", "simulate", "fill", "fs", "processFromTank", "tank", "Lnet/minecraftforge/fluids/IFluidTank;", "outputSlot", "Lwaterpower/common/block/inventory/InventorySlotOutput;", "processIntoTank", "setOpType", "", "opType1", "transferFromTank", "transferToTank", "OpType", "WaterPower_main"})
public final class InventorySlotConsumableLiquid
extends InventorySlotConsumable {
    private OpType opType;

    @Override
    public boolean accepts(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (StackUtilKt.isStackEmpty(stack)) {
            return false;
        }
        if (!FluidUtilKt.isFluidContainer(stack)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Drain)) || Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Both))) {
            ItemStack singleStack;
            IFluidHandlerItem handler;
            FluidStack containerFluid = null;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)(singleStack = StackUtilKt.copyWithNewCount(stack, 1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                containerFluid = handler.drain(Integer.MAX_VALUE, false);
            }
            if (containerFluid != null && containerFluid.amount > 0) {
                Fluid fluid = containerFluid.getFluid();
                Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"containerFluid.fluid");
                if (this.acceptsLiquid(fluid)) {
                    return true;
                }
            }
        }
        return (Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Fill)) || Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Both))) && FluidUtilKt.isFillableFluidContainer(stack, this.getPossibleFluids());
    }

    @Nullable
    public final FluidStack drain(@Nullable Fluid fluid, int maxAmount, @NotNull MutableObject<ItemStack> output, boolean simulate) {
        Intrinsics.checkParameterIsNotNull(output, (String)"output");
        output.setValue(null);
        if (fluid != null && !this.acceptsLiquid(fluid)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Drain)) ^ true && Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Both)) ^ true) {
            return null;
        }
        ItemStack stack = InventorySlot.get$default(this, 0, 1, null);
        if (StackUtilKt.isStackEmpty(stack)) {
            return null;
        }
        FluidOperationResult fluidOperationResult = FluidUtilKt.drainContainer(stack, fluid, maxAmount, FluidContainerOutputMode.EmptyFullToOutput);
        if (fluidOperationResult == null) {
            return null;
        }
        FluidOperationResult result = fluidOperationResult;
        if (fluid == null) {
            Fluid fluid2 = result.getFluidChange().getFluid();
            Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"result.fluidChange.fluid");
            if (!this.acceptsLiquid(fluid2)) {
                return null;
            }
        }
        output.setValue((Object)result.getExtraOutput());
        if (!simulate) {
            this.put(result.getInPlaceOutput());
        }
        return result.getFluidChange();
    }

    public final int fill(@Nullable FluidStack fs, @NotNull MutableObject<ItemStack> output, boolean simulate) {
        Intrinsics.checkParameterIsNotNull(output, (String)"output");
        output.setValue(null);
        if (fs == null || fs.amount <= 0) {
            return 0;
        }
        if (Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Fill)) ^ true && Intrinsics.areEqual((Object)((Object)this.opType), (Object)((Object)OpType.Both)) ^ true) {
            return 0;
        }
        ItemStack stack = InventorySlot.get$default(this, 0, 1, null);
        if (StackUtilKt.isStackEmpty(stack)) {
            return 0;
        }
        FluidOperationResult fluidOperationResult = FluidUtilKt.fillContainer(stack, fs, FluidContainerOutputMode.EmptyFullToOutput);
        if (fluidOperationResult == null) {
            return 0;
        }
        FluidOperationResult result = fluidOperationResult;
        output.setValue((Object)result.getExtraOutput());
        if (!simulate) {
            this.put(result.getInPlaceOutput());
        }
        return result.getFluidChange().amount;
    }

    public final boolean transferToTank(@NotNull IFluidTank tank, @NotNull MutableObject<ItemStack> output, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        Intrinsics.checkParameterIsNotNull(output, (String)"output");
        int space = tank.getCapacity();
        Fluid fluidRequired = null;
        FluidStack tankFluid = tank.getFluid();
        if (tankFluid != null) {
            space -= tankFluid.amount;
            fluidRequired = tankFluid.getFluid();
        }
        FluidStack fluidStack = this.drain(fluidRequired, space, output, true);
        if (fluidStack == null) {
            return false;
        }
        FluidStack fluid = fluidStack;
        int amount = tank.fill(fluid, !simulate);
        if (amount <= 0) {
            return false;
        }
        if (!simulate) {
            this.drain(fluidRequired, amount, output, false);
        }
        return true;
    }

    public final boolean transferFromTank(@NotNull IFluidTank tank, @NotNull MutableObject<ItemStack> output, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        Intrinsics.checkParameterIsNotNull(output, (String)"output");
        FluidStack tankFluid = tank.drain(tank.getFluidAmount(), false);
        if (tankFluid == null || tankFluid.amount <= 0) {
            return false;
        }
        int amount = this.fill(tankFluid, output, simulate);
        if (amount <= 0) {
            return false;
        }
        if (!simulate) {
            tank.drain(amount, true);
        }
        return true;
    }

    public final boolean processIntoTank(@NotNull IFluidTank tank, @NotNull InventorySlotOutput outputSlot) {
        boolean wasChange;
        block5: {
            MutableObject output;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
                Intrinsics.checkParameterIsNotNull((Object)outputSlot, (String)"outputSlot");
                if (this.isEmpty()) {
                    return false;
                }
                output = new MutableObject();
                wasChange = false;
                if (!this.transferToTank(tank, (MutableObject<ItemStack>)output, true)) break block5;
                if (StackUtilKt.isStackEmpty((ItemStack)output.getValue())) break block6;
                Object object = output.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"output.value");
                if (!outputSlot.canAdd((ItemStack)object)) break block5;
            }
            wasChange = this.transferToTank(tank, (MutableObject<ItemStack>)output, false);
            if (!StackUtilKt.isStackEmpty((ItemStack)output.getValue())) {
                Object object = output.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"output.value");
                outputSlot.add((ItemStack)object);
            }
        }
        return wasChange;
    }

    public final boolean processFromTank(@NotNull IFluidTank tank, @NotNull InventorySlotOutput outputSlot) {
        boolean wasChange;
        block5: {
            MutableObject output;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
                Intrinsics.checkParameterIsNotNull((Object)outputSlot, (String)"outputSlot");
                if (this.isEmpty() || tank.getFluidAmount() <= 0) {
                    return false;
                }
                output = new MutableObject();
                wasChange = false;
                if (!this.transferFromTank(tank, (MutableObject<ItemStack>)output, true)) break block5;
                if (StackUtilKt.isStackEmpty((ItemStack)output.getValue())) break block6;
                Object object = output.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"output.value");
                if (!outputSlot.canAdd((ItemStack)object)) break block5;
            }
            wasChange = this.transferFromTank(tank, (MutableObject<ItemStack>)output, false);
            if (!StackUtilKt.isStackEmpty((ItemStack)output.getValue())) {
                Object object = output.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"output.value");
                outputSlot.add((ItemStack)object);
            }
        }
        return wasChange;
    }

    public final void setOpType(@NotNull OpType opType1) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)opType1), (String)"opType1");
        this.opType = opType1;
    }

    protected final boolean acceptsLiquid(@NotNull Fluid fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        return true;
    }

    @Nullable
    protected final Iterable<Fluid> getPossibleFluids() {
        return null;
    }

    public InventorySlotConsumableLiquid(@NotNull TileEntityInventory base, @NotNull String name, @NotNull InventorySlot.Access access, int count, @NotNull InventorySlot.InvSide preferredSide, @NotNull OpType opType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)base), (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)access), (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)((Object)preferredSide), (String)"preferredSide");
        Intrinsics.checkParameterIsNotNull((Object)((Object)opType), (String)"opType");
        super(base, name, access, count, preferredSide);
        this.opType = opType;
    }

    public /* synthetic */ InventorySlotConsumableLiquid(TileEntityInventory tileEntityInventory, String string, InventorySlot.Access access, int n, InventorySlot.InvSide invSide, OpType opType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            invSide = InventorySlot.InvSide.TOP;
        }
        if ((n2 & 0x20) != 0) {
            opType = OpType.Drain;
        }
        this(tileEntityInventory, string, access, n, invSide, opType);
    }

    public InventorySlotConsumableLiquid(@NotNull TileEntityInventory base, @NotNull String name, int count) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)base), (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this(base, name, InventorySlot.Access.I, count, null, null, 48, null);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lwaterpower/common/block/inventory/InventorySlotConsumableLiquid$OpType;", "", "(Ljava/lang/String;I)V", "Drain", "Fill", "Both", "None", "WaterPower_main"})
    public static final class OpType
    extends Enum<OpType> {
        public static final /* enum */ OpType Drain;
        public static final /* enum */ OpType Fill;
        public static final /* enum */ OpType Both;
        public static final /* enum */ OpType None;
        private static final /* synthetic */ OpType[] $VALUES;

        static {
            OpType[] opTypeArray = new OpType[4];
            OpType[] opTypeArray2 = opTypeArray;
            opTypeArray[0] = Drain = new OpType();
            opTypeArray[1] = Fill = new OpType();
            opTypeArray[2] = Both = new OpType();
            opTypeArray[3] = None = new OpType();
            $VALUES = opTypeArray;
        }

        public static OpType[] values() {
            return (OpType[])$VALUES.clone();
        }

        public static OpType valueOf(String string) {
            return Enum.valueOf(OpType.class, string);
        }
    }
}

