/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.inventory;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.block.inventory.InventorySlot;
import waterpower.common.block.inventory.InventorySlotProcessable;
import waterpower.common.block.tile.TileEntityInventory;
import waterpower.common.recipe.IRecipeManager;
import waterpower.common.recipe.RecipeOutput;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0004J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lwaterpower/common/block/inventory/InventorySlotProcessableGeneric;", "Lwaterpower/common/block/inventory/InventorySlotProcessable;", "base", "Lwaterpower/common/block/tile/TileEntityInventory;", "name", "", "count", "", "recipeManager", "Lwaterpower/common/recipe/IRecipeManager;", "(Lwaterpower/common/block/tile/TileEntityInventory;Ljava/lang/String;ILwaterpower/common/recipe/IRecipeManager;)V", "getRecipeManager", "()Lwaterpower/common/recipe/IRecipeManager;", "setRecipeManager", "(Lwaterpower/common/recipe/IRecipeManager;)V", "accepts", "", "stack", "Lnet/minecraft/item/ItemStack;", "allowEmptyInput", "consume", "", "getOutput", "Lwaterpower/common/recipe/RecipeOutput;", "input", "adjustInput", "forAccept", "getRecipeOutput", "process", "WaterPower_main"})
public final class InventorySlotProcessableGeneric
extends InventorySlotProcessable {
    @NotNull
    private IRecipeManager recipeManager;

    @Override
    public boolean accepts(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        ItemStack tmp = StackUtilKt.set(stack.func_77946_l(), Integer.MAX_VALUE);
        return this.getOutput(tmp, false, true) != null;
    }

    @Override
    @Nullable
    public RecipeOutput process() {
        ItemStack input = InventorySlot.get$default(this, 0, 1, null);
        if (StackUtilKt.isStackEmpty(input) && !this.allowEmptyInput()) {
            return null;
        }
        RecipeOutput recipeOutput = this.getOutput(input, false, false);
        if (recipeOutput == null) {
            return null;
        }
        RecipeOutput output = recipeOutput;
        ArrayList<ItemStack> itemsCopy = new ArrayList<ItemStack>(output.getItems().size());
        for (ItemStack itemStack : output.getItems()) {
            itemsCopy.add(itemStack.func_77946_l());
        }
        return new RecipeOutput((Collection<ItemStack>)itemsCopy);
    }

    @Override
    public void consume() {
        ItemStack input = InventorySlot.get$default(this, 0, 1, null);
        if (StackUtilKt.isStackEmpty(input) && !this.allowEmptyInput()) {
            throw (Throwable)new IllegalStateException("consume from empty slot");
        }
        RecipeOutput recipeOutput = this.getOutput(input, true, false);
        if (recipeOutput == null) {
            throw (Throwable)new IllegalStateException("consume without a processing result");
        }
        RecipeOutput output = recipeOutput;
        if (StackUtilKt.isStackEmpty(input)) {
            this.clear();
        }
    }

    @Nullable
    protected final RecipeOutput getOutput(@NotNull ItemStack input, boolean adjustInput, boolean forAccept) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.recipeManager.getOutput(input, adjustInput);
    }

    @Nullable
    public final RecipeOutput getRecipeOutput() {
        ItemStack input = InventorySlot.get$default(this, 0, 1, null);
        if (StackUtilKt.isStackEmpty(input)) {
            return null;
        }
        return this.getOutput(input, false, false);
    }

    protected final boolean allowEmptyInput() {
        return false;
    }

    @NotNull
    public final IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public final void setRecipeManager(@NotNull IRecipeManager iRecipeManager) {
        Intrinsics.checkParameterIsNotNull((Object)iRecipeManager, (String)"<set-?>");
        this.recipeManager = iRecipeManager;
    }

    public InventorySlotProcessableGeneric(@NotNull TileEntityInventory base, @NotNull String name, int count, @NotNull IRecipeManager recipeManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)base), (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)recipeManager, (String)"recipeManager");
        super(base, name, count);
        this.recipeManager = recipeManager;
    }
}

