/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.machine;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.SaveNBT;
import waterpower.annotations.Sync;
import waterpower.api.IUpgrade;
import waterpower.api.IWaterReceiver;
import waterpower.api.WaterAPI;
import waterpower.common.block.attachment.EnergyStorage;
import waterpower.common.block.inventory.InventorySlotOutput;
import waterpower.common.block.inventory.InventorySlotProcessable;
import waterpower.common.block.inventory.InventorySlotUpgrade;
import waterpower.common.block.tile.TileEntityBase;
import waterpower.common.block.tile.TileEntityInventory;
import waterpower.common.recipe.RecipeOutput;
import waterpower.util.StackUtilKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020JH\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0014J\b\u0010R\u001a\u00020OH\u0014J-\u0010S\u001a\u0004\u0018\u0001HT\"\u0004\b\u0000\u0010T2\f\u0010U\u001a\b\u0012\u0004\u0012\u0002HT0V2\b\u0010W\u001a\u0004\u0018\u00010XH\u0016\u00a2\u0006\u0002\u0010YJ\u0006\u0010\u0010\u001a\u00020ZJ\b\u0010[\u001a\u0004\u0018\u00010QJ\u000e\u0010[\u001a\u00020(2\u0006\u0010\\\u001a\u00020\u0003J\u0006\u0010]\u001a\u00020\u0003J\u0006\u0010;\u001a\u00020\u0016J\u001e\u0010^\u001a\u00020\"2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030V2\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\b\u0010_\u001a\u00020OH\u0016J\b\u0010`\u001a\u00020OH\u0016J\u000e\u0010a\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u001c\u0010b\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020(0dJ\u0016\u0010e\u001a\u00020O2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010f\u001a\u00020(J\u0006\u0010g\u001a\u00020OJ\b\u0010h\u001a\u00020OH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0016\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\fR\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010-\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\b\"\u0004\b0\u0010\fR\u001a\u00101\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\b\"\u0004\b3\u0010\fR\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\bR\u001e\u00109\u001a\u00020:8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006i"}, d2={"Lwaterpower/common/block/machine/TileEntityBaseMachine;", "Lwaterpower/common/block/tile/TileEntityInventory;", "defaultEnergyConsume", "", "defaultOperationLength", "outputSlotCount", "(III)V", "getDefaultEnergyConsume", "()I", "defaultEnergyStorage", "getDefaultEnergyStorage", "setDefaultEnergyStorage", "(I)V", "getDefaultOperationLength", "energy", "Lwaterpower/common/block/attachment/EnergyStorage;", "getEnergy", "()Lwaterpower/common/block/attachment/EnergyStorage;", "energyConsume", "getEnergyConsume", "setEnergyConsume", "guiProgress", "", "getGuiProgress", "()F", "setGuiProgress", "(F)V", "inputSlot", "Lwaterpower/common/block/inventory/InventorySlotProcessable;", "getInputSlot", "()Lwaterpower/common/block/inventory/InventorySlotProcessable;", "setInputSlot", "(Lwaterpower/common/block/inventory/InventorySlotProcessable;)V", "isLastFailed", "", "()Z", "setLastFailed", "(Z)V", "lastFailedContents", "", "Lnet/minecraft/item/ItemStack;", "getLastFailedContents", "()[Lnet/minecraft/item/ItemStack;", "setLastFailedContents", "([Lnet/minecraft/item/ItemStack;)V", "[Lnet/minecraft/item/ItemStack;", "operationLength", "getOperationLength", "setOperationLength", "operationsPerTick", "getOperationsPerTick", "setOperationsPerTick", "outputSlot", "Lwaterpower/common/block/inventory/InventorySlotOutput;", "getOutputSlot", "()Lwaterpower/common/block/inventory/InventorySlotOutput;", "getOutputSlotCount", "progress", "", "getProgress", "()S", "setProgress", "(S)V", "upgradeSlot", "Lwaterpower/common/block/inventory/InventorySlotUpgrade;", "getUpgradeSlot", "()Lwaterpower/common/block/inventory/InventorySlotUpgrade;", "waterReceiver", "Lwaterpower/api/IWaterReceiver;", "getWaterReceiver", "()Lwaterpower/api/IWaterReceiver;", "setWaterReceiver", "(Lwaterpower/api/IWaterReceiver;)V", "applyModifier", "", "base", "extra", "multiplier", "beginProcess", "", "output", "Lwaterpower/common/recipe/RecipeOutput;", "failedProcess", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "Lnet/minecraftforge/energy/IEnergyStorage;", "getOutput", "index", "getOutputSize", "hasCapability", "markDirty", "onLoaded", "operate", "operateOnce", "processResult", "", "setOutput", "stack", "setOverclockRates", "update", "WaterPower_main"})
public abstract class TileEntityBaseMachine
extends TileEntityInventory {
    @Sync
    private float guiProgress;
    @SaveNBT
    @Sync
    private short progress;
    @Sync
    private int energyConsume;
    private int defaultEnergyStorage;
    private int operationLength;
    private int operationsPerTick;
    @Sync
    @SaveNBT
    @NotNull
    private final EnergyStorage energy;
    @NotNull
    private IWaterReceiver waterReceiver;
    @NotNull
    public InventorySlotProcessable inputSlot;
    @NotNull
    private final InventorySlotOutput outputSlot;
    @NotNull
    private final InventorySlotUpgrade upgradeSlot;
    private boolean isLastFailed;
    @Nullable
    private ItemStack[] lastFailedContents;
    private final int defaultEnergyConsume;
    private final int defaultOperationLength;
    private final int outputSlotCount;

    public final float getGuiProgress() {
        return this.guiProgress;
    }

    public final void setGuiProgress(float f) {
        this.guiProgress = f;
    }

    public final short getProgress() {
        return this.progress;
    }

    public final void setProgress(short s) {
        this.progress = s;
    }

    public final int getEnergyConsume() {
        return this.energyConsume;
    }

    public final void setEnergyConsume(int n) {
        this.energyConsume = n;
    }

    public final int getDefaultEnergyStorage() {
        return this.defaultEnergyStorage;
    }

    public final void setDefaultEnergyStorage(int n) {
        this.defaultEnergyStorage = n;
    }

    public final int getOperationLength() {
        return this.operationLength;
    }

    public final void setOperationLength(int n) {
        this.operationLength = n;
    }

    public final int getOperationsPerTick() {
        return this.operationsPerTick;
    }

    public final void setOperationsPerTick(int n) {
        this.operationsPerTick = n;
    }

    @NotNull
    public final EnergyStorage getEnergy() {
        return this.energy;
    }

    @NotNull
    public final IWaterReceiver getWaterReceiver() {
        return this.waterReceiver;
    }

    public final void setWaterReceiver(@NotNull IWaterReceiver iWaterReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)iWaterReceiver, (String)"<set-?>");
        this.waterReceiver = iWaterReceiver;
    }

    @NotNull
    public final InventorySlotProcessable getInputSlot() {
        InventorySlotProcessable inventorySlotProcessable = this.inputSlot;
        if (inventorySlotProcessable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
        }
        return inventorySlotProcessable;
    }

    public final void setInputSlot(@NotNull InventorySlotProcessable inventorySlotProcessable) {
        Intrinsics.checkParameterIsNotNull((Object)inventorySlotProcessable, (String)"<set-?>");
        this.inputSlot = inventorySlotProcessable;
    }

    @NotNull
    public final InventorySlotOutput getOutputSlot() {
        return this.outputSlot;
    }

    @NotNull
    public final InventorySlotUpgrade getUpgradeSlot() {
        return this.upgradeSlot;
    }

    protected final boolean isLastFailed() {
        return this.isLastFailed;
    }

    protected final void setLastFailed(boolean bl) {
        this.isLastFailed = bl;
    }

    @Nullable
    protected final ItemStack[] getLastFailedContents() {
        return this.lastFailedContents;
    }

    protected final void setLastFailedContents(@Nullable ItemStack[] itemStackArray) {
        this.lastFailedContents = itemStackArray;
    }

    @Override
    public void onLoaded() {
        if (this.isServerSide()) {
            this.setOverclockRates();
        }
        super.onLoaded();
    }

    /*
     * WARNING - void declaration
     */
    public final void setOverclockRates() {
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int n = 0;
        int n2 = this.upgradeSlot.size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                ItemStack stack;
                if (!StackUtilKt.isStackEmpty(stack = this.upgradeSlot.get((int)i)) && stack.func_77973_b() instanceof IUpgrade) {
                    Item item = stack.func_77973_b();
                    if (item == null) {
                        throw new TypeCastException("null cannot be cast to non-null type waterpower.api.IUpgrade");
                    }
                    IUpgrade upgrade = (IUpgrade)item;
                    double count = StackUtilKt.getCount(stack);
                    processTimeMultiplier *= Math.pow(upgrade.getSpeedAdditionalValue(stack), count);
                    energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(stack), count);
                    extraEnergyStorage += upgrade.getStorageAdditionalValue(stack) * StackUtilKt.getCount(stack);
                    energyStorageMultiplier *= Math.pow(1.0, count);
                }
                if (i == n2) break;
                ++i;
            }
        }
        double previousProgress = 1.0 * (double)this.progress / (double)this.operationLength;
        double stackOpLen = (double)(this.defaultOperationLength + extraProcessTime) * 64.0 * processTimeMultiplier;
        double d = Math.ceil(64.0 / stackOpLen);
        double d2 = 2.147483647E9;
        TileEntityBaseMachine tileEntityBaseMachine = this;
        double d3 = Math.min(d, d2);
        tileEntityBaseMachine.operationsPerTick = (int)d3;
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = (int)this.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.energy.setCapacity(this.applyModifier(this.defaultEnergyStorage, extraEnergyStorage + this.operationLength * this.energyConsume, energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.isServerSide()) {
            this.setOverclockRates();
        }
    }

    public final float getProgress() {
        return this.guiProgress;
    }

    @Override
    public void func_73660_a() {
        boolean needsInvUpdate;
        block16: {
            RecipeOutput output;
            block15: {
                super.func_73660_a();
                if (!this.isServerSide()) {
                    return;
                }
                needsInvUpdate = false;
                if (!this.isLastFailed) break block15;
                InventorySlotProcessable inventorySlotProcessable = this.inputSlot;
                if (inventorySlotProcessable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
                }
                if (this.lastFailedContents == null) {
                    Intrinsics.throwNpe();
                }
                if (inventorySlotProcessable.isEquals(this.lastFailedContents)) break block16;
            }
            if ((output = this.getOutput()) != null && this.energy.getEnergyStored() >= this.energyConsume) {
                if (this.isLastFailed) {
                    this.beginProcess(output);
                    this.isLastFailed = false;
                }
                this.progress = (short)(this.progress + 1);
                this.energy.extractEnergy(this.energyConsume, false);
                if (this.progress >= this.operationLength) {
                    this.operate(output);
                    needsInvUpdate = true;
                    this.progress = 0;
                }
            } else if (output == null) {
                this.progress = 0;
                this.isLastFailed = true;
                InventorySlotProcessable inventorySlotProcessable = this.inputSlot;
                if (inventorySlotProcessable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
                }
                this.lastFailedContents = inventorySlotProcessable.getCopiedContent();
            }
            float tmp = this.guiProgress;
            if (this.isServerSide()) {
                this.guiProgress = (float)this.progress / (float)this.operationLength;
            }
            if ((double)Math.abs(tmp - this.guiProgress) > 0.001 && this.isServerSide()) {
                TileEntityBase.sendUpdateToClient$default(this, false, 1, null);
            }
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    protected void beginProcess(@NotNull RecipeOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
    }

    protected void failedProcess() {
    }

    /*
     * WARNING - void declaration
     */
    public final void operate(@NotNull RecipeOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        RecipeOutput o = output;
        int n = 0;
        int n2 = this.operationsPerTick - 1;
        if (n <= n2) {
            while (true) {
                void i;
                RecipeOutput newOutput;
                Collection<ItemStack> processResult = o.getItems();
                this.operateOnce(o, processResult);
                if (this.getOutput() == null) {
                    break;
                }
                o = newOutput;
                if (i == n2) break;
                ++i;
            }
        }
    }

    public final void operateOnce(@NotNull RecipeOutput output, @NotNull Collection<ItemStack> processResult) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(processResult, (String)"processResult");
        InventorySlotProcessable inventorySlotProcessable = this.inputSlot;
        if (inventorySlotProcessable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
        }
        inventorySlotProcessable.consume();
        this.outputSlot.add(processResult);
    }

    private final double applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? 2.147483647E9 : ret;
    }

    @Nullable
    public final RecipeOutput getOutput() {
        InventorySlotProcessable inventorySlotProcessable = this.inputSlot;
        if (inventorySlotProcessable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
        }
        if (inventorySlotProcessable.isEmpty()) {
            return null;
        }
        InventorySlotProcessable inventorySlotProcessable2 = this.inputSlot;
        if (inventorySlotProcessable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputSlot");
        }
        RecipeOutput recipeOutput = inventorySlotProcessable2.process();
        if (recipeOutput == null) {
            return null;
        }
        RecipeOutput output = recipeOutput;
        if (this.outputSlot.canAdd(output.getItems())) {
            return output;
        }
        return null;
    }

    @NotNull
    public final IEnergyStorage getEnergy() {
        return this.energy;
    }

    public final int getOutputSize() {
        return this.outputSlot.size();
    }

    @NotNull
    public final ItemStack getOutput(int index) {
        return this.outputSlot.get(index);
    }

    public final void setOutput(int index, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        this.outputSlot.put(index, stack);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return Intrinsics.areEqual(capability, WaterAPI.INSTANCE.getCAPABILITY_WATER_RECEIVER()) || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, WaterAPI.INSTANCE.getCAPABILITY_WATER_RECEIVER())) {
            return (T)this.waterReceiver;
        }
        return super.getCapability(capability, facing);
    }

    public final int getDefaultEnergyConsume() {
        return this.defaultEnergyConsume;
    }

    public final int getDefaultOperationLength() {
        return this.defaultOperationLength;
    }

    public final int getOutputSlotCount() {
        return this.outputSlotCount;
    }

    public TileEntityBaseMachine(int defaultEnergyConsume, int defaultOperationLength, int outputSlotCount) {
        this.defaultEnergyConsume = defaultEnergyConsume;
        this.defaultOperationLength = defaultOperationLength;
        this.outputSlotCount = outputSlotCount;
        this.energyConsume = this.defaultEnergyConsume;
        this.defaultEnergyStorage = this.defaultEnergyConsume * this.defaultOperationLength;
        this.operationLength = this.defaultOperationLength;
        this.operationsPerTick = 1;
        this.energy = new EnergyStorage(this.defaultEnergyStorage, DoubleCompanionObject.INSTANCE.getMAX_VALUE(), 0.0, 4, null);
        this.waterReceiver = new IWaterReceiver(this){
            final /* synthetic */ TileEntityBaseMachine this$0;

            public int receiveWater(int limit, @NotNull EnumFacing side, boolean simulate) {
                Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
                return this.this$0.getEnergy().receiveEnergy(limit, simulate);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.outputSlot = new InventorySlotOutput(this, "output", this.outputSlotCount);
        this.upgradeSlot = new InventorySlotUpgrade(this, "upgrade", 4);
    }

    public /* synthetic */ TileEntityBaseMachine(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = 2;
        }
        this(n, n2, n3);
    }
}

