/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.reservoir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import waterpower.common.block.reservoir.Reservoir;
import waterpower.common.block.reservoir.Reservoirs;
import waterpower.common.block.reservoir.TileEntityReservoir;
import waterpower.common.init.WPBlocks;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\"\u001a\u00020#J4\u0010$\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u001e\u0010+\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u0002022\u0006\u0010/\u001a\u000200H\u0007J\u000e\u00103\u001a\u00020(2\u0006\u0010%\u001a\u000204R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00110\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\n \u0007*\u0004\u0018\u00010\u001f0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00065"}, d2={"Lwaterpower/common/block/reservoir/MultiBlockHelper;", "", "te", "Lwaterpower/common/block/reservoir/TileEntityReservoir;", "(Lwaterpower/common/block/reservoir/TileEntityReservoir;)V", "blockState", "Lnet/minecraft/block/state/IBlockState;", "kotlin.jvm.PlatformType", "getBlockState", "()Lnet/minecraft/block/state/IBlockState;", "list", "", "getList", "()Ljava/util/List;", "setList", "(Ljava/util/List;)V", "pos", "Lnet/minecraft/util/math/BlockPos;", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "property", "Lnet/minecraft/block/properties/PropertyEnum;", "Lwaterpower/common/block/reservoir/Reservoirs;", "getProperty", "()Lnet/minecraft/block/properties/PropertyEnum;", "getTe", "()Lwaterpower/common/block/reservoir/TileEntityReservoir;", "type", "getType", "()Lwaterpower/common/block/reservoir/Reservoirs;", "world", "Lnet/minecraft/world/World;", "getWorld", "()Lnet/minecraft/world/World;", "canBeMaster", "", "checkDirection", "dir", "Lnet/minecraft/util/math/Vec3i;", "length", "", "width", "tmpList", "checkReservoir", "conjoint", "other", "coveredBlocks", "r", "Lwaterpower/common/block/reservoir/Reservoir;", "reservoir", "", "searchDirection", "Lnet/minecraft/util/EnumFacing;", "WaterPower_main"})
public final class MultiBlockHelper {
    private final World world;
    private final BlockPos pos;
    @NotNull
    private final PropertyEnum<Reservoirs> property;
    @NotNull
    private final Reservoirs type;
    private final IBlockState blockState;
    @NotNull
    private List<TileEntityReservoir> list;
    @NotNull
    private final TileEntityReservoir te;

    public final World getWorld() {
        return this.world;
    }

    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final PropertyEnum<Reservoirs> getProperty() {
        return this.property;
    }

    @NotNull
    public final Reservoirs getType() {
        return this.type;
    }

    public final IBlockState getBlockState() {
        return this.blockState;
    }

    @NotNull
    public final List<TileEntityReservoir> getList() {
        return this.list;
    }

    public final void setList(@NotNull List<TileEntityReservoir> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.list = list;
    }

    public final boolean conjoint(@NotNull BlockPos other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        IBlockState state = this.world.func_180495_p(other);
        if (state.func_177227_a().contains(this.property)) {
            return Intrinsics.areEqual((Object)((Reservoirs)((Object)this.world.func_180495_p(other).func_177229_b((IProperty)this.property))), (Object)((Reservoirs)((Object)this.blockState.func_177229_b((IProperty)this.property))));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canBeMaster() {
        BlockPos blockPos = this.pos.func_177977_b();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.down()");
        if (this.conjoint(blockPos)) return false;
        BlockPos blockPos2 = this.pos.func_177976_e();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.west()");
        if (this.conjoint(blockPos2)) return false;
        BlockPos blockPos3 = this.pos.func_177978_c();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos.north()");
        if (this.conjoint(blockPos3)) return false;
        return true;
    }

    public final int searchDirection(@NotNull EnumFacing dir) {
        int res;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        for (res = 1; res < 65; ++res) {
            BlockPos blockPos = this.pos.func_177967_a(dir, res);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.offset(dir, res)");
            if (!this.conjoint(blockPos)) break;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkDirection(@NotNull BlockPos pos, @NotNull Vec3i dir, int length, int width, @NotNull List<TileEntityReservoir> tmpList) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull(tmpList, (String)"tmpList");
        int dx = dir.func_177958_n();
        int dz = dir.func_177952_p();
        int n = pos.func_177958_n();
        int n2 = pos.func_177958_n() + dx * (length - 1);
        if (n <= n2) {
            while (true) {
                void x;
                int n3;
                int n4;
                if ((n4 = pos.func_177952_p()) <= (n3 = pos.func_177952_p() + dz * (width - 1))) {
                    while (true) {
                        void z;
                        TileEntity te1 = this.world.func_175625_s(new BlockPos((int)x, pos.func_177956_o(), (int)z));
                        TileEntity te2 = this.world.func_175625_s(new BlockPos((int)(x + (length - 1) * (1 - dx)), pos.func_177956_o(), (int)(z + (width - 1) * (1 - dz))));
                        if (!(te1 instanceof TileEntityReservoir) || !(te2 instanceof TileEntityReservoir) || Intrinsics.areEqual((Object)((TileEntityReservoir)te1).getType(), (Object)this.type) ^ true || Intrinsics.areEqual((Object)((TileEntityReservoir)te2).getType(), (Object)this.type) ^ true) {
                            return false;
                        }
                        Collection collection = tmpList;
                        collection.add(te1);
                        if (Intrinsics.areEqual((Object)te2, (Object)te1) ^ true) {
                            collection = tmpList;
                            collection.add(te2);
                        }
                        if (z == n3) break;
                        ++z;
                    }
                }
                if (x == n2) break;
                ++x;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int checkReservoir(@NotNull BlockPos pos, int length, int width) {
        int highest;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            List list = new ArrayList();
            List tmpList = new ArrayList();
            int n = pos.func_177956_o() + 64;
            int n2 = 250;
            highest = Math.min(n, n2);
            if (!this.checkDirection(pos, new Vec3i(1, 0, 1), length, width, tmpList)) {
                return 0;
            }
            Collection collection = list;
            CollectionsKt.addAll((Collection)collection, (Iterable)tmpList);
            tmpList.clear();
            int n3 = pos.func_177956_o() + 1;
            n2 = highest;
            if (n3 > n2) break block5;
            while (true) {
                void y;
                block7: {
                    block6: {
                        BlockPos blockPos = new BlockPos(pos.func_177958_n(), (int)y, pos.func_177952_p() + 1);
                        Vec3i vec3i = EnumFacing.SOUTH.func_176730_m();
                        Intrinsics.checkExpressionValueIsNotNull((Object)vec3i, (String)"EnumFacing.SOUTH.directionVec");
                        if (!this.checkDirection(blockPos, vec3i, length, width - 2, tmpList)) break block6;
                        BlockPos blockPos2 = new BlockPos(pos.func_177958_n(), (int)y, pos.func_177952_p());
                        Vec3i vec3i2 = EnumFacing.EAST.func_176730_m();
                        Intrinsics.checkExpressionValueIsNotNull((Object)vec3i2, (String)"EnumFacing.EAST.directionVec");
                        if (this.checkDirection(blockPos2, vec3i2, length, width, tmpList)) break block7;
                    }
                    this.list = list;
                    return (int)(y - pos.func_177956_o());
                }
                Collection collection2 = list;
                CollectionsKt.addAll((Collection)collection2, (Iterable)tmpList);
                tmpList.clear();
                if (y == n2) break;
                ++y;
            }
        }
        return highest - pos.func_177956_o();
    }

    /*
     * WARNING - void declaration
     */
    public final int coveredBlocks(@NotNull Reservoir r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        int res = 0;
        int n = this.pos.func_177958_n() + 1;
        int n2 = this.pos.func_177958_n() + r.getLength() - 2;
        if (n <= n2) {
            while (true) {
                void i;
                int n3;
                int n4;
                if ((n4 = this.pos.func_177952_p() + 1) <= (n3 = this.pos.func_177952_p() + r.getWidth() - 2)) {
                    while (true) {
                        void j;
                        int height;
                        if ((height = this.world.func_175726_f(new BlockPos((int)i, 0, (int)j)).func_177433_f(new BlockPos((int)i, 0, (int)j))) > this.pos.func_177956_o() + 1) {
                            ++res;
                        }
                        if (j == n3) break;
                        ++j;
                    }
                }
                if (i == n2) break;
                ++i;
            }
        }
        return res;
    }

    public final synchronized void reservoir(@NotNull Reservoir r) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        MultiBlockHelper multiBlockHelper = this;
        multiBlockHelper.list = list = (List)new ArrayList();
        r.setWidth(this.searchDirection(EnumFacing.SOUTH));
        r.setLength(this.searchDirection(EnumFacing.EAST));
        BlockPos blockPos = this.pos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
        r.setHeight(this.checkReservoir(blockPos, r.getLength(), r.getWidth()));
        if (r.getHeight() <= 1 || r.getWidth() <= 2 || r.getLength() <= 2) {
            r.setInvalid();
            this.list.clear();
        } else {
            r.setUuid(UUID.randomUUID());
        }
    }

    @NotNull
    public final TileEntityReservoir getTe() {
        return this.te;
    }

    public MultiBlockHelper(@NotNull TileEntityReservoir te) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)((Object)te), (String)"te");
        this.te = te;
        this.world = this.te.func_145831_w();
        this.pos = this.te.func_174877_v();
        this.property = WPBlocks.INSTANCE.getReservoir().getTYPES();
        this.type = this.te.getType();
        this.blockState = this.world.func_180495_p(this.pos);
        MultiBlockHelper multiBlockHelper = this;
        multiBlockHelper.list = list = (List)new ArrayList();
    }
}

