/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.reservoir;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.Preference;
import waterpower.annotations.HasGui;
import waterpower.annotations.SaveNBT;
import waterpower.annotations.Sync;
import waterpower.api.IUpgrade;
import waterpower.api.IWaterReceiver;
import waterpower.api.WaterAPI;
import waterpower.common.block.attachment.AttachmentFluid;
import waterpower.common.block.attachment.TileEntityAttachment;
import waterpower.common.block.inventory.InventorySlotConsumableLiquid;
import waterpower.common.block.inventory.InventorySlotOutput;
import waterpower.common.block.inventory.InventorySlotUpgrade;
import waterpower.common.block.reservoir.ContainerReservoir;
import waterpower.common.block.reservoir.GuiReservoir;
import waterpower.common.block.reservoir.MultiBlockHelper;
import waterpower.common.block.reservoir.Reservoir;
import waterpower.common.block.reservoir.Reservoirs;
import waterpower.common.block.tile.TileEntityMultiBlock;
import waterpower.common.init.WPBlocks;
import waterpower.util.StackUtilKt;
import waterpower.util.UtilsKt;
import waterpower.util.Vec2i;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@HasGui(guiClass=GuiReservoir.class, containerClass=ContainerReservoir.class)
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u00108\u001a\u000209H\u0014J\u001a\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u000209H\u0016J\u001c\u0010:\u001a\u0004\u0018\u00010;2\b\u0010>\u001a\u0004\u0018\u00010;2\u0006\u0010=\u001a\u000209H\u0016J\u001a\u0010?\u001a\u00020\"2\b\u0010>\u001a\u0004\u0018\u00010;2\u0006\u0010@\u001a\u000209H\u0016J\b\u0010A\u001a\u00020BH\u0016J\u0006\u0010C\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020DJ\u0006\u0010E\u001a\u00020\"J\b\u0010F\u001a\u00020\u0007H\u0016J\u0006\u0010G\u001a\u00020&J1\u0010H\u001a&\u0012\f\u0012\n K*\u0004\u0018\u00010J0J K*\u0012\u0012\u000e\b\u0001\u0012\n K*\u0004\u0018\u00010J0J0I0IH\u0016\u00a2\u0006\u0002\u0010LJ\u0006\u0010M\u001a\u000207J\b\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020OH\u0016J\b\u0010Q\u001a\u00020OH\u0016J\b\u0010R\u001a\u00020OH\u0014J\b\u0010S\u001a\u00020OH\u0016J\u0006\u0010T\u001a\u00020OJ\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00000VH\u0014J\b\u0010W\u001a\u00020OH\u0016J\u000e\u0010X\u001a\u00020O2\u0006\u0010Y\u001a\u00020\"R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00020\u001c8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010\u0011R\u001a\u0010*\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000f\"\u0004\b,\u0010\u0011R\u0016\u0010-\u001a\u00020.8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u000f\"\u0004\b5\u0010\u0011R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lwaterpower/common/block/reservoir/TileEntityReservoir;", "Lwaterpower/common/block/tile/TileEntityMultiBlock;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "type", "Lwaterpower/common/block/reservoir/Reservoirs;", "(Lwaterpower/common/block/reservoir/Reservoirs;)V", "biomeID", "", "getBiomeID", "()Ljava/lang/String;", "biomeID$delegate", "Lkotlin/Lazy;", "defaultStorage", "", "getDefaultStorage", "()D", "setDefaultStorage", "(D)V", "extraStorage", "getExtraStorage", "setExtraStorage", "fluid", "Lwaterpower/common/block/attachment/AttachmentFluid;", "getFluid", "()Lwaterpower/common/block/attachment/AttachmentFluid;", "fluidSlot", "Lwaterpower/common/block/inventory/InventorySlotConsumableLiquid;", "fluidTank", "Lwaterpower/common/block/attachment/AttachmentFluid$FluidTankImpl;", "getFluidTank", "()Lwaterpower/common/block/attachment/AttachmentFluid$FluidTankImpl;", "helper", "Lwaterpower/common/block/reservoir/MultiBlockHelper;", "lastAddedWater", "", "ocean", "Lwaterpower/util/Vec2i;", "outputSlot", "Lwaterpower/common/block/inventory/InventorySlotOutput;", "overLevel", "getOverLevel", "setOverLevel", "rainLevel", "getRainLevel", "setRainLevel", "reservoir", "Lwaterpower/common/block/reservoir/Reservoir;", "getReservoir", "()Lwaterpower/common/block/reservoir/Reservoir;", "getType", "()Lwaterpower/common/block/reservoir/Reservoirs;", "underLevel", "getUnderLevel", "setUnderLevel", "upgradeSlot", "Lwaterpower/common/block/inventory/InventorySlotUpgrade;", "canBeMaster", "", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "doDrain", "resource", "fill", "doFill", "getBlockState", "Lnet/minecraft/block/state/IBlockState;", "getFluidSlot", "Lnet/minecraftforge/fluids/FluidTank;", "getLastAddedWater", "getName", "getOutputSlot", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "kotlin.jvm.PlatformType", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "getUpgradeSlot", "markDirty", "", "onFirstTick", "onMasterChanged", "onTestFailed", "onUpdate", "refreshPlugins", "test", "", "update", "useLiquid", "use", "WaterPower_main"})
public class TileEntityReservoir
extends TileEntityMultiBlock<TileEntityReservoir>
implements IFluidHandler {
    @NotNull
    private final AttachmentFluid fluid;
    @SaveNBT
    @Sync
    @NotNull
    private final AttachmentFluid.FluidTankImpl fluidTank;
    @Sync
    @NotNull
    private final Reservoir reservoir;
    private double defaultStorage;
    private double extraStorage;
    private double rainLevel;
    private double underLevel;
    private double overLevel;
    @Sync
    private int lastAddedWater;
    private final Vec2i ocean;
    private final InventorySlotConsumableLiquid fluidSlot;
    private final InventorySlotOutput outputSlot;
    private final InventorySlotUpgrade upgradeSlot;
    private MultiBlockHelper helper;
    @NotNull
    private final Lazy biomeID$delegate;
    @NotNull
    private final Reservoirs type;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    protected final AttachmentFluid getFluid() {
        return this.fluid;
    }

    @NotNull
    protected final AttachmentFluid.FluidTankImpl getFluidTank() {
        return this.fluidTank;
    }

    @NotNull
    public final Reservoir getReservoir() {
        return this.reservoir;
    }

    public final double getDefaultStorage() {
        return this.defaultStorage;
    }

    public final void setDefaultStorage(double d) {
        this.defaultStorage = d;
    }

    public final double getExtraStorage() {
        return this.extraStorage;
    }

    public final void setExtraStorage(double d) {
        this.extraStorage = d;
    }

    public final double getRainLevel() {
        return this.rainLevel;
    }

    public final void setRainLevel(double d) {
        this.rainLevel = d;
    }

    public final double getUnderLevel() {
        return this.underLevel;
    }

    public final void setUnderLevel(double d) {
        this.underLevel = d;
    }

    public final double getOverLevel() {
        return this.overLevel;
    }

    public final void setOverLevel(double d) {
        this.overLevel = d;
    }

    @NotNull
    public final FluidTank getFluidTank() {
        if (!this.isNormalBlock()) {
            return this.fluidTank;
        }
        Object t = this.getMasterBlock();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return ((TileEntityReservoir)((Object)t)).fluidTank;
    }

    @NotNull
    public final InventorySlotConsumableLiquid getFluidSlot() {
        if (!this.isNormalBlock()) {
            return this.fluidSlot;
        }
        Object t = this.getMasterBlock();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return ((TileEntityReservoir)((Object)t)).fluidSlot;
    }

    @NotNull
    public final InventorySlotOutput getOutputSlot() {
        if (!this.isNormalBlock()) {
            return this.outputSlot;
        }
        Object t = this.getMasterBlock();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return ((TileEntityReservoir)((Object)t)).outputSlot;
    }

    @NotNull
    public final InventorySlotUpgrade getUpgradeSlot() {
        if (!this.isNormalBlock()) {
            return this.upgradeSlot;
        }
        Object t = this.getMasterBlock();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return ((TileEntityReservoir)((Object)t)).upgradeSlot;
    }

    @NotNull
    public String func_70005_c_() {
        return this.type.getLocalizedName();
    }

    @Override
    @NotNull
    public IBlockState getBlockState() {
        IBlockState iBlockState = super.getBlockState().func_177226_a((IProperty)WPBlocks.INSTANCE.getReservoir().getTYPES(), (Comparable)((Object)this.type));
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        return iBlockState;
    }

    public final void useLiquid(int use) {
        if (this.func_145831_w().field_72995_K || this.isMaster()) {
            this.fluidTank.drain(use, true);
        } else if (!this.isIncompleteStructure()) {
            Object t = this.getMasterBlock();
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type waterpower.common.block.reservoir.TileEntityReservoir");
            }
            ((TileEntityReservoir)((Object)t)).fluidTank.drain(use, true);
        }
    }

    @Override
    protected boolean canBeMaster() {
        MultiBlockHelper multiBlockHelper = this.helper;
        if (multiBlockHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        return multiBlockHelper.canBeMaster();
    }

    @Override
    public void onMasterChanged() {
        super.onMasterChanged();
        if (Intrinsics.areEqual((Object)((Object)((TileEntityReservoir)((Object)this.getMasterBlock()))), (Object)((Object)this)) ^ true) {
            this.fluidTank.setCapacity(0);
            this.fluidTank.setFluid(null);
        }
    }

    @Override
    @NotNull
    protected List<TileEntityReservoir> test() {
        MultiBlockHelper multiBlockHelper = this.helper;
        if (multiBlockHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        multiBlockHelper.reservoir(this.reservoir);
        if (this.reservoir.getUuid() != null) {
            this.defaultStorage = 1.0 * (double)this.reservoir.getCapacity() * (double)this.type.getCapacity();
            this.fluidTank.setCapacity((int)(this.defaultStorage + this.extraStorage));
        }
        MultiBlockHelper multiBlockHelper2 = this.helper;
        if (multiBlockHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
        }
        return multiBlockHelper2.getList();
    }

    @NotNull
    public final String getBiomeID() {
        Lazy lazy = this.biomeID$delegate;
        TileEntityReservoir tileEntityReservoir = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.isMaster() && !this.func_145831_w().field_72995_K && this.reservoir.getUuid() != null) {
            void biomeGet;
            void weather;
            String biome = this.getBiomeID();
            World world = this.func_145831_w();
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"getWorld()");
            Pair<Integer, Double> pair = UtilsKt.getWaterIncomeAndExpenseByBiome(world, biome);
            int n = ((Number)pair.component1()).intValue();
            double d = ((Number)pair.component2()).doubleValue();
            pair = null;
            int length = this.reservoir.getLength() - 2;
            int width = this.reservoir.getWidth() - 2;
            int area = length * width;
            MultiBlockHelper multiBlockHelper = this.helper;
            if (multiBlockHelper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"helper");
            }
            int cover = multiBlockHelper.coveredBlocks(this.reservoir);
            double addWater = 0.0;
            double add = (double)this.type.getCapacity() / 10000.0;
            int n2 = this.ocean.getX();
            int n3 = this.ocean.getY();
            double d2 = addWater += this.rainLevel * (double)weather * add * (double)(area - cover) * biomeGet;
            int n4 = Math.min(n2, n3);
            addWater = d2 + (double)(n4 * this.type.getCapacity() / 100);
            addWater += this.underLevel * (1.0 - (double)(this.field_174879_c.func_177956_o() / 256)) * add * (double)(area - cover) * biomeGet;
            addWater += this.overLevel * (1.0 - (double)(Math.abs(64 - this.field_174879_c.func_177956_o()) / 64)) * (double)(area - cover) * biomeGet * add;
            if ((StringsKt.contains$default((CharSequence)biome, (CharSequence)"ocean", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)biome, (CharSequence)"river", (boolean)false, (int)2, null)) && this.field_174879_c.func_177956_o() < 64) {
                addWater += (double)length * (double)width * 0.5;
            }
            this.lastAddedWater = (int)(addWater * (double)Preference.General.INSTANCE.getUpdateTicks());
            if ((int)addWater * Preference.General.INSTANCE.getUpdateTicks() >= 1) {
                this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, (int)addWater * Preference.General.INSTANCE.getUpdateTicks()), true);
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && !this.isIncompleteStructure()) {
            if (this.isMaster() && this.fluidSlot.processIntoTank((IFluidTank)this.fluidTank, this.outputSlot)) {
                this.func_70296_d();
            }
            EnumFacing[] enumFacingArray = EnumFacing.values();
            for (int i = 0; i < enumFacingArray.length; ++i) {
                EnumFacing f = enumFacingArray[i];
                TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(f));
                if (te == null) continue;
                Capability<IWaterReceiver> capability = WaterAPI.INSTANCE.getCAPABILITY_WATER_RECEIVER();
                if (capability == null) {
                    Intrinsics.throwNpe();
                }
                if (!te.hasCapability(capability, f.func_176734_d())) continue;
                Capability<IWaterReceiver> capability2 = WaterAPI.INSTANCE.getCAPABILITY_WATER_RECEIVER();
                if (capability2 == null) {
                    Intrinsics.throwNpe();
                }
                Object object = te.getCapability(capability2, f.func_176734_d());
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type waterpower.api.IWaterReceiver");
                }
                IWaterReceiver waterReceiver2 = (IWaterReceiver)object;
                int n = this.getFluidTank().getFluidAmount();
                EnumFacing enumFacing = f.func_176734_d();
                Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"f.opposite");
                int delta = waterReceiver2.receiveWater(n, enumFacing, false);
                this.useLiquid(delta);
            }
        }
    }

    @Override
    protected void onTestFailed() {
        this.fluidTank.setCapacity(0);
    }

    public final int getLastAddedWater() {
        if (!this.isNormalBlock()) {
            return this.lastAddedWater;
        }
        Object t = this.getMasterBlock();
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type waterpower.common.block.reservoir.TileEntityReservoir");
        }
        return ((TileEntityReservoir)((Object)t)).getLastAddedWater();
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.isServerSide()) {
            this.refreshPlugins();
        }
    }

    @Override
    public void onFirstTick() {
        super.onFirstTick();
        if (this.isServerSide()) {
            this.helper = new MultiBlockHelper(this);
            this.refreshPlugins();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshPlugins() {
        if (this.isMaster()) {
            this.extraStorage = 0.0;
            this.underLevel = 0.0;
            this.overLevel = 0.0;
            this.rainLevel = 0.0;
            int n = 0;
            int n2 = this.upgradeSlot.size() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    ItemStack stack;
                    if (!StackUtilKt.isStackEmpty(stack = this.upgradeSlot.get((int)i)) && stack.func_77973_b() instanceof IUpgrade) {
                        Item item = stack.func_77973_b();
                        if (item == null) {
                            throw new TypeCastException("null cannot be cast to non-null type waterpower.api.IUpgrade");
                        }
                        IUpgrade upgrade = (IUpgrade)item;
                        this.rainLevel += upgrade.getRainAdditionalValue(stack);
                        this.overLevel += upgrade.getSurfaceAdditionalValue(stack);
                        this.underLevel += upgrade.getUnderworldAdditionalValue(stack);
                        this.extraStorage += (double)upgrade.getStorageAdditionalValue(stack);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            this.fluidTank.setCapacity((int)(this.defaultStorage + this.extraStorage));
        }
    }

    @Nullable
    public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
        return this.getFluidTank().drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.getFluidTank().drain(maxDrain, doDrain);
    }

    public int fill(@Nullable FluidStack resource, boolean doFill) {
        return this.getFluidTank().fill(resource, doFill);
    }

    @NotNull
    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] iFluidTankPropertiesArray = this.getFluidTank().getTankProperties();
        if (iFluidTankPropertiesArray == null) {
            Intrinsics.throwNpe();
        }
        return iFluidTankPropertiesArray;
    }

    @NotNull
    public final Reservoirs getType() {
        return this.type;
    }

    public TileEntityReservoir(@NotNull Reservoirs type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.type = type;
        this.fluid = (AttachmentFluid)this.addAttachment((TileEntityAttachment)new AttachmentFluid(this));
        this.fluidTank = this.fluid.addTank("fluid", 0);
        this.reservoir = new Reservoir(0, 0, 0, 0, null, 31, null);
        this.ocean = new Vec2i(0, 0, 3, null);
        this.fluidSlot = new InventorySlotConsumableLiquid(this, "fluidSlot", 1);
        this.outputSlot = new InventorySlotOutput(this, "output", 1);
        this.upgradeSlot = new InventorySlotUpgrade(this, "upgrade", 4);
        this.biomeID$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TileEntityReservoir this$0;

            @NotNull
            public final String invoke() {
                Object object;
                block5: {
                    block4: {
                        Object object2;
                        object = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)TileEntityReservoir.access$getWorld$p(this.this$0).getBiomeForCoordsBody(TileEntityReservoir.access$getPos$p(this.this$0)));
                        if (object == null || (object = object.func_110623_a()) == null) break block4;
                        Object object3 = object2 = object;
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string = ((String)object3).toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                        object = string;
                        if (string != null) break block5;
                    }
                    object = "";
                }
                return object;
            }
            {
                this.this$0 = tileEntityReservoir;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TileEntityReservoir.class), "biomeID", "getBiomeID()Ljava/lang/String;"))};
    }

    public static final /* synthetic */ World access$getWorld$p(TileEntityReservoir $this) {
        return $this.field_145850_b;
    }

    public static final /* synthetic */ void access$setWorld$p(TileEntityReservoir $this, World world) {
        $this.field_145850_b = world;
    }

    public static final /* synthetic */ BlockPos access$getPos$p(TileEntityReservoir $this) {
        return $this.field_174879_c;
    }

    public static final /* synthetic */ void access$setPos$p(TileEntityReservoir $this, BlockPos blockPos) {
        $this.field_174879_c = blockPos;
    }
}

