/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.tile;

import ic2.api.energy.tile.IHeatSource;
import ic2.api.energy.tile.IKineticSource;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.SaveNBT;
import waterpower.annotations.Sync;
import waterpower.api.IUnitChangeable;
import waterpower.common.Energy;
import waterpower.common.block.attachment.AttachmentEU;
import waterpower.common.block.attachment.AttachmentFluid;
import waterpower.common.block.attachment.AttachmentMJ;
import waterpower.common.block.attachment.AttachmentRF;
import waterpower.common.block.attachment.AttachmentSteam;
import waterpower.common.block.attachment.AttachmentWater;
import waterpower.common.block.attachment.EnergyStorage;
import waterpower.common.block.attachment.TileEntityAttachment;
import waterpower.common.block.tile.TileEntityInventory;
import waterpower.common.network.NetworkHandler;
import waterpower.common.network.PacketUnitChanged;
import waterpower.integration.Mod;
import waterpower.util.FluidUtilKt;

@Optional.InterfaceList(value={@Optional.Interface(striprefs=true, iface="ic2.api.energy.tile.IKineticSource", modid="ic2"), @Optional.Interface(striprefs=true, iface="ic2.api.energy.tile.IHeatSource", modid="ic2")})
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\f\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0018\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H$J\u0006\u0010,\u001a\u00020-J-\u0010.\u001a\u0004\u0018\u0001H/\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/012\b\u00102\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u00020\rJ\u000e\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\bJ\u001e\u00108\u001a\u00020-2\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0010\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u000203H\u0017J\u0010\u0010;\u001a\u00020\u00062\u0006\u0010:\u001a\u000203H\u0017J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020=2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020\rH\u0007J\b\u0010A\u001a\u00020=H\u0016J\b\u0010B\u001a\u00020=H\u0016J\u0018\u0010C\u001a\u00020\u00062\u0006\u0010:\u001a\u0002032\u0006\u0010D\u001a\u00020\u0006H\u0017J\u0018\u0010E\u001a\u00020\u00062\u0006\u0010:\u001a\u0002032\u0006\u0010E\u001a\u00020\u0006H\u0017J\u0010\u0010F\u001a\u00020=2\u0006\u0010G\u001a\u00020\rH\u0016J\b\u0010H\u001a\u00020=H\u0016R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u001f8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006I"}, d2={"Lwaterpower/common/block/tile/TileEntityGenerator;", "Lwaterpower/common/block/tile/TileEntityInventory;", "Lic2/api/energy/tile/IKineticSource;", "Lwaterpower/api/IUnitChangeable;", "Lic2/api/energy/tile/IHeatSource;", "production", "", "maxStorage", "", "tier", "(IDI)V", "energyAttachments", "", "Lwaterpower/common/Energy;", "Lwaterpower/common/block/attachment/TileEntityAttachment;", "getEnergyAttachments", "()Ljava/util/Map;", "energyStorage", "Lwaterpower/common/block/attachment/EnergyStorage;", "getEnergyStorage", "()Lwaterpower/common/block/attachment/EnergyStorage;", "energyType", "getEnergyType", "()I", "setEnergyType", "(I)V", "fluid", "Lwaterpower/common/block/attachment/AttachmentFluid;", "getFluid", "()Lwaterpower/common/block/attachment/AttachmentFluid;", "fluidTank", "Lwaterpower/common/block/attachment/AttachmentFluid$FluidTankImpl;", "getFluidTank", "()Lwaterpower/common/block/attachment/AttachmentFluid$FluidTankImpl;", "latestOutput", "getLatestOutput", "()D", "setLatestOutput", "(D)V", "computeOutput", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "enableUpdateEntity", "", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getEnergyUnit", "getFromEU", "eu", "hasCapability", "maxrequestHeatTick", "directionFrom", "maxrequestkineticenergyTick", "onLoad", "", "onNeighborTileChanged", "onUnitChanged", "t", "onUnloaded", "onUpdate", "requestHeat", "requestheat", "requestkineticenergy", "setUnit", "energyUnit", "update", "WaterPower_main"})
public abstract class TileEntityGenerator
extends TileEntityInventory
implements IKineticSource,
IUnitChangeable,
IHeatSource {
    @NotNull
    private final AttachmentFluid fluid = (AttachmentFluid)this.addAttachment((TileEntityAttachment)new AttachmentFluid(this));
    @SaveNBT
    @NotNull
    private final AttachmentFluid.FluidTankImpl fluidTank;
    @NotNull
    private final Map<Energy, TileEntityAttachment> energyAttachments;
    @SaveNBT
    @Sync
    @NotNull
    private final EnergyStorage energyStorage;
    @SaveNBT
    @Sync
    private int energyType;
    @Sync
    private double latestOutput;

    @NotNull
    protected final AttachmentFluid getFluid() {
        return this.fluid;
    }

    @NotNull
    protected final AttachmentFluid.FluidTankImpl getFluidTank() {
        return this.fluidTank;
    }

    @NotNull
    protected final Map<Energy, TileEntityAttachment> getEnergyAttachments() {
        return this.energyAttachments;
    }

    @NotNull
    public final EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public final int getEnergyType() {
        return this.energyType;
    }

    public final void setEnergyType(int n) {
        this.energyType = n;
    }

    public final double getLatestOutput() {
        return this.latestOutput;
    }

    public final void setLatestOutput(double d) {
        this.latestOutput = d;
    }

    public void onLoad() {
        super.onLoad();
        Energy energyUnit = this.getEnergyUnit();
        if (this.energyAttachments.containsKey((Object)energyUnit)) {
            TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)energyUnit);
            if (tileEntityAttachment == null) {
                Intrinsics.throwNpe();
            }
            tileEntityAttachment.onLoaded();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        Energy energyUnit = this.getEnergyUnit();
        if (this.energyAttachments.containsKey((Object)energyUnit)) {
            TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)energyUnit);
            if (tileEntityAttachment == null) {
                Intrinsics.throwNpe();
            }
            tileEntityAttachment.onUnloaded();
        }
    }

    public final boolean enableUpdateEntity() {
        return this.isServerSide();
    }

    @Override
    public void onNeighborTileChanged(@NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        super.onNeighborTileChanged(pos);
        if (this.energyAttachments.containsKey((Object)this.getEnergyUnit())) {
            TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)this.getEnergyUnit());
            if (tileEntityAttachment == null) {
                Intrinsics.throwNpe();
            }
            tileEntityAttachment.onNeighborTileChange(pos);
        }
    }

    protected abstract double computeOutput(@NotNull World var1, @NotNull BlockPos var2);

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.isServerSide()) {
            return;
        }
        World world = this.func_145831_w();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"getWorld()");
        IBlockAccess iBlockAccess = (IBlockAccess)world;
        BlockPos blockPos = this.func_174877_v();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"getPos()");
        FluidUtilKt.pushFluidAround(iBlockAccess, blockPos, this.fluidTank);
        if (!this.isRedstonePowered()) {
            World world2 = this.field_145850_b;
            Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
            BlockPos blockPos2 = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
            this.latestOutput = this.computeOutput(world2, blockPos2);
            this.energyStorage.receiveEnergy(this.latestOutput, false);
            if (this.energyAttachments.containsKey((Object)this.getEnergyUnit())) {
                TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)this.getEnergyUnit());
                if (tileEntityAttachment == null) {
                    Intrinsics.throwNpe();
                }
                tileEntityAttachment.onTick();
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isRedstonePowered() && this.energyAttachments.containsKey((Object)this.getEnergyUnit())) {
            TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)this.getEnergyUnit());
            if (tileEntityAttachment == null) {
                Intrinsics.throwNpe();
            }
            tileEntityAttachment.onUpdate();
        }
    }

    @Optional.Method(modid="ic2")
    public int maxrequestHeatTick(@NotNull EnumFacing directionFrom) {
        Intrinsics.checkParameterIsNotNull((Object)directionFrom, (String)"directionFrom");
        if (Intrinsics.areEqual((Object)((Object)this.getEnergyUnit()), (Object)((Object)Energy.HU))) {
            return (int)Energy.Companion.EU2HU(this.energyStorage.getMaxEnergyExtracted());
        }
        return 0;
    }

    @Optional.Method(modid="ic2")
    public int requestHeat(@NotNull EnumFacing directionFrom, int requestheat) {
        Intrinsics.checkParameterIsNotNull((Object)directionFrom, (String)"directionFrom");
        if (Intrinsics.areEqual((Object)((Object)this.getEnergyUnit()), (Object)((Object)Energy.HU))) {
            return (int)Energy.Companion.EU2HU(this.energyStorage.extractEnergy(Energy.Companion.HU2EU(requestheat), true));
        }
        return 0;
    }

    @Optional.Method(modid="ic2")
    public int maxrequestkineticenergyTick(@NotNull EnumFacing directionFrom) {
        Intrinsics.checkParameterIsNotNull((Object)directionFrom, (String)"directionFrom");
        if (Intrinsics.areEqual((Object)((Object)this.getEnergyUnit()), (Object)((Object)Energy.KU))) {
            return (int)Energy.Companion.EU2KU(this.energyStorage.getMaxEnergyExtracted());
        }
        return 0;
    }

    @Optional.Method(modid="ic2")
    public int requestkineticenergy(@NotNull EnumFacing directionFrom, int requestkineticenergy) {
        Intrinsics.checkParameterIsNotNull((Object)directionFrom, (String)"directionFrom");
        if (Intrinsics.areEqual((Object)((Object)this.getEnergyUnit()), (Object)((Object)Energy.KU))) {
            return (int)Energy.Companion.EU2KU(this.energyStorage.extractEnergy(Energy.Companion.KU2EU(requestkineticenergy), true));
        }
        return 0;
    }

    @Override
    public void setUnit(@NotNull Energy energyUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)energyUnit), (String)"energyUnit");
        Energy oldEnergy = this.getEnergyUnit();
        if (Intrinsics.areEqual((Object)((Object)oldEnergy), (Object)((Object)energyUnit)) ^ true) {
            if (this.energyAttachments.containsKey((Object)oldEnergy)) {
                TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)oldEnergy);
                if (tileEntityAttachment == null) {
                    Intrinsics.throwNpe();
                }
                tileEntityAttachment.onUnloaded();
            }
            if (this.energyAttachments.containsKey((Object)energyUnit)) {
                TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)energyUnit);
                if (tileEntityAttachment == null) {
                    Intrinsics.throwNpe();
                }
                tileEntityAttachment.onLoaded();
            }
        }
        this.energyType = energyUnit.ordinal();
    }

    public final double getFromEU(double eu) {
        return this.getEnergyUnit().getFromEU(eu);
    }

    @NotNull
    public final Energy getEnergyUnit() {
        if (this.energyType < 0 || this.energyType >= ((Object[])Energy.values()).length) {
            this.energyType = 0;
        }
        return Energy.values()[this.energyType];
    }

    @SideOnly(value=Side.CLIENT)
    public final void onUnitChanged(@NotNull Energy t) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)t), (String)"t");
        this.energyType = t.ordinal();
        SimpleNetworkWrapper simpleNetworkWrapper = NetworkHandler.INSTANCE.getInstance();
        int n = Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.getDimension();
        BlockPos blockPos = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
        simpleNetworkWrapper.sendToServer((IMessage)new PacketUnitChanged(n, blockPos, this.getEnergyUnit()));
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        T cap = null;
        if (this.energyAttachments.containsKey((Object)this.getEnergyUnit())) {
            TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)this.getEnergyUnit());
            if (tileEntityAttachment == null) {
                Intrinsics.throwNpe();
            }
            cap = tileEntityAttachment.getCapability(capability, facing);
        }
        if (cap == null) {
            cap = super.getCapability(capability, facing);
        }
        return cap;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (this.energyAttachments.containsKey((Object)this.getEnergyUnit())) {
            TileEntityAttachment tileEntityAttachment = this.energyAttachments.get((Object)this.getEnergyUnit());
            if (tileEntityAttachment == null) {
                Intrinsics.throwNpe();
            }
            return tileEntityAttachment.getCapabilities(facing).contains(capability);
        }
        return false;
    }

    public TileEntityGenerator(int production, double maxStorage, int tier) {
        Map<Energy, TileEntityAttachment> map;
        Object object;
        Object object2;
        Map map2;
        this.fluidTank = this.fluid.addTankInsert("fluid", (int)maxStorage);
        TileEntityGenerator tileEntityGenerator = this;
        tileEntityGenerator.energyAttachments = map2 = (Map)new LinkedHashMap();
        this.energyStorage = new EnergyStorage(maxStorage, DoubleCompanionObject.INSTANCE.getMAX_VALUE(), production);
        this.energyType = Energy.EU.ordinal();
        if (Mod.Companion.getIndustrialCraft2().isAvailable()) {
            AttachmentEU eu = AttachmentEU.Companion.createEnergySource$default(AttachmentEU.Companion, this, this.energyStorage, 0, null, 12, null);
            eu.setSourceTier(tier);
            object2 = this.energyAttachments;
            object = Energy.EU;
            AttachmentEU attachmentEU = eu;
            object2.put(object, attachmentEU);
        }
        if (Mod.Companion.getRedstoneFlux().isAvailable()) {
            map = this.energyAttachments;
            object2 = Energy.RF;
            object = new AttachmentRF(this, this.energyStorage);
            map.put((Energy)((Object)object2), (TileEntityAttachment)object);
        }
        if (Mod.Companion.getBuildCraftPower().isAvailable()) {
            map = this.energyAttachments;
            object2 = Energy.MJ;
            object = new AttachmentMJ(this, this.energyStorage);
            map.put((Energy)((Object)object2), (TileEntityAttachment)object);
        }
        map = this.energyAttachments;
        object2 = Energy.STEAM;
        object = new AttachmentSteam(this, this.energyStorage, this.fluidTank);
        map.put((Energy)((Object)object2), (TileEntityAttachment)object);
        map = this.energyAttachments;
        object2 = Energy.WATER;
        object = new AttachmentWater(this, this.energyStorage, this.fluidTank);
        map.put((Energy)((Object)object2), (TileEntityAttachment)object);
    }
}

