/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.block.inventory.InventorySlot;
import waterpower.common.block.tile.TileEntityBase;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J-\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"2\b\u0010#\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140(H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010-\u001a\u00020\u0012H\u0016J\b\u0010.\u001a\u00020\u0012H\u0016J\u0012\u0010/\u001a\u0002002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u00101\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u00102\u001a\u00020\u000e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\b\u0010#\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u00103\u001a\u00020\u000eH\u0016J\b\u00104\u001a\u00020\u000eH\u0016J\u0018\u00105\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u0014H\u0016J\u0012\u00107\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u00108\u001a\u00020\u0019H\u0016J\u0012\u00109\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010>\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012H\u0016J\u0018\u0010@\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u0014H\u0016J\u0010\u0010A\u001a\u00020<2\u0006\u0010;\u001a\u00020<H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006B"}, d2={"Lwaterpower/common/block/tile/TileEntityInventory;", "Lwaterpower/common/block/tile/TileEntityBase;", "Lnet/minecraft/inventory/ISidedInventory;", "()V", "invSlots", "Ljava/util/ArrayList;", "Lwaterpower/common/block/inventory/InventorySlot;", "getInvSlots", "()Ljava/util/ArrayList;", "itemHandler", "", "Lnet/minecraftforge/items/IItemHandler;", "[Lnet/minecraftforge/items/IItemHandler;", "addInvSlot", "", "invSlot", "canExtractItem", "index", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "side", "Lnet/minecraft/util/EnumFacing;", "canInsertItem", "clear", "", "closeInventory", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "decrStackSize", "count", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getDisplayName", "Lnet/minecraft/util/text/TextComponentString;", "getDrops", "", "getField", "id", "getFieldCount", "getInvSlot", "getInventoryStackLimit", "getSizeInventory", "getSlotsForFace", "", "getStackInSlot", "hasCapability", "hasCustomName", "isEmpty", "isItemValidForSlot", "stack", "isUsableByPlayer", "markDirty", "openInventory", "readFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "removeStackFromSlot", "setField", "value", "setInventorySlotContents", "writeToNBT", "WaterPower_main"})
public abstract class TileEntityInventory
extends TileEntityBase
implements ISidedInventory {
    private final IItemHandler[] itemHandler = new IItemHandler[((Object[])EnumFacing.field_82609_l).length + 1];
    @NotNull
    private final ArrayList<InventorySlot> invSlots = new ArrayList();

    @NotNull
    public final ArrayList<InventorySlot> getInvSlots() {
        return this.invSlots;
    }

    @Override
    public void func_145839_a(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.func_145839_a(tag);
        NBTTagCompound inventory = tag.func_74775_l("inventory");
        for (InventorySlot invSlot : this.invSlots) {
            NBTTagCompound nBTTagCompound = inventory.func_74775_l(invSlot.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"inventory.getCompoundTag(invSlot.name)");
            invSlot.readFromNBT(nBTTagCompound);
        }
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.func_189515_b(tag);
        NBTTagCompound invSlotsTag = new NBTTagCompound();
        for (InventorySlot invSlot : this.invSlots) {
            NBTTagCompound invSlotTag = new NBTTagCompound();
            invSlot.writeToNBT(invSlotTag);
            invSlotsTag.func_74782_a(invSlot.getName(), (NBTBase)invSlotTag);
        }
        tag.func_74782_a("inventory", (NBTBase)invSlotsTag);
        return tag;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_191420_l() {
        for (InventorySlot invSlot : this.invSlots) {
            if (invSlot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        int ret = 0;
        for (InventorySlot invSlot : this.invSlots) {
            ret += invSlot.size();
        }
        return ret;
    }

    public boolean func_180462_a(int index, @NotNull ItemStack itemStack, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        if (StackUtilKt.isStackEmpty(itemStack)) {
            return false;
        }
        InventorySlot inventorySlot = this.getInvSlot(index);
        if (inventorySlot == null) {
            return false;
        }
        InventorySlot targetSlot = inventorySlot;
        if (!targetSlot.canInput() || !targetSlot.accepts(itemStack)) {
            return false;
        }
        if (targetSlot.getPreferredSide() != InventorySlot.InvSide.ANY && targetSlot.getPreferredSide().matches(side)) {
            return true;
        }
        for (InventorySlot invSlot : this.invSlots) {
            if (!(Intrinsics.areEqual((Object)invSlot, (Object)targetSlot) ^ true) || invSlot.getPreferredSide() == InventorySlot.InvSide.ANY || !invSlot.getPreferredSide().matches(side) || !invSlot.canInput() || !invSlot.accepts(itemStack)) continue;
            return false;
        }
        return true;
    }

    public boolean func_180461_b(int index, @NotNull ItemStack itemStack, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        InventorySlot inventorySlot = this.getInvSlot(index);
        if (inventorySlot == null) {
            return false;
        }
        InventorySlot targetSlot = inventorySlot;
        if (!targetSlot.canOutput()) {
            return false;
        }
        if (targetSlot.getPreferredSide() != InventorySlot.InvSide.ANY && targetSlot.getPreferredSide().matches(side)) {
            return true;
        }
        for (InventorySlot invSlot : this.invSlots) {
            if (!(Intrinsics.areEqual((Object)invSlot, (Object)targetSlot) ^ true) || invSlot.getPreferredSide() == InventorySlot.InvSide.ANY || !invSlot.getPreferredSide().matches(side) || !invSlot.canOutput()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack func_70304_b(int index) {
        ItemStack ret = this.func_70301_a(index);
        if (!StackUtilKt.isStackEmpty(ret)) {
            this.func_70299_a(index, StackUtilKt.getEmptyStack());
        }
        return ret;
    }

    @NotNull
    public ItemStack func_70301_a(int index) {
        int i = index;
        for (InventorySlot invSlot : this.invSlots) {
            if (i < invSlot.size()) {
                return invSlot.get(i);
            }
            i -= invSlot.size();
        }
        return StackUtilKt.getEmptyStack();
    }

    @Override
    @NotNull
    public List<ItemStack> getDrops() {
        ArrayList list = new ArrayList(super.getDrops());
        for (InventorySlot slot : this.invSlots) {
            for (ItemStack stack : slot) {
                if (StackUtilKt.isStackEmpty(stack)) continue;
                Collection collection = list;
                collection.add(stack);
            }
        }
        return list;
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (facing == null) {
                if (this.itemHandler[((Object[])this.itemHandler).length - 1] == null) {
                    this.itemHandler[((Object[])this.itemHandler).length - 1] = (IItemHandler)new InvWrapper((IInventory)this);
                }
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler[((Object[])this.itemHandler).length - 1]);
            }
            if (this.itemHandler[facing.ordinal()] == null) {
                this.itemHandler[facing.ordinal()] = (IItemHandler)new SidedInvWrapper((ISidedInventory)this, facing);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler[facing.ordinal()]);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return Intrinsics.areEqual(capability, (Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) || super.hasCapability(capability, facing);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public int[] func_180463_a(@Nullable EnumFacing side) {
        void var3_3;
        int size$iv = this.func_70302_i_();
        int[] result$iv = new int[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                void it;
                void var6_6 = ++i$iv;
                void var10_8 = i$iv;
                int[] nArray = result$iv;
                void var11_9 = it;
                nArray[var10_8] = var11_9;
            } while (i$iv != n2);
        }
        return var3_3;
    }

    public boolean func_94041_b(int index, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        InventorySlot invSlot = this.getInvSlot(index);
        return invSlot != null && invSlot.canInput() && invSlot.accepts(stack);
    }

    public int func_70297_j_() {
        int max = 0;
        for (InventorySlot slot : this.invSlots) {
            int n = slot.getStackSizeLimit();
            max = Math.max(max, n);
        }
        return max;
    }

    public void func_174889_b(@Nullable EntityPlayer player) {
    }

    public void func_174886_c(@Nullable EntityPlayer player) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70300_a(@Nullable EntityPlayer player) {
        if (this.func_145837_r()) return false;
        EntityPlayer entityPlayer = player;
        if (entityPlayer == null) {
            Intrinsics.throwNpe();
        }
        if (!(entityPlayer.func_174818_b(this.field_174879_c) <= (double)64)) return false;
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (InventorySlot invSlot : this.invSlots) {
            invSlot.markDirty();
        }
    }

    public void func_70299_a(int index, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        int ret = index;
        for (InventorySlot invSlot : this.invSlots) {
            if (ret < invSlot.size()) {
                invSlot.put(ret, stack);
                continue;
            }
            ret -= invSlot.size();
        }
    }

    @NotNull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = this.func_70301_a(index);
        if (StackUtilKt.isStackEmpty(itemStack)) {
            return StackUtilKt.getEmptyStack();
        }
        if (count >= StackUtilKt.getCount(itemStack)) {
            this.func_70299_a(index, StackUtilKt.getEmptyStack());
            return itemStack;
        }
        itemStack = StackUtilKt.shrink$default(itemStack, 0, 2, null);
        return StackUtilKt.copyWithNewCount(itemStack, count);
    }

    public final boolean addInvSlot(@NotNull InventorySlot invSlot) {
        Intrinsics.checkParameterIsNotNull((Object)invSlot, (String)"invSlot");
        return this.invSlots.add(invSlot);
    }

    private final InventorySlot getInvSlot(int index) {
        int i = index;
        for (InventorySlot invSlot : this.invSlots) {
            if (i < invSlot.size()) {
                return invSlot;
            }
            i -= invSlot.size();
        }
        return null;
    }

    public void func_174888_l() {
        for (InventorySlot invSlot : this.invSlots) {
            invSlot.clear();
        }
    }

    @NotNull
    public TextComponentString getDisplayName() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

