/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.tile;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.SaveNBT;
import waterpower.annotations.Sync;
import waterpower.common.block.tile.TileEntityInventory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u000bH$J\b\u0010\u0014\u001a\u00020\u0015H\u0017J-\u0010\u0016\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u000b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u000bJ\b\u0010\"\u001a\u00020\u0015H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0015H$J\b\u0010(\u001a\u00020\u0015H\u0016J\u0012\u0010)\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010\rH\u0004J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H$R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lwaterpower/common/block/tile/TileEntityMultiBlock;", "T", "Lwaterpower/common/block/tile/TileEntityInventory;", "()V", "blockList", "", "getBlockList", "()Ljava/util/List;", "setBlockList", "(Ljava/util/List;)V", "hasMaster", "", "masterPos", "Lnet/minecraft/util/math/BlockPos;", "tested", "getTested", "()Z", "setTested", "(Z)V", "canBeMaster", "checkStructure", "", "getCapability", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getMasterBlock", "()Lwaterpower/common/block/tile/TileEntityMultiBlock;", "hasCapability", "isIncompleteStructure", "isMaster", "isNormalBlock", "onFirstTick", "onMasterChanged", "onSyncDataChanged", "name", "", "onTestFailed", "onUpdate", "setMaster", "pos", "test", "WaterPower_main"})
public abstract class TileEntityMultiBlock<T extends TileEntityMultiBlock<T>>
extends TileEntityInventory {
    private boolean tested;
    @Sync
    @SaveNBT
    private BlockPos masterPos = new BlockPos(0, 0, 0);
    @Sync
    @SaveNBT
    private boolean hasMaster;
    @NotNull
    private List<? extends T> blockList = CollectionsKt.emptyList();

    protected final boolean getTested() {
        return this.tested;
    }

    protected final void setTested(boolean bl) {
        this.tested = bl;
    }

    @NotNull
    protected final List<T> getBlockList() {
        return this.blockList;
    }

    protected final void setBlockList(@NotNull List<? extends T> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.blockList = list;
    }

    protected final void setMaster(@Nullable BlockPos pos) {
        if (pos == null && this.hasMaster) {
            this.hasMaster = false;
        } else if (pos != null && !this.hasMaster) {
            this.hasMaster = true;
            this.masterPos = pos;
        } else if (pos != null && this.hasMaster && Intrinsics.areEqual((Object)this.masterPos, (Object)pos) ^ true) {
            this.masterPos = pos;
        }
    }

    @Nullable
    public final T getMasterBlock() {
        if (!this.hasMaster || this.func_145831_w() == null) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.masterPos);
        if (te == null || !(te instanceof TileEntityMultiBlock)) {
            this.setMaster(null);
            return null;
        }
        return (T)((Object)((TileEntityMultiBlock)te));
    }

    @Override
    public void onSyncDataChanged(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super.onSyncDataChanged(name);
        if (Intrinsics.areEqual((Object)"masterPos", (Object)name) || Intrinsics.areEqual((Object)"hasMaster", (Object)name)) {
            this.onMasterChanged();
        }
    }

    public void onMasterChanged() {
    }

    @NotNull
    protected abstract List<T> test();

    protected abstract boolean canBeMaster();

    public synchronized void checkStructure() {
        if (this.canBeMaster()) {
            boolean changed;
            this.tested = true;
            List<T> newBlockList = this.test();
            List<T> oldBlockList = this.blockList;
            boolean bl = changed = oldBlockList.isEmpty() || newBlockList.isEmpty() || Intrinsics.areEqual(newBlockList, oldBlockList) ^ true;
            if (changed && !oldBlockList.isEmpty()) {
                for (TileEntityMultiBlock block : oldBlockList) {
                    block.tested = false;
                    block.setMaster(null);
                }
            }
            this.blockList = newBlockList;
            if (newBlockList.isEmpty()) {
                this.tested = false;
                this.onTestFailed();
            } else if (changed) {
                for (TileEntityMultiBlock block : newBlockList) {
                    block.tested = true;
                    block.setMaster(this.field_174879_c);
                }
            }
        }
    }

    @Override
    public void onFirstTick() {
        super.onFirstTick();
        this.onMasterChanged();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.checkStructure();
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (!this.isIncompleteStructure() && !this.isMaster()) {
            T t = this.getMasterBlock();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            return ((TileEntityMultiBlock)((Object)t)).getCapability(capability, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (!this.isIncompleteStructure() && !this.isMaster()) {
            T t = this.getMasterBlock();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            return ((TileEntityMultiBlock)((Object)t)).hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public final boolean isMaster() {
        return Intrinsics.areEqual(this.getMasterBlock(), (Object)((Object)this));
    }

    public final boolean isIncompleteStructure() {
        return this.getMasterBlock() == null;
    }

    public final boolean isNormalBlock() {
        return !this.isMaster() && !this.isIncompleteStructure();
    }

    protected abstract void onTestFailed();
}

