/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.turbine;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import waterpower.annotations.HasGui;
import waterpower.common.block.container.ContainerRotor;
import waterpower.common.block.reservoir.TileEntityReservoir;
import waterpower.common.block.tile.TileEntityRotorGenerator;
import waterpower.common.block.turbine.GuiTurbine;
import waterpower.common.block.turbine.Turbines;
import waterpower.common.init.WPBlocks;

@HasGui(guiClass=GuiTurbine.class, containerClass=ContainerRotor.class)
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lwaterpower/common/block/turbine/TileEntityTurbine;", "Lwaterpower/common/block/tile/TileEntityRotorGenerator;", "type", "Lwaterpower/common/block/turbine/Turbines;", "(Lwaterpower/common/block/turbine/Turbines;)V", "getType", "()Lwaterpower/common/block/turbine/Turbines;", "computeOutput", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getBlockState", "Lnet/minecraft/block/state/IBlockState;", "getName", "", "getWater", "Lwaterpower/common/block/reservoir/TileEntityReservoir;", "WaterPower_main"})
public class TileEntityTurbine
extends TileEntityRotorGenerator {
    @NotNull
    private final Turbines type;

    @NotNull
    public String func_70005_c_() {
        return this.type.getLocalizedName();
    }

    @Override
    @NotNull
    public IBlockState getBlockState() {
        IBlockState iBlockState = super.getBlockState().func_177226_a((IProperty)WPBlocks.INSTANCE.getTurbine().getTYPES(), (Comparable)((Object)this.type));
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        return iBlockState;
    }

    private final TileEntityReservoir getWater(World world, BlockPos pos) {
        TileEntityReservoir reservoir = null;
        BlockPos newPos = pos.func_177972_a(this.getFacing().func_176734_d());
        if (newPos.func_177956_o() != pos.func_177956_o()) {
            return null;
        }
        TileEntity te = world.func_175625_s(newPos);
        if (te instanceof TileEntityReservoir) {
            reservoir = (TileEntityReservoir)te;
        }
        return reservoir;
    }

    @Override
    protected double computeOutput(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        TileEntityReservoir pair = this.getWater(world, pos);
        TileEntityReservoir tileEntityReservoir = pair;
        if ((tileEntityReservoir != null && (tileEntityReservoir = tileEntityReservoir.getFluidTank()) != null && (tileEntityReservoir = tileEntityReservoir.getFluid()) != null ? tileEntityReservoir.getFluid() : null) == null) {
            return 0.0;
        }
        FluidStack fluidStack = pair.getFluidTank().getFluid();
        if (fluidStack == null) {
            Intrinsics.throwNpe();
        }
        FluidStack fluidStack2 = fluidStack;
        int n = pair.getFluidTank().getFluidAmount();
        int n2 = pair.getType().getMaxExtract();
        int use = Math.min(n, n2);
        int multiple = 0;
        if (Intrinsics.areEqual((Object)fluidStack2.getFluid(), (Object)FluidRegistry.WATER)) {
            multiple = 1;
        } else if (FluidRegistry.isFluidRegistered((String)"steam") && Intrinsics.areEqual((Object)fluidStack2.getFluid(), (Object)FluidRegistry.getFluid((String)"steam")) || FluidRegistry.isFluidRegistered((String)"ic2steam") && Intrinsics.areEqual((Object)fluidStack2.getFluid(), (Object)FluidRegistry.getFluid((String)"ic2steam"))) {
            multiple = 5;
        }
        if (multiple == 0) {
            return 0.0;
        }
        double baseEnergy = 1.0 * (double)use / (double)2048 * (double)this.type.getOutput() * (double)multiple;
        double per = this.getEfficiency();
        if (per > 0.0) {
            double energy = baseEnergy * per;
            if (energy > 0.0) {
                pair.useLiquid(use);
                this.damageRotor(1);
            }
            return energy;
        }
        return 0.0;
    }

    @NotNull
    public final Turbines getType() {
        return this.type;
    }

    public TileEntityTurbine(@NotNull Turbines type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        super(type.getOutput(), 1.0E7, type.getTier());
        this.type = type;
    }
}

