/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.block.watermill;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import waterpower.annotations.HasGui;
import waterpower.annotations.Sync;
import waterpower.common.block.inventory.InventorySlotRange;
import waterpower.common.block.tile.TileEntityRotorGenerator;
import waterpower.common.block.watermill.ContainerWatermill;
import waterpower.common.block.watermill.EnumWatermill;
import waterpower.common.block.watermill.GuiWatermill;
import waterpower.common.init.WPBlocks;
import waterpower.common.item.ItemRange;
import waterpower.common.item.RangePlugins;
import waterpower.util.StackUtilKt;
import waterpower.util.UtilsKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@HasGui(guiClass=GuiWatermill.class, containerClass=ContainerWatermill.class)
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u0006J\b\u0010\u0015\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\b\u0010&\u001a\u00020\"H\u0016R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\n\u00a8\u0006'"}, d2={"Lwaterpower/common/block/watermill/TileEntityWatermill;", "Lwaterpower/common/block/tile/TileEntityRotorGenerator;", "type", "Lwaterpower/common/block/watermill/EnumWatermill;", "(Lwaterpower/common/block/watermill/EnumWatermill;)V", "_range", "", "get_range", "()I", "set_range", "(I)V", "lavaBlocks", "getLavaBlocks", "setLavaBlocks", "slotUpdater", "Lwaterpower/common/block/inventory/InventorySlotRange;", "getSlotUpdater", "()Lwaterpower/common/block/inventory/InventorySlotRange;", "getType", "()Lwaterpower/common/block/watermill/EnumWatermill;", "waterBlocks", "getWaterBlocks", "setWaterBlocks", "computeOutput", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getBlockState", "Lnet/minecraft/block/state/IBlockState;", "getName", "", "getRange", "", "hasRangeUpdater", "", "isRangeSupported", "onUpdate", "WaterPower_main"})
public class TileEntityWatermill
extends TileEntityRotorGenerator {
    @NotNull
    private final InventorySlotRange slotUpdater;
    @Sync
    private int waterBlocks;
    @Sync
    private int lavaBlocks;
    @Sync
    private int _range;
    @NotNull
    private final EnumWatermill type;

    @NotNull
    public final InventorySlotRange getSlotUpdater() {
        return this.slotUpdater;
    }

    public final int getWaterBlocks() {
        return this.waterBlocks;
    }

    public final void setWaterBlocks(int n) {
        this.waterBlocks = n;
    }

    public final int getLavaBlocks() {
        return this.lavaBlocks;
    }

    public final void setLavaBlocks(int n) {
        this.lavaBlocks = n;
    }

    public final int get_range() {
        return this._range;
    }

    public final void set_range(int n) {
        this._range = n;
    }

    @NotNull
    public String func_70005_c_() {
        return this.type.getLocalizedName();
    }

    @Override
    @NotNull
    public IBlockState getBlockState() {
        IBlockState iBlockState = super.getBlockState().func_177226_a((IProperty)WPBlocks.INSTANCE.getWatermill().getTYPES(), (Comparable)((Object)this.type));
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        return iBlockState;
    }

    /*
     * WARNING - void declaration
     */
    private final void getWaterBlocks() {
        int n;
        this.lavaBlocks = this.waterBlocks = 0;
        int range = this.getRange();
        if (range * range * range > 729) {
            this.lavaBlocks = this.waterBlocks = -1;
            return;
        }
        int n2 = -(range /= 2);
        if (n2 <= (n = range)) {
            while (true) {
                void xTest;
                int n3;
                int n4;
                if ((n4 = -range) <= (n3 = range)) {
                    while (true) {
                        void yTest;
                        int n5;
                        int n6;
                        if ((n6 = -range) <= (n5 = range)) {
                            while (true) {
                                int n7;
                                void zTest;
                                BlockPos newPos = this.field_174879_c.func_177982_a((int)xTest, (int)yTest, (int)zTest);
                                World world = this.func_145831_w();
                                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"getWorld()");
                                BlockPos blockPos = newPos;
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"newPos");
                                if (UtilsKt.isWater(world, blockPos)) {
                                    n7 = this.waterBlocks;
                                    this.waterBlocks = n7 + 1;
                                } else {
                                    World world2 = this.func_145831_w();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"getWorld()");
                                    BlockPos blockPos2 = newPos;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"newPos");
                                    if (UtilsKt.isLava(world2, blockPos2)) {
                                        n7 = this.lavaBlocks;
                                        this.lavaBlocks = n7 + 1;
                                    }
                                }
                                if (zTest == n5) break;
                                ++zTest;
                            }
                        }
                        if (yTest == n3) break;
                        ++yTest;
                    }
                }
                if (xTest == n) break;
                ++xTest;
            }
        }
        if (this.type.ordinal() < 2) {
            this.lavaBlocks = 0;
        }
    }

    @Override
    protected double computeOutput(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (this.waterBlocks == -1) {
            return 0.0;
        }
        int vol = this.getRange();
        vol *= vol * vol;
        double waterPercent = (double)this.waterBlocks * 1.0 / (double)(vol - 1);
        double lavaPercent = (double)this.lavaBlocks * 1.0 / (double)(vol - 1);
        double percent = waterPercent + lavaPercent * (double)4;
        double energy = (double)this.type.getOutput() * percent;
        if ((energy *= this.getEfficiency()) > 0.0) {
            this.damageRotor(1);
        }
        return energy;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.getWaterBlocks();
    }

    public final boolean isRangeSupported() {
        return this.waterBlocks != -1 && this.lavaBlocks != -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasRangeUpdater() {
        int n;
        int n2;
        if (!this.slotUpdater.isEmpty() && (n2 = 0) <= (n = this.slotUpdater.size() - 1)) {
            while (true) {
                void i;
                if (!StackUtilKt.isStackEmpty(this.slotUpdater.get((int)i)) && this.slotUpdater.get((int)i).func_77973_b() instanceof ItemRange) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int getRange() {
        if (this.func_145831_w().field_72995_K && this._range != 0) {
            return this._range;
        }
        this._range = this.type.getCheckSize();
        if (this.hasRangeUpdater()) {
            int n;
            IntRange intRange = RangesKt.until((int)0, (int)this.slotUpdater.size());
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    ItemStack stack;
                    if (!StackUtilKt.isStackEmpty(stack = this.slotUpdater.get((int)i))) {
                        if (stack.func_77973_b() instanceof ItemRange && stack.func_77952_i() >= ((Object[])RangePlugins.values()).length) {
                            return this.type.getCheckSize();
                        }
                        this._range -= StackUtilKt.getCount(stack) * RangePlugins.values()[stack.func_77952_i()].getRange();
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
        if (this._range < 3) {
            this._range = 3;
        }
        return this._range;
    }

    @NotNull
    public final EnumWatermill getType() {
        return this.type;
    }

    public TileEntityWatermill(@NotNull EnumWatermill type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        super(type.getOutput(), 2097152.0, type.getTier());
        this.type = type;
        this.slotUpdater = new InventorySlotRange(this, 0, 2, null);
    }
}

