/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.Message;
import waterpower.common.block.tile.TileEntityBase;
import waterpower.common.network.Packet;
import waterpower.util.UtilsKt;

@Message(handlerSide=Side.CLIENT)
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lwaterpower/common/network/PacketTileEntity;", "Lwaterpower/common/network/Packet;", "entity", "Lwaterpower/common/block/tile/TileEntityBase;", "(Lwaterpower/common/block/tile/TileEntityBase;)V", "()V", "base", "getBase", "()Lwaterpower/common/block/tile/TileEntityBase;", "setBase", "pos", "", "getPos", "()J", "setPos", "(J)V", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "getTag", "()Lnet/minecraft/nbt/NBTTagCompound;", "setTag", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "onMessage", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "toBytes", "WaterPower_main"})
public final class PacketTileEntity
extends Packet<PacketTileEntity> {
    private long pos;
    @Nullable
    private TileEntityBase base;
    @Nullable
    private NBTTagCompound tag;

    public final long getPos() {
        return this.pos;
    }

    public final void setPos(long l) {
        this.pos = l;
    }

    @Nullable
    public final TileEntityBase getBase() {
        return this.base;
    }

    public final void setBase(@Nullable TileEntityBase tileEntityBase) {
        this.base = tileEntityBase;
    }

    @Nullable
    public final NBTTagCompound getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable NBTTagCompound nBTTagCompound) {
        this.tag = nBTTagCompound;
    }

    @Nullable
    public IMessage onMessage(@NotNull PacketTileEntity message, @NotNull MessageContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        World world = UtilsKt.getWorld();
        if (world == null) {
            return null;
        }
        World world2 = world;
        TileEntity te = world2.func_175625_s(BlockPos.func_177969_a((long)message.pos));
        message.base = te instanceof TileEntityBase ? (TileEntityBase)te : (TileEntityBase)null;
        if (message.base == null || message.tag == null) {
            return null;
        }
        TileEntityBase tileEntityBase = message.base;
        if (tileEntityBase == null) {
            Intrinsics.throwNpe();
        }
        NBTTagCompound nBTTagCompound = message.tag;
        if (nBTTagCompound == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
        }
        tileEntityBase.readPacketData(nBTTagCompound);
        return null;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.pos = buf.readLong();
        int len = buf.readInt();
        byte[] data = new byte[len];
        buf.readBytes(data);
        try {
            this.tag = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        buf.writeLong(this.pos);
        if (this.tag == null) {
            this.tag = new NBTTagCompound();
            TileEntityBase tileEntityBase = this.base;
            if (tileEntityBase == null) {
                Intrinsics.throwNpe();
            }
            NBTTagCompound nBTTagCompound = this.tag;
            if (nBTTagCompound == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            TileEntityBase.writePacketData$default(tileEntityBase, nBTTagCompound, false, 2, null);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.tag, (DataOutput)dos);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        byte[] data = baos.toByteArray();
        buf.writeInt(data.length);
        buf.writeBytes(data);
    }

    public PacketTileEntity() {
    }

    public PacketTileEntity(@NotNull TileEntityBase entity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        this();
        this.pos = entity.func_174877_v().func_177986_g();
        this.base = entity;
    }
}

