/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.network;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.Message;
import waterpower.api.IUnitChangeable;
import waterpower.common.Energy;
import waterpower.common.network.Packet;

@Message(handlerSide=Side.SERVER)
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lwaterpower/common/network/PacketUnitChanged;", "Lwaterpower/common/network/Packet;", "dim", "", "pos", "Lnet/minecraft/util/math/BlockPos;", "energy", "Lwaterpower/common/Energy;", "(ILnet/minecraft/util/math/BlockPos;Lwaterpower/common/Energy;)V", "()V", "", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "onMessage", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "message", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "toBytes", "WaterPower_main"})
public final class PacketUnitChanged
extends Packet<PacketUnitChanged> {
    private int dim;
    private Energy energy;
    private long pos;

    @Nullable
    public IMessage onMessage(@NotNull PacketUnitChanged message, @NotNull MessageContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        WorldServer world = DimensionManager.getWorld((int)message.dim);
        TileEntity te = world.func_175625_s(BlockPos.func_177969_a((long)message.pos));
        if (te instanceof IUnitChangeable) {
            ((IUnitChangeable)te).setUnit(message.energy);
        }
        return null;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.dim = buf.readInt();
        this.pos = buf.readLong();
        this.energy = Energy.values()[buf.readInt()];
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        buf.writeInt(this.dim);
        buf.writeLong(this.pos);
        buf.writeInt(this.energy.ordinal());
    }

    public PacketUnitChanged() {
        this.energy = Energy.EU;
    }

    public PacketUnitChanged(int dim, @NotNull BlockPos pos, @NotNull Energy energy) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)((Object)energy), (String)"energy");
        this();
        this.dim = dim;
        this.pos = pos.func_177986_g();
        this.energy = energy;
    }
}

