/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.recipe.IRecipeInput;
import waterpower.common.recipe.IRecipeManager;
import waterpower.common.recipe.RecipeManager;
import waterpower.common.recipe.RecipeOutput;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0001J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lwaterpower/common/recipe/MultiRecipeManager;", "Lwaterpower/common/recipe/IRecipeManager;", "()V", "container", "", "getContainer$WaterPower_main", "()Ljava/util/List;", "setContainer$WaterPower_main", "(Ljava/util/List;)V", "addRecipe", "", "input", "Lnet/minecraft/item/ItemStack;", "outputs", "", "(Lnet/minecraft/item/ItemStack;[Lnet/minecraft/item/ItemStack;)Z", "addRecipeManager", "rm", "getAllRecipes", "", "Lwaterpower/common/recipe/IRecipeInput;", "Lwaterpower/common/recipe/RecipeOutput;", "getOutput", "adjustInput", "removeRecipe", "WaterPower_main"})
public final class MultiRecipeManager
implements IRecipeManager {
    @NotNull
    private List<IRecipeManager> container = new ArrayList();

    @NotNull
    public final List<IRecipeManager> getContainer$WaterPower_main() {
        return this.container;
    }

    public final void setContainer$WaterPower_main(@NotNull List<IRecipeManager> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.container = list;
    }

    @Override
    public boolean addRecipe(@NotNull ItemStack input, ItemStack ... outputs) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)outputs, (String)"outputs");
        for (IRecipeManager r : this.container) {
            if (!r.addRecipe(input, Arrays.copyOf(outputs, outputs.length))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRecipe(@NotNull ItemStack input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        for (IRecipeManager r : this.container) {
            if (!r.removeRecipe(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public RecipeOutput getOutput(@NotNull ItemStack input, boolean adjustInput) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        for (IRecipeManager r : this.container) {
            RecipeOutput a = r.getOutput(input, adjustInput);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<IRecipeInput, RecipeOutput> getAllRecipes() {
        HashMap<IRecipeInput, RecipeOutput> map = new HashMap<IRecipeInput, RecipeOutput>();
        for (IRecipeManager r : this.container) {
            map.putAll(r.getAllRecipes());
        }
        return map;
    }

    @NotNull
    public final MultiRecipeManager addRecipeManager(@NotNull IRecipeManager rm) {
        Intrinsics.checkParameterIsNotNull((Object)rm, (String)"rm");
        this.container.add(rm);
        return this;
    }

    public MultiRecipeManager() {
        this.addRecipeManager(new RecipeManager());
    }
}

