/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.recipe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.common.recipe.IRecipeInput;
import waterpower.common.recipe.IRecipeManager;
import waterpower.common.recipe.RecipeInputItemStack;
import waterpower.common.recipe.RecipeOutput;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000e\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u0004J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lwaterpower/common/recipe/RecipeManager;", "Lwaterpower/common/recipe/IRecipeManager;", "()V", "recipes", "Ljava/util/HashMap;", "Lwaterpower/common/recipe/IRecipeInput;", "Lwaterpower/common/recipe/RecipeOutput;", "singleOutputRecipes", "Ljava/util/ArrayList;", "Lnet/minecraft/item/ItemStack;", "addRecipe", "", "input", "outputs", "", "(Lnet/minecraft/item/ItemStack;[Lnet/minecraft/item/ItemStack;)Z", "getAllRecipes", "", "getOutput", "adjustInput", "registerSingleOutputRecipes", "", "map", "removeRecipe", "WaterPower_main"})
public final class RecipeManager
implements IRecipeManager {
    private final HashMap<IRecipeInput, RecipeOutput> recipes = new HashMap();
    private final ArrayList<HashMap<ItemStack, ItemStack>> singleOutputRecipes = new ArrayList();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addRecipe(@NotNull ItemStack input, ItemStack ... outputs) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)outputs, (String)"outputs");
        if (StackUtilKt.isStackEmpty(input)) {
            return false;
        }
        int n = 0;
        int n2 = outputs.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (StackUtilKt.isStackEmpty(outputs[i])) {
                    throw (Throwable)new NullPointerException("The output ItemStack #" + (int)i + " is empty (counting from 0)");
                }
                if (i == n2) break;
                ++i;
            }
        }
        for (IRecipeInput existingInput : this.recipes.keySet()) {
            if (!existingInput.matches(input)) continue;
            return false;
        }
        this.recipes.put(new RecipeInputItemStack(input, 0, 2, null), new RecipeOutput(Arrays.copyOf(outputs, outputs.length)));
        return true;
    }

    @Override
    public boolean removeRecipe(@NotNull ItemStack input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (StackUtilKt.isStackEmpty(input)) {
            throw (Throwable)new NullPointerException("The recipe input is null");
        }
        LinkedList<IRecipeInput> r = new LinkedList<IRecipeInput>();
        for (IRecipeInput existingInput : this.recipes.keySet()) {
            if (!existingInput.matches(input)) continue;
            r.add(existingInput);
        }
        for (IRecipeInput s : r) {
            this.recipes.remove(s);
        }
        return !r.isEmpty();
    }

    @Override
    @Nullable
    public RecipeOutput getOutput(@NotNull ItemStack input, boolean adjustInput) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        ItemStack input2 = input;
        if (StackUtilKt.isStackEmpty(input2)) {
            return null;
        }
        Iterator<Map.Entry<IRecipeInput, RecipeOutput>> iterator2 = this.recipes.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IRecipeInput, RecipeOutput> entry;
            Map.Entry<IRecipeInput, RecipeOutput> entry2 = entry = iterator2.next();
            IRecipeInput recipeInput = entry2.getKey();
            entry2 = entry;
            RecipeOutput recipeOutput = entry2.getValue();
            if (!recipeInput.matches(input2)) continue;
            if (StackUtilKt.getCount(input2) < recipeInput.getAmount() || input2.func_77973_b().func_77634_r() && StackUtilKt.getCount(input2) != recipeInput.getAmount()) break;
            if (adjustInput) {
                if (input2.func_77973_b().func_77634_r()) {
                    ItemStack container = input2.func_77973_b().getContainerItem(input2);
                    ItemStack itemStack = container.func_77946_l();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"container.copy()");
                    input2 = itemStack;
                } else {
                    input2 = StackUtilKt.shrink(input2, recipeInput.getAmount());
                }
            }
            return recipeOutput;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<IRecipeInput, RecipeOutput> getAllRecipes() {
        return this.recipes;
    }

    public final void registerSingleOutputRecipes(@Nullable HashMap<ItemStack, ItemStack> map) {
        if (map == null) {
            return;
        }
        this.singleOutputRecipes.add(map);
    }
}

