/*
 * Decompiled with CFR 0.152.
 */
package waterpower.common.recipe;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jetbrains.annotations.NotNull;
import waterpower.common.recipe.RecipeManagers;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ\u001e\u0010*\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ+\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020\n2\u0016\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000100\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u00101J+\u00102\u001a\u00020.2\u0006\u0010)\u001a\u00020\n2\u0016\u0010/\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000100\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u00101J\u0016\u00103\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ\u0016\u00104\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ\u000e\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u0015J\u0016\u00107\u001a\u00020.2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ\u0016\u00108\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R-\u0010\u0007\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR3\u0010\u000f\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010j\u0002`\u00120\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR3\u0010\u0014\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010j\u0002`\u00160\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR-\u0010\u0018\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR-\u0010\u001a\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR-\u0010\u001c\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R-\u0010#\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR-\u0010%\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000e\u00a8\u00069"}, d2={"Lwaterpower/common/recipe/Recipes;", "", "()V", "GROUP", "Lnet/minecraft/util/ResourceLocation;", "getGROUP", "()Lnet/minecraft/util/ResourceLocation;", "benders", "Ljava/util/LinkedList;", "Lkotlin/Function2;", "Lnet/minecraft/item/ItemStack;", "", "Lwaterpower/common/recipe/RecipeAddPredicate;", "getBenders", "()Ljava/util/LinkedList;", "blastFurnaces", "Lkotlin/Function3;", "", "Lwaterpower/common/recipe/BlastFurnaceRecipeAddPredicate;", "getBlastFurnaces", "blastFurnacesOreDict", "", "Lwaterpower/common/recipe/BlastFurnaceOreDictRecipeAddPredicate;", "getBlastFurnacesOreDict", "compressors", "getCompressors", "crushers", "getCrushers", "cutters", "getCutters", "id", "getId", "()I", "setId", "(I)V", "lathes", "getLathes", "sawmills", "getSawmills", "bender", "input", "output", "blastFurnace", "time", "compressor", "craft", "", "pars", "", "(Lnet/minecraft/item/ItemStack;[Ljava/lang/Object;)V", "craftShapeless", "crusher", "cutter", "doesOreNameExist", "name", "furnace", "lathe", "WaterPower_main"})
public final class Recipes {
    @NotNull
    private static final LinkedList<Function2<ItemStack, ItemStack, Boolean>> lathes;
    @NotNull
    private static final LinkedList<Function2<ItemStack, ItemStack, Boolean>> crushers;
    @NotNull
    private static final LinkedList<Function2<ItemStack, ItemStack, Boolean>> sawmills;
    @NotNull
    private static final LinkedList<Function2<ItemStack, ItemStack, Boolean>> cutters;
    @NotNull
    private static final LinkedList<Function2<ItemStack, ItemStack, Boolean>> compressors;
    @NotNull
    private static final LinkedList<Function2<ItemStack, ItemStack, Boolean>> benders;
    @NotNull
    private static final LinkedList<Function3<ItemStack, ItemStack, Integer, Boolean>> blastFurnaces;
    @NotNull
    private static final LinkedList<Function3<String, ItemStack, Integer, Boolean>> blastFurnacesOreDict;
    @NotNull
    private static final ResourceLocation GROUP;
    private static int id;
    public static final Recipes INSTANCE;

    @NotNull
    public final LinkedList<Function2<ItemStack, ItemStack, Boolean>> getLathes() {
        return lathes;
    }

    @NotNull
    public final LinkedList<Function2<ItemStack, ItemStack, Boolean>> getCrushers() {
        return crushers;
    }

    @NotNull
    public final LinkedList<Function2<ItemStack, ItemStack, Boolean>> getSawmills() {
        return sawmills;
    }

    @NotNull
    public final LinkedList<Function2<ItemStack, ItemStack, Boolean>> getCutters() {
        return cutters;
    }

    @NotNull
    public final LinkedList<Function2<ItemStack, ItemStack, Boolean>> getCompressors() {
        return compressors;
    }

    @NotNull
    public final LinkedList<Function2<ItemStack, ItemStack, Boolean>> getBenders() {
        return benders;
    }

    @NotNull
    public final LinkedList<Function3<ItemStack, ItemStack, Integer, Boolean>> getBlastFurnaces() {
        return blastFurnaces;
    }

    @NotNull
    public final LinkedList<Function3<String, ItemStack, Integer, Boolean>> getBlastFurnacesOreDict() {
        return blastFurnacesOreDict;
    }

    public final boolean bender(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean flag = false;
        for (Function2 function2 : benders) {
            flag |= ((Boolean)function2.invoke((Object)input, (Object)output)).booleanValue();
        }
        return flag;
    }

    public final boolean blastFurnace(@NotNull ItemStack input, @NotNull ItemStack output, int time) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean flag = false;
        for (Function3 function3 : blastFurnaces) {
            flag |= ((Boolean)function3.invoke((Object)input, (Object)output, (Object)time)).booleanValue();
        }
        return flag;
    }

    public final boolean compressor(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean flag = false;
        for (Function2 function2 : compressors) {
            flag |= ((Boolean)function2.invoke((Object)input, (Object)output)).booleanValue();
        }
        return flag;
    }

    public final boolean crusher(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean flag = false;
        for (Function2 function2 : crushers) {
            flag |= ((Boolean)function2.invoke((Object)input, (Object)output)).booleanValue();
        }
        if (!flag) {
            flag |= RecipeManagers.INSTANCE.getCrusher().addRecipe(input, output);
        }
        return flag;
    }

    public final boolean cutter(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean flag = false;
        for (Function2 function2 : cutters) {
            flag |= ((Boolean)function2.invoke((Object)input, (Object)output)).booleanValue();
        }
        return flag;
    }

    public final boolean lathe(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean flag = false;
        for (Function2 function2 : lathes) {
            flag |= ((Boolean)function2.invoke((Object)input, (Object)output)).booleanValue();
        }
        return flag;
    }

    public final void furnace(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)0.0f);
    }

    public final boolean doesOreNameExist(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Collection collection = (Collection)OreDictionary.getOres((String)name);
        return !collection.isEmpty();
    }

    @NotNull
    public final ResourceLocation getGROUP() {
        return GROUP;
    }

    public final int getId() {
        return id;
    }

    public final void setId(int n) {
        id = n;
    }

    public final void craft(@NotNull ItemStack output, Object ... pars) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)pars, (String)"pars");
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(GROUP, output, Arrays.copyOf(pars, pars.length)).setRegistryName("waterpower", String.valueOf(++id)));
    }

    public final void craftShapeless(@NotNull ItemStack output, Object ... pars) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)pars, (String)"pars");
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(GROUP, output, Arrays.copyOf(pars, pars.length)).setRegistryName("waterpower", String.valueOf(++id)));
    }

    private Recipes() {
        INSTANCE = this;
        lathes = new LinkedList();
        crushers = new LinkedList();
        sawmills = new LinkedList();
        cutters = new LinkedList();
        compressors = new LinkedList();
        benders = new LinkedList();
        blastFurnaces = new LinkedList();
        blastFurnacesOreDict = new LinkedList();
        GROUP = new ResourceLocation("waterpower:recipes");
    }

    static {
        new Recipes();
    }
}

