/*
 * Decompiled with CFR 0.152.
 */
package waterpower.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.config.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.Init;
import waterpower.annotations.Parser;
import waterpower.config.ConfigCategory;
import waterpower.config.ConfigValue;
import waterpower.config.OreConfig;

@Init
@Parser
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0006\u001b\u001c\u001d\u001e\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00152\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0007J\b\u0010\u0018\u001a\u00020\u0015H\u0007J\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0015R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR-\u0010\u000f\u001a\u001e\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lwaterpower/config/ConfigHandler;", "", "()V", "config", "Lnet/minecraftforge/common/config/Configuration;", "getConfig", "()Lnet/minecraftforge/common/config/Configuration;", "setConfig", "(Lnet/minecraftforge/common/config/Configuration;)V", "loadedWrappers", "Ljava/util/ArrayList;", "Lwaterpower/config/ConfigHandler$FieldWrapper;", "Lkotlin/collections/ArrayList;", "getLoadedWrappers", "()Ljava/util/ArrayList;", "wrappers", "", "Ljava/lang/Class;", "getWrappers", "()Ljava/util/Map;", "load", "", "loadClass", "clazz", "preInit", "read", "save", "BooleanFieldWrapper", "DoubleFieldWrapper", "FieldWrapper", "IntFieldWrapper", "OreConfigFieldWrapper", "StringFieldWrapper", "WaterPower_main"})
public final class ConfigHandler {
    @NotNull
    private static final ArrayList<FieldWrapper> loadedWrappers;
    @NotNull
    public static Configuration config;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends FieldWrapper>> wrappers;
    public static final ConfigHandler INSTANCE;

    @NotNull
    public final ArrayList<FieldWrapper> getLoadedWrappers() {
        return loadedWrappers;
    }

    @NotNull
    public final Configuration getConfig() {
        Configuration configuration = config;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return configuration;
    }

    public final void setConfig(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        config = configuration;
    }

    @JvmStatic
    public static final void loadClass(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        ConfigCategory configCategory = clazz.getAnnotation(ConfigCategory.class);
        if (configCategory == null) {
            return;
        }
        ConfigCategory cc = configCategory;
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.isAnnotationPresent(ConfigValue.class)) continue;
            f.setAccessible(true);
            ConfigValue annotation = f.getAnnotation(ConfigValue.class);
            Class<? extends FieldWrapper> clazz2 = wrappers.get(f.getType());
            if (clazz2 == null) {
                Intrinsics.throwNpe();
            }
            loadedWrappers.add(clazz2.getConstructor(Object.class, Field.class, ConfigValue.class, ConfigCategory.class).newInstance(null, f, annotation, cc));
        }
    }

    public final void read() {
        for (FieldWrapper w : loadedWrappers) {
            try {
                w.read(this);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public final void load() {
        Configuration configuration = config;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        configuration.load();
    }

    public final void save() {
        Configuration configuration = config;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        configuration.save();
    }

    @JvmStatic
    public static final void preInit() {
        INSTANCE.load();
        INSTANCE.read();
        INSTANCE.save();
    }

    @NotNull
    public final Map<Class<? extends Object>, Class<? extends FieldWrapper>> getWrappers() {
        return wrappers;
    }

    private ConfigHandler() {
        INSTANCE = this;
        loadedWrappers = new ArrayList();
        wrappers = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to(Integer.TYPE, IntFieldWrapper.class), TuplesKt.to(Double.TYPE, DoubleFieldWrapper.class), TuplesKt.to(Boolean.TYPE, BooleanFieldWrapper.class), TuplesKt.to(String.class, StringFieldWrapper.class), TuplesKt.to(OreConfig.class, OreConfigFieldWrapper.class)});
    }

    static {
        new ConfigHandler();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0007\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00120\u0012J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H&J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lwaterpower/config/ConfigHandler$FieldWrapper;", "", "obj", "field", "Ljava/lang/reflect/Field;", "value", "Lwaterpower/config/ConfigValue;", "category", "Lwaterpower/config/ConfigCategory;", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lwaterpower/config/ConfigValue;Lwaterpower/config/ConfigCategory;)V", "getCategory", "()Lwaterpower/config/ConfigCategory;", "getField", "()Ljava/lang/reflect/Field;", "getObj", "()Ljava/lang/Object;", "getValue", "()Lwaterpower/config/ConfigValue;", "", "key", "kotlin.jvm.PlatformType", "parse", "handler", "Lwaterpower/config/ConfigHandler;", "read", "", "WaterPower_main"})
    public static abstract class FieldWrapper {
        @Nullable
        private final Object obj;
        @NotNull
        private final Field field;
        @NotNull
        private final ConfigValue value;
        @Nullable
        private final ConfigCategory category;

        @NotNull
        public final String category() {
            Object object = this.category;
            if (object == null || (object = object.category()) == null) {
                object = this.value.category();
            }
            return object;
        }

        public final String key() {
            return Intrinsics.areEqual((Object)this.value.key(), (Object)"") ? this.field.getName() : this.value.key();
        }

        public final void read(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            this.field.set(this.obj, this.parse(handler));
        }

        @Nullable
        public abstract Object parse(@NotNull ConfigHandler var1);

        @Nullable
        public final Object getObj() {
            return this.obj;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @NotNull
        public final ConfigValue getValue() {
            return this.value;
        }

        @Nullable
        public final ConfigCategory getCategory() {
            return this.category;
        }

        public FieldWrapper(@Nullable Object obj, @NotNull Field field, @NotNull ConfigValue value, @Nullable ConfigCategory category) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.obj = obj;
            this.field = field;
            this.value = value;
            this.category = category;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lwaterpower/config/ConfigHandler$IntFieldWrapper;", "Lwaterpower/config/ConfigHandler$FieldWrapper;", "obj", "", "field", "Ljava/lang/reflect/Field;", "value", "Lwaterpower/config/ConfigValue;", "category", "Lwaterpower/config/ConfigCategory;", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lwaterpower/config/ConfigValue;Lwaterpower/config/ConfigCategory;)V", "parse", "handler", "Lwaterpower/config/ConfigHandler;", "WaterPower_main"})
    public static final class IntFieldWrapper
    extends FieldWrapper {
        @Override
        @Nullable
        public Object parse(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            return handler.getConfig().get(this.category(), this.key(), this.getField().getInt(this.getObj()), this.getValue().comment()).getInt();
        }

        public IntFieldWrapper(@Nullable Object obj, @NotNull Field field, @NotNull ConfigValue value, @Nullable ConfigCategory category) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            super(obj, field, value, category);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lwaterpower/config/ConfigHandler$DoubleFieldWrapper;", "Lwaterpower/config/ConfigHandler$FieldWrapper;", "obj", "", "field", "Ljava/lang/reflect/Field;", "value", "Lwaterpower/config/ConfigValue;", "category", "Lwaterpower/config/ConfigCategory;", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lwaterpower/config/ConfigValue;Lwaterpower/config/ConfigCategory;)V", "parse", "handler", "Lwaterpower/config/ConfigHandler;", "WaterPower_main"})
    public static final class DoubleFieldWrapper
    extends FieldWrapper {
        @Override
        @Nullable
        public Object parse(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            return handler.getConfig().get(this.category(), this.key(), this.getField().getDouble(this.getObj()), this.getValue().comment()).getDouble();
        }

        public DoubleFieldWrapper(@Nullable Object obj, @NotNull Field field, @NotNull ConfigValue value, @Nullable ConfigCategory category) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            super(obj, field, value, category);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lwaterpower/config/ConfigHandler$BooleanFieldWrapper;", "Lwaterpower/config/ConfigHandler$FieldWrapper;", "obj", "", "field", "Ljava/lang/reflect/Field;", "value", "Lwaterpower/config/ConfigValue;", "category", "Lwaterpower/config/ConfigCategory;", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lwaterpower/config/ConfigValue;Lwaterpower/config/ConfigCategory;)V", "parse", "handler", "Lwaterpower/config/ConfigHandler;", "WaterPower_main"})
    public static final class BooleanFieldWrapper
    extends FieldWrapper {
        @Override
        @Nullable
        public Object parse(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            return handler.getConfig().get(this.category(), this.key(), this.getField().getBoolean(this.getObj()), this.getValue().comment()).getBoolean();
        }

        public BooleanFieldWrapper(@Nullable Object obj, @NotNull Field field, @NotNull ConfigValue value, @Nullable ConfigCategory category) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            super(obj, field, value, category);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lwaterpower/config/ConfigHandler$StringFieldWrapper;", "Lwaterpower/config/ConfigHandler$FieldWrapper;", "obj", "", "field", "Ljava/lang/reflect/Field;", "value", "Lwaterpower/config/ConfigValue;", "category", "Lwaterpower/config/ConfigCategory;", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lwaterpower/config/ConfigValue;Lwaterpower/config/ConfigCategory;)V", "parse", "handler", "Lwaterpower/config/ConfigHandler;", "WaterPower_main"})
    public static final class StringFieldWrapper
    extends FieldWrapper {
        @Override
        @Nullable
        public Object parse(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            Object object = this.getField().get(this.getObj());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            return handler.getConfig().get(this.category(), this.key(), (String)object, this.getValue().comment()).getString();
        }

        public StringFieldWrapper(@Nullable Object obj, @NotNull Field field, @NotNull ConfigValue value, @Nullable ConfigCategory category) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            super(obj, field, value, category);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lwaterpower/config/ConfigHandler$OreConfigFieldWrapper;", "Lwaterpower/config/ConfigHandler$FieldWrapper;", "obj", "", "field", "Ljava/lang/reflect/Field;", "value", "Lwaterpower/config/ConfigValue;", "category", "Lwaterpower/config/ConfigCategory;", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Lwaterpower/config/ConfigValue;Lwaterpower/config/ConfigCategory;)V", "parse", "handler", "Lwaterpower/config/ConfigHandler;", "WaterPower_main"})
    public static final class OreConfigFieldWrapper
    extends FieldWrapper {
        @Override
        @Nullable
        public Object parse(@NotNull ConfigHandler handler) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            String categoryStr = this.category() + "." + this.key();
            Object object = this.getField().get(this.getObj());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type waterpower.config.OreConfig");
            }
            boolean generate = handler.getConfig().getBoolean(categoryStr, "generates", ((OreConfig)object).getGenerate(), "Whether " + this.key() + " should be generated or not.");
            Object object2 = this.getField().get(this.getObj());
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type waterpower.config.OreConfig");
            }
            int amount = handler.getConfig().get(categoryStr, "amountPerChunk", ((OreConfig)object2).getAmountPerChunk(), "Amount of " + this.key() + " per chunk").getInt();
            Object object3 = this.getField().get(this.getObj());
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type waterpower.config.OreConfig");
            }
            int size = handler.getConfig().get(categoryStr, "maxSize", ((OreConfig)object3).getMaxSize(), "Amount of " + this.key() + " per vein").getInt();
            Object object4 = this.getField().get(this.getObj());
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type waterpower.config.OreConfig");
            }
            int min = handler.getConfig().get(categoryStr, "minLevel", ((OreConfig)object4).getMinLevel(), "Min level to generate " + this.key()).getInt();
            Object object5 = this.getField().get(this.getObj());
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type waterpower.config.OreConfig");
            }
            int max = handler.getConfig().get(categoryStr, "maxLevel", ((OreConfig)object5).getMaxLevel(), "Max level to generate " + this.key()).getInt();
            return new OreConfig(amount, size, min, max, generate);
        }

        public OreConfigFieldWrapper(@Nullable Object obj, @NotNull Field field, @NotNull ConfigValue value, @Nullable ConfigCategory category) {
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            super(obj, field, value, category);
        }
    }
}

