/*
 * Decompiled with CFR 0.152.
 */
package waterpower.integration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.jetbrains.annotations.NotNull;
import waterpower.annotations.Integration;
import waterpower.common.block.BlockEnum;
import waterpower.common.block.ore.Ores;
import waterpower.common.init.WPBlocks;
import waterpower.common.init.WPItems;
import waterpower.common.item.MaterialForms;
import waterpower.common.recipe.Recipes;
import waterpower.integration.IModule;

@Integration(modID="mekanism")
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0012H\u0002\u00a8\u0006\u0019"}, d2={"Lwaterpower/integration/MekanismModule;", "Lwaterpower/integration/IModule;", "()V", "blastFurnace", "", "input", "Lnet/minecraft/item/ItemStack;", "output", "time", "", "convertToSimpleRecipe", "Lnet/minecraft/nbt/NBTTagCompound;", "out", "crusher", "stack", "enrichmentChamber", "metallurgicInfuser", "infuse", "", "amount", "onInit", "", "onPreInit", "recipe", "recipeName", "WaterPower_main"})
public final class MekanismModule
extends IModule {
    public static final MekanismModule INSTANCE;

    @Optional.Method(modid="mekanism")
    public final boolean blastFurnace(@NotNull ItemStack input, @NotNull ItemStack output, int time) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        return this.metallurgicInfuser("CARBON", Math.round((float)time / 100.0f), input, output);
    }

    @Optional.Method(modid="mekanism")
    public final boolean metallurgicInfuser(@NotNull String infuse, int amount, @NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)infuse, (String)"infuse");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        NBTTagCompound sendTag = this.convertToSimpleRecipe(input, output);
        sendTag.func_74778_a("infuseType", infuse);
        sendTag.func_74768_a("infuseAmount", amount);
        return FMLInterModComms.sendMessage((String)"mekanism", (String)"MetallurgicInfuserRecipe", (NBTTagCompound)sendTag);
    }

    @Optional.Method(modid="mekanism")
    public final boolean crusher(@NotNull ItemStack stack, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        return this.recipe(stack, output, "Crusher");
    }

    @Optional.Method(modid="mekanism")
    public final boolean enrichmentChamber(@NotNull ItemStack stack, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        return this.recipe(stack, output, "EnrichmentChamber");
    }

    private final boolean recipe(ItemStack input, ItemStack output, String recipeName) {
        NBTTagCompound sendTag = this.convertToSimpleRecipe(input, output);
        return FMLInterModComms.sendMessage((String)"mekanism", (String)(recipeName + "Recipe"), (NBTTagCompound)sendTag);
    }

    private final NBTTagCompound convertToSimpleRecipe(ItemStack input, ItemStack out) {
        NBTTagCompound sendTag = new NBTTagCompound();
        NBTTagCompound inputTagDummy = new NBTTagCompound();
        NBTTagCompound outputTagDummy = new NBTTagCompound();
        NBTTagCompound inputTag = input.func_77955_b(inputTagDummy);
        NBTTagCompound outputTag = out.func_77955_b(outputTagDummy);
        sendTag.func_74782_a("input", (NBTBase)inputTag);
        sendTag.func_74782_a("output", (NBTBase)outputTag);
        return sendTag;
    }

    @Override
    public void onPreInit() {
        super.onPreInit();
        Collection collection = Recipes.INSTANCE.getCrushers();
        FunctionReference functionReference = new Function2<ItemStack, ItemStack, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((MekanismModule)this.receiver).crusher(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MekanismModule.class);
            }

            public final String getName() {
                return "crusher";
            }

            public final String getSignature() {
                return "crusher(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z";
            }
        };
        collection.add(functionReference);
        collection = Recipes.INSTANCE.getBlastFurnaces();
        functionReference = new Function3<ItemStack, ItemStack, Integer, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2, int p3) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((MekanismModule)this.receiver).blastFurnace(p1, p2, p3);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MekanismModule.class);
            }

            public final String getName() {
                return "blastFurnace";
            }

            public final String getSignature() {
                return "blastFurnace(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;I)Z";
            }
        };
        collection.add(functionReference);
    }

    @Override
    public void onInit() {
        super.onInit();
        Ores[] oresArray = Ores.values();
        for (int i = 0; i < oresArray.length; ++i) {
            Ores ore = oresArray[i];
            ItemStack stack = BlockEnum.getItemStack$default((BlockEnum)WPBlocks.INSTANCE.getOre(), ore, 0, 2, null);
            this.enrichmentChamber(stack, WPItems.INSTANCE.getMaterial().getItemStack(ore.getMaterial(), MaterialForms.dust, 2));
        }
    }

    private MekanismModule() {
        INSTANCE = this;
    }

    static {
        new MekanismModule();
    }
}

