/*
 * Decompiled with CFR 0.152.
 */
package waterpower.integration.ic2;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.annotations.Integration;
import waterpower.common.block.ore.Ores;
import waterpower.common.init.WPItems;
import waterpower.common.item.ItemMaterial;
import waterpower.common.item.ItemOreDust;
import waterpower.common.item.MaterialForms;
import waterpower.common.recipe.Recipes;
import waterpower.integration.IModule;
import waterpower.integration.ic2.ICItemFinder;

@Integration(modID="ic2")
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J)\u0010\u0019\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001a\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lwaterpower/integration/ic2/IndustrialCraftModule;", "Lwaterpower/integration/IModule;", "()V", "RECIPE_AVAILABLE", "", "getRECIPE_AVAILABLE", "()Z", "blastFurnace", "input", "", "output", "Lnet/minecraft/item/ItemStack;", "time", "", "blockcutter", "compressor", "getCompressorMachineManager", "", "getCutterMachineManager", "getMaceratorMachineManager", "macerator", "metalformerRolling", "onPostInit", "", "onPreInit", "oreWashing", "", "(Lnet/minecraft/item/ItemStack;[Lnet/minecraft/item/ItemStack;)Z", "WaterPower_main"})
public final class IndustrialCraftModule
extends IModule {
    private static final boolean RECIPE_AVAILABLE = true;
    public static final IndustrialCraftModule INSTANCE;

    public final boolean getRECIPE_AVAILABLE() {
        return RECIPE_AVAILABLE;
    }

    @Optional.Method(modid="ic2")
    public final boolean compressor(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                return ic2.api.recipe.Recipes.compressor.addRecipe(ic2.api.recipe.Recipes.inputFactory.forStack(input), null, false, new ItemStack[]{output});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public final boolean blastFurnace(@NotNull ItemStack input, @NotNull ItemStack output, int time) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        return this.blastFurnace(input, output);
    }

    @Optional.Method(modid="ic2")
    public final boolean blastFurnace(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                return ic2.api.recipe.Recipes.blastfurnace.addRecipe(ic2.api.recipe.Recipes.inputFactory.forStack(input), null, false, new ItemStack[]{output});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public final boolean blastFurnace(@NotNull String input, @NotNull ItemStack output, int time) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                return ic2.api.recipe.Recipes.blastfurnace.addRecipe(ic2.api.recipe.Recipes.inputFactory.forOreDict(input), null, false, new ItemStack[]{output});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public final boolean macerator(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                return ic2.api.recipe.Recipes.macerator.addRecipe(ic2.api.recipe.Recipes.inputFactory.forStack(input), null, false, new ItemStack[]{output});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public final boolean metalformerRolling(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                return ic2.api.recipe.Recipes.metalformerRolling.addRecipe(ic2.api.recipe.Recipes.inputFactory.forStack(input), null, false, new ItemStack[]{output});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public final boolean blockcutter(@NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                return ic2.api.recipe.Recipes.blockcutter.addRecipe(ic2.api.recipe.Recipes.inputFactory.forStack(input), null, false, new ItemStack[]{output});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="ic2")
    public final boolean oreWashing(@NotNull ItemStack input, ItemStack ... output) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (RECIPE_AVAILABLE) {
            try {
                NBTTagCompound metadata = new NBTTagCompound();
                metadata.func_74768_a("amount", 1000);
                return ic2.api.recipe.Recipes.oreWashing.addRecipe(ic2.api.recipe.Recipes.inputFactory.forStack(input), metadata, false, Arrays.copyOf(output, output.length));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Nullable
    public final Object getMaceratorMachineManager() {
        try {
            return ic2.api.recipe.Recipes.macerator;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public final Object getCompressorMachineManager() {
        try {
            return ic2.api.recipe.Recipes.compressor;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    public final Object getCutterMachineManager() {
        try {
            return ic2.api.recipe.Recipes.blockcutter;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void onPreInit() {
        Collection collection = Recipes.INSTANCE.getBenders();
        FunctionReference functionReference = new Function2<ItemStack, ItemStack, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((IndustrialCraftModule)this.receiver).metalformerRolling(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IndustrialCraftModule.class);
            }

            public final String getName() {
                return "metalformerRolling";
            }

            public final String getSignature() {
                return "metalformerRolling(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z";
            }
        };
        collection.add(functionReference);
        collection = Recipes.INSTANCE.getBlastFurnaces();
        functionReference = new Function3<ItemStack, ItemStack, Integer, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2, int p3) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((IndustrialCraftModule)this.receiver).blastFurnace(p1, p2, p3);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IndustrialCraftModule.class);
            }

            public final String getName() {
                return "blastFurnace";
            }

            public final String getSignature() {
                return "blastFurnace(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;I)Z";
            }
        };
        collection.add(functionReference);
        collection = Recipes.INSTANCE.getBlastFurnacesOreDict();
        functionReference = new Function3<String, ItemStack, Integer, Boolean>(this){

            public final boolean invoke(@NotNull String p1, @NotNull ItemStack p2, int p3) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((IndustrialCraftModule)this.receiver).blastFurnace(p1, p2, p3);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IndustrialCraftModule.class);
            }

            public final String getName() {
                return "blastFurnace";
            }

            public final String getSignature() {
                return "blastFurnace(Ljava/lang/String;Lnet/minecraft/item/ItemStack;I)Z";
            }
        };
        collection.add(functionReference);
        collection = Recipes.INSTANCE.getCrushers();
        functionReference = new Function2<ItemStack, ItemStack, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((IndustrialCraftModule)this.receiver).macerator(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IndustrialCraftModule.class);
            }

            public final String getName() {
                return "macerator";
            }

            public final String getSignature() {
                return "macerator(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z";
            }
        };
        collection.add(functionReference);
        collection = Recipes.INSTANCE.getCompressors();
        functionReference = new Function2<ItemStack, ItemStack, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((IndustrialCraftModule)this.receiver).compressor(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IndustrialCraftModule.class);
            }

            public final String getName() {
                return "compressor";
            }

            public final String getSignature() {
                return "compressor(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z";
            }
        };
        collection.add(functionReference);
        collection = Recipes.INSTANCE.getCutters();
        functionReference = new Function2<ItemStack, ItemStack, Boolean>(this){

            public final boolean invoke(@NotNull ItemStack p1, @NotNull ItemStack p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return ((IndustrialCraftModule)this.receiver).blockcutter(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IndustrialCraftModule.class);
            }

            public final String getName() {
                return "blockcutter";
            }

            public final String getSignature() {
                return "blockcutter(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;)Z";
            }
        };
        collection.add(functionReference);
    }

    @Override
    public void onPostInit() {
        try {
            ItemStack item = ICItemFinder.INSTANCE.getItem("dust", "stone");
            ItemStack iron = ICItemFinder.INSTANCE.getItem("dust", "small_iron");
            if (item == null || iron == null) {
                return;
            }
            Ores[] oresArray = Ores.values();
            for (int i = 0; i < oresArray.length; ++i) {
                Ores o = oresArray[i];
                this.oreWashing(ItemOreDust.getItemStack$default(WPItems.INSTANCE.getCrushed(), o, 0, 2, null), ItemMaterial.getItemStack$default(WPItems.INSTANCE.getMaterial(), o.getMaterial(), MaterialForms.dust, 0, 4, null), iron, item);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private IndustrialCraftModule() {
        INSTANCE = this;
        RECIPE_AVAILABLE = true;
    }

    static {
        new IndustrialCraftModule();
    }
}

