/*
 * Decompiled with CFR 0.152.
 */
package waterpower.util;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.util.FluidContainerOutputMode;
import waterpower.util.FluidOperationResult;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\"\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010!H\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"registeredFluids", "", "Lnet/minecraftforge/fluids/Fluid;", "kotlin.jvm.PlatformType", "drainContainer", "Lwaterpower/util/FluidOperationResult;", "stack", "Lnet/minecraft/item/ItemStack;", "fluid", "maxAmount", "", "outputMode", "Lwaterpower/util/FluidContainerOutputMode;", "fillContainer", "fsIn", "Lnet/minecraftforge/fluids/FluidStack;", "isFillableFluidContainer", "", "testFluids", "", "isFluidContainer", "pushFluidAround", "", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "tank", "Lnet/minecraftforge/fluids/FluidTank;", "testFillFluid", "handler", "Lnet/minecraftforge/fluids/capability/IFluidHandlerItem;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "WaterPower_main"})
public final class FluidUtilKt {
    private static final Collection<Fluid> registeredFluids = FluidRegistry.getRegisteredFluids().values();

    public static final boolean isFluidContainer(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static final void pushFluidAround(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull FluidTank tank) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        FluidStack potential = tank.drain(tank.getFluidAmount(), false);
        int drained = 0;
        if (potential != null && potential.amount > 0) {
            FluidStack actuallyDrained;
            FluidStack working = potential.copy();
            EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
            for (int i = 0; i < enumFacingArray.length; ++i) {
                int used;
                IFluidHandler handler;
                EnumFacing side = enumFacingArray[i];
                if (potential.amount <= 0) break;
                TileEntity target = world.func_175625_s(pos.func_177972_a(side));
                if (target == null || (handler = (IFluidHandler)target.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) == null || (used = handler.fill(potential, true)) <= 0) continue;
                drained += used;
                potential.amount -= used;
            }
            if (drained > 0 && ((actuallyDrained = tank.drain(drained, true)) == null || actuallyDrained.amount != drained)) {
                throw (Throwable)new IllegalStateException("Bad tank! Could drain " + working + " but only drained " + actuallyDrained + "( tank " + tank.getClass() + ")");
            }
        }
    }

    public static final boolean isFillableFluidContainer(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return FluidUtilKt.isFillableFluidContainer(stack, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isFillableFluidContainer(@NotNull ItemStack stack, @Nullable Iterable<? extends Fluid> testFluids) {
        Fluid fluid;
        IFluidTankProperties[] var5;
        int var6;
        int n;
        int n2;
        ItemStack singleStack;
        IFluidHandlerItem handler;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!FluidUtilKt.isFluidContainer(stack)) {
            return false;
        }
        if (testFluids == null) {
            Collection<Fluid> collection = registeredFluids;
        }
        if ((handler = (IFluidHandlerItem)(singleStack = StackUtilKt.copyWithNewCount(stack, 1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) {
            return false;
        }
        FluidStack fs = handler.drain(Integer.MAX_VALUE, false);
        if (fs != null) {
            Fluid fluid2 = fs.getFluid();
            Intrinsics.checkExpressionValueIsNotNull((Object)fluid2, (String)"fs.fluid");
            if (FluidUtilKt.testFillFluid(handler, fluid2, fs.tag)) {
                return true;
            }
        }
        if ((n2 = 0) <= (n = (var6 = ((Object[])(var5 = handler.getTankProperties())).length) - 1)) {
            while (true) {
                void var7;
                IFluidTankProperties properties;
                if ((fs = (properties = var5[var7]).getContents()) != null) {
                    Fluid fluid3 = fs.getFluid();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fluid3, (String)"fs.fluid");
                    if (FluidUtilKt.testFillFluid(handler, fluid3, fs.tag)) {
                        return true;
                    }
                }
                if (var7 == n) break;
                ++var7;
            }
        }
        Iterator<Fluid> var10 = registeredFluids.iterator();
        do {
            if (!var10.hasNext()) {
                return false;
            }
            if (var10.next() != null) continue;
            throw new TypeCastException("null cannot be cast to non-null type net.minecraftforge.fluids.Fluid");
        } while (!FluidUtilKt.testFillFluid(handler, fluid, null));
        return true;
    }

    private static final boolean testFillFluid(IFluidHandlerItem handler, Fluid fluid, NBTTagCompound nbt) {
        FluidStack fs = new FluidStack(fluid, Integer.MAX_VALUE);
        fs.tag = nbt;
        return handler.fill(fs, false) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final FluidOperationResult drainContainer(@NotNull ItemStack stack, @Nullable Fluid fluid, int maxAmount, @NotNull FluidContainerOutputMode outputMode) {
        FluidStack fs;
        IFluidHandlerItem handler;
        ItemStack extra;
        ItemStack inPlace;
        block7: {
            block8: {
                boolean isEmpty;
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                Intrinsics.checkParameterIsNotNull((Object)((Object)outputMode), (String)"outputMode");
                if (StackUtilKt.isStackEmpty(stack)) return null;
                if (maxAmount <= 0) return null;
                inPlace = stack.func_77946_l();
                extra = StackUtilKt.getEmptyStack();
                if (!inPlace.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                    return null;
                }
                ItemStack singleStack = StackUtilKt.copyWithNewCount(inPlace, 1);
                handler = (IFluidHandlerItem)singleStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (handler == null) {
                    return null;
                }
                fs = fluid == null ? handler.drain(maxAmount, true) : handler.drain(new FluidStack(fluid, maxAmount), true);
                if (fs == null) return null;
                if (fs.amount <= 0) return null;
                if (StackUtilKt.isStackEmpty(singleStack)) {
                    ItemStack itemStack = inPlace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inPlace");
                    inPlace = StackUtilKt.shrink$default(itemStack, 0, 2, null);
                    return new FluidOperationResult(fs, inPlace, extra);
                }
                FluidStack leftOver = handler.drain(Integer.MAX_VALUE, false);
                boolean bl = isEmpty = leftOver == null || leftOver.amount <= 0;
                if (isEmpty && outputMode.isOutputEmptyFull() || !(Intrinsics.areEqual((Object)((Object)outputMode), (Object)((Object)FluidContainerOutputMode.AnyToOutput)) ^ true)) break block7;
                if (Intrinsics.areEqual((Object)((Object)outputMode), (Object)((Object)FluidContainerOutputMode.InPlacePreferred)) ^ true) break block8;
                ItemStack itemStack = inPlace;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inPlace");
                if (StackUtilKt.getCount(itemStack) > 1) break block7;
            }
            ItemStack itemStack = inPlace;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inPlace");
            if (StackUtilKt.getCount(itemStack) > 1) {
                return null;
            }
            inPlace = handler.getContainer();
            return new FluidOperationResult(fs, inPlace, extra);
        }
        ItemStack itemStack = handler.getContainer();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"handler.container");
        extra = itemStack;
        ItemStack itemStack2 = inPlace;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"inPlace");
        inPlace = StackUtilKt.shrink$default(itemStack2, 0, 2, null);
        return new FluidOperationResult(fs, inPlace, extra);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final FluidOperationResult fillContainer(@NotNull ItemStack stack, @Nullable FluidStack fsIn, @NotNull FluidContainerOutputMode outputMode) {
        block6: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                Intrinsics.checkParameterIsNotNull((Object)outputMode, (String)"outputMode");
                if (StackUtilKt.isStackEmpty(stack) || fsIn == null || fsIn.amount <= 0) break block6;
                inPlace = stack.func_77946_l();
                extra = StackUtilKt.getEmptyStack();
                if (!inPlace.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) break block7;
                singleStack = StackUtilKt.copyWithNewCount(inPlace, 1);
                handler = (IFluidHandlerItem)singleStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (handler == null) {
                    return null;
                }
                fsChange = fsIn.copy();
                amount = handler.fill(fsChange, true);
                if (amount <= 0) {
                    return null;
                }
                fsChange.amount = amount;
                fillTestFs = fsIn.copy();
                fillTestFs.amount = 0x7FFFFFFF;
                isFull = handler.fill(fillTestFs, false) <= 0;
                v0 = handler.getContainer();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"handler.container");
                singleStack = v0;
                if (isFull && outputMode.isOutputEmptyFull() || Intrinsics.areEqual((Object)outputMode, (Object)FluidContainerOutputMode.AnyToOutput)) ** GOTO lbl-1000
                if (Intrinsics.areEqual((Object)outputMode, (Object)FluidContainerOutputMode.InPlacePreferred)) {
                    v1 = inPlace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"inPlace");
                    ** if (StackUtilKt.getCount((ItemStack)v1) <= 1) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    extra = singleStack;
                    v2 = inPlace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"inPlace");
                    inPlace = StackUtilKt.shrink$default(v2, 0, 2, null);
                    ** GOTO lbl38
                }
lbl-1000:
                // 2 sources

                {
                    v3 = inPlace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"inPlace");
                    if (StackUtilKt.getCount(v3) > 1) {
                        return null;
                    }
                    inPlace = singleStack;
                }
lbl38:
                // 2 sources

                v4 = fsChange;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"fsChange");
                return new FluidOperationResult(v4, inPlace, extra);
            }
            return null;
        }
        return null;
    }
}

