/*
 * Decompiled with CFR 0.152.
 */
package waterpower.util;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u001a\u001f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0001\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u000b\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a'\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u000b\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000b\u001a\u0012\u0010\u001b\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u000b\u001a*\u0010\u001d\u001a\u00020\u001e*\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010%\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000b\u001a\u001e\u0010&\u001a\u00020\u0001*\u00020\u00012\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"emptyStack", "Lnet/minecraft/item/ItemStack;", "getEmptyStack", "()Lnet/minecraft/item/ItemStack;", "rand", "Ljava/util/Random;", "getCopiedStacks", "", "stack", "([Lnet/minecraft/item/ItemStack;)[Lnet/minecraft/item/ItemStack;", "getCount", "", "grow", "count", "isStackEmpty", "", "isStackEqual", "a", "b", "isStacksEqual", "stacks1", "stacks2", "([Lnet/minecraft/item/ItemStack;[Lnet/minecraft/item/ItemStack;)Z", "shrink", "consume", "copyWithNewCount", "newCount", "damage", "amount", "dropAsEntity", "", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "generalize", "set", "withNBT", "map", "", "", "", "WaterPower_main"})
public final class StackUtilKt {
    @NotNull
    private static final ItemStack emptyStack;
    private static final Random rand;

    @NotNull
    public static final ItemStack getEmptyStack() {
        return emptyStack;
    }

    @NotNull
    public static final ItemStack generalize(@NotNull ItemStack $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new ItemStack($receiver.func_77973_b(), StackUtilKt.getCount($receiver), Short.MAX_VALUE);
    }

    public static final boolean isStackEmpty(@Nullable ItemStack stack) {
        return stack == null || StackUtilKt.getCount(stack) <= 0 || stack.func_77973_b() == null || stack.func_190926_b();
    }

    @NotNull
    public static final ItemStack set(@NotNull ItemStack $receiver, int newCount) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.func_190920_e(newCount);
        return $receiver;
    }

    @NotNull
    public static final ItemStack withNBT(@NotNull ItemStack $receiver, @NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        if ($receiver.func_77978_p() == null) {
            $receiver.func_77982_d(new NBTTagCompound());
        }
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            Object object = entry;
            String key = object.getKey();
            object = entry;
            Object value = object.getValue();
            if ((object = value) instanceof Integer) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74768_a(key, ((Number)value).intValue());
                }
                continue;
            }
            if (object instanceof Boolean) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74757_a(key, ((Boolean)value).booleanValue());
                }
                continue;
            }
            if (object instanceof Double) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74780_a(key, ((Number)value).doubleValue());
                }
                continue;
            }
            if (object instanceof Float) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74776_a(key, ((Number)value).floatValue());
                }
                continue;
            }
            if (object instanceof Byte) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74774_a(key, ((Number)value).byteValue());
                }
                continue;
            }
            if (object instanceof Long) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74772_a(key, ((Number)value).longValue());
                }
                continue;
            }
            if (object instanceof Short) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74777_a(key, ((Number)value).shortValue());
                }
                continue;
            }
            if (object instanceof String) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74778_a(key, (String)value);
                }
                continue;
            }
            if (object instanceof NBTBase) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74782_a(key, (NBTBase)value);
                }
                continue;
            }
            if (object instanceof byte[]) {
                NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
                if (nBTTagCompound != null) {
                    nBTTagCompound.func_74773_a(key, (byte[])value);
                }
                continue;
            }
            if (!(object instanceof int[])) continue;
            NBTTagCompound nBTTagCompound = $receiver.func_77978_p();
            if (nBTTagCompound == null) continue;
            nBTTagCompound.func_74783_a(key, (int[])value);
        }
        return $receiver;
    }

    @NotNull
    public static final ItemStack shrink(@NotNull ItemStack stack, int count) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        stack.func_190918_g(count);
        if (StackUtilKt.isStackEmpty(stack)) {
            return emptyStack;
        }
        return stack;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ItemStack shrink$default(ItemStack itemStack, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return StackUtilKt.shrink(itemStack, n);
    }

    @NotNull
    public static final ItemStack grow(@NotNull ItemStack stack, int count) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return StackUtilKt.shrink(stack, -count);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ItemStack grow$default(ItemStack itemStack, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return StackUtilKt.grow(itemStack, n);
    }

    public static final int getCount(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack.func_190916_E();
    }

    public static final void dropAsEntity(@NotNull ItemStack $receiver, @NotNull World world, int x, int y, int z) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, $receiver.func_77946_l());
        world.func_72838_d((Entity)entityItem);
    }

    @NotNull
    public static final ItemStack copyWithNewCount(@NotNull ItemStack $receiver, int newCount) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StackUtilKt.set($receiver.func_77946_l(), newCount);
    }

    public static final boolean damage(@NotNull ItemStack $receiver, int amount) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.func_96631_a(amount, rand, null)) {
            $receiver.func_190918_g(1);
            $receiver.func_77964_b(0);
            return $receiver.func_190926_b();
        }
        return false;
    }

    @NotNull
    public static final ItemStack consume(@NotNull ItemStack $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (StackUtilKt.getCount($receiver) == 1) {
            if ($receiver.func_77973_b().hasContainerItem($receiver)) {
                ItemStack itemStack = $receiver.func_77973_b().getContainerItem($receiver);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"item.getContainerItem(this)");
                return itemStack;
            }
            return emptyStack;
        }
        $receiver.func_77979_a(1);
        return $receiver;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ItemStack[] getCopiedStacks(@NotNull ItemStack[] stack) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        int size$iv = ((Object[])stack).length;
        ItemStack[] result$iv = new ItemStack[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                ItemStack itemStack;
                void it;
                void var5_5 = ++i$iv;
                void var9_7 = i$iv;
                ItemStack[] itemStackArray = result$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)stack[it].func_77946_l(), (String)"stack[it].copy()");
                itemStackArray[var9_7] = itemStack;
            } while (i$iv != n2);
        }
        return var2_2;
    }

    public static final boolean isStackEqual(@NotNull ItemStack a, @NotNull ItemStack b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        return StackUtilKt.isStackEmpty(a) && StackUtilKt.isStackEmpty(b) || !StackUtilKt.isStackEmpty(a) && !StackUtilKt.isStackEmpty(b) && a.func_77969_a(b) && Objects.equals(a.func_77978_p(), b.func_77978_p());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isStacksEqual(@NotNull ItemStack[] stacks1, @NotNull ItemStack[] stacks2) {
        Intrinsics.checkParameterIsNotNull((Object)stacks1, (String)"stacks1");
        Intrinsics.checkParameterIsNotNull((Object)stacks2, (String)"stacks2");
        if (((Object[])stacks1).length != ((Object[])stacks2).length) {
            return false;
        }
        int n = 0;
        int n2 = stacks1.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (!StackUtilKt.isStackEqual(stacks1[i], stacks2[i])) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    static {
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        emptyStack = itemStack;
        rand = new Random();
    }
}

