/*
 * Decompiled with CFR 0.152.
 */
package waterpower.util;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import waterpower.WaterPower;
import waterpower.util.StackUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012\u001a,\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u001a\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0010\u001a\n\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u0007\u001a\u0006\u0010 \u001a\u00020!\u001a\u0016\u0010\"\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0006\u0010#\u001a\u00020!\u001a\u0016\u0010$\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010%\u001a\n '*\u0004\u0018\u00010&0&*\u00020(2\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010)\u001a\u0004\u0018\u00010**\u00020+2\u0006\u0010,\u001a\u00020\u0010\u001a\u001c\u0010-\u001a\u00020\u0005*\u00020+2\u0006\u0010,\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010*\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006/"}, d2={"DEFAULT_DECIMAL_FORMAT", "Ljava/text/DecimalFormat;", "getDEFAULT_DECIMAL_FORMAT", "()Ljava/text/DecimalFormat;", "dropItems", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "drops", "", "Lnet/minecraft/item/ItemStack;", "getBlock", "Lnet/minecraft/block/Block;", "name", "", "loc", "Lnet/minecraft/util/ResourceLocation;", "getItem", "Lnet/minecraft/item/Item;", "getItemStack", "modName", "itemName", "meta", "", "amount", "getWaterIncomeAndExpenseByBiome", "Lkotlin/Pair;", "", "biomeID", "getWorld", "isClientSide", "", "isLava", "isServerSide", "isWater", "getActualBlockState", "Lnet/minecraft/block/state/IBlockState;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/IBlockAccess;", "getUUID", "Ljava/util/UUID;", "Lnet/minecraft/nbt/NBTTagCompound;", "id", "setUUID", "uuid", "WaterPower_main"})
public final class UtilsKt {
    @NotNull
    private static final DecimalFormat DEFAULT_DECIMAL_FORMAT = new DecimalFormat("#.00");

    public static final boolean isServerSide() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static final boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static final IBlockState getActualBlockState(@NotNull IBlockAccess $receiver, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return $receiver.func_180495_p(pos).func_185899_b($receiver, pos);
    }

    @Nullable
    public static final Item getItem(@NotNull ResourceLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        return (Item)Item.field_150901_e.func_82594_a((Object)loc);
    }

    @Nullable
    public static final Item getItem(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return UtilsKt.getItem(new ResourceLocation(name));
    }

    @Nullable
    public static final Block getBlock(@NotNull ResourceLocation loc) {
        Intrinsics.checkParameterIsNotNull((Object)loc, (String)"loc");
        return (Block)Block.field_149771_c.func_82594_a((Object)loc);
    }

    @Nullable
    public static final Block getBlock(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return UtilsKt.getBlock(new ResourceLocation(name));
    }

    @Nullable
    public static final ItemStack getItemStack(@NotNull String modName, @NotNull String itemName, int meta, int amount) {
        Intrinsics.checkParameterIsNotNull((Object)modName, (String)"modName");
        Intrinsics.checkParameterIsNotNull((Object)itemName, (String)"itemName");
        Item item = UtilsKt.getItem(new ResourceLocation(modName, itemName));
        if (item == null) {
            return null;
        }
        return new ItemStack(item, amount, meta);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ItemStack getItemStack$default(String string, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        return UtilsKt.getItemStack(string, string2, n, n2);
    }

    public static final boolean isWater(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Block block = world.func_180495_p(pos).func_177230_c();
        return Intrinsics.areEqual((Object)block, (Object)Blocks.field_150355_j) || Intrinsics.areEqual((Object)block, (Object)Blocks.field_150358_i);
    }

    public static final boolean isLava(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Block block = world.func_180495_p(pos).func_177230_c();
        return Intrinsics.areEqual((Object)block, (Object)Blocks.field_150353_l) || Intrinsics.areEqual((Object)block, (Object)Blocks.field_150356_k);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static final World getWorld() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null) {
            return (World)mc.field_71441_e;
        }
        return null;
    }

    public static final void setUUID(@NotNull NBTTagCompound $receiver, @NotNull String id, @Nullable UUID uuid) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        if (uuid == null) {
            return;
        }
        $receiver.func_74772_a(id + "_most", uuid.getMostSignificantBits());
        $receiver.func_74772_a(id + "_least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static final UUID getUUID(@NotNull NBTTagCompound $receiver, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        if ($receiver.func_74764_b(id + "_most") && $receiver.func_74764_b(id + "_least")) {
            return new UUID($receiver.func_74763_f(id + "_most"), $receiver.func_74763_f(id + "_least"));
        }
        return null;
    }

    public static final void dropItems(@NotNull World world, @NotNull BlockPos pos, @NotNull List<ItemStack> drops) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull(drops, (String)"drops");
        if (UtilsKt.isServerSide()) {
            for (ItemStack item : drops) {
                if (StackUtilKt.isStackEmpty(item)) continue;
                float rx = WaterPower.INSTANCE.getRandom().nextFloat() * 0.8f + 0.1f;
                float ry = WaterPower.INSTANCE.getRandom().nextFloat() * 0.8f + 0.1f;
                float rz = WaterPower.INSTANCE.getRandom().nextFloat() * 0.8f + 0.1f;
                EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
                float factor = 0.05f;
                entityItem.field_70159_w = WaterPower.INSTANCE.getRandom().nextGaussian() * (double)factor;
                entityItem.field_70181_x = WaterPower.INSTANCE.getRandom().nextGaussian() * (double)factor + 0.2;
                entityItem.field_70179_y = WaterPower.INSTANCE.getRandom().nextGaussian() * (double)factor;
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    @NotNull
    public static final Pair<Integer, Double> getWaterIncomeAndExpenseByBiome(@NotNull World world, @NotNull String biomeID2) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)biomeID2, (String)"biomeID");
        int weather = world.func_72911_I() ? 2 : (world.func_72896_J() ? 1 : 0);
        double acquirement = 0.0;
        Map map2 = map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"beach", (Object)1.0), TuplesKt.to((Object)"river", (Object)1.0), TuplesKt.to((Object)"taiga", (Object)1.0), TuplesKt.to((Object)"forest", (Object)1.0), TuplesKt.to((Object)"plains", (Object)0.75), TuplesKt.to((Object)"extreme", (Object)0.75), TuplesKt.to((Object)"mushroom", (Object)1.2), TuplesKt.to((Object)"ocean", (Object)1.2), TuplesKt.to((Object)"desert", (Object)0.0), TuplesKt.to((Object)"hell", (Object)0.0), TuplesKt.to((Object)"frozen", (Object)1.2), TuplesKt.to((Object)"ice", (Object)1.0), TuplesKt.to((Object)"jungle", (Object)1.5), TuplesKt.to((Object)"swapland", (Object)1.2)});
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            String key = (String)entry2.getKey();
            entry2 = entry;
            double value = ((Number)entry2.getValue()).doubleValue();
            if (!StringsKt.contains$default((CharSequence)biomeID2, (CharSequence)key, (boolean)false, (int)2, null)) continue;
            acquirement = value;
            break;
        }
        return TuplesKt.to((Object)weather, (Object)acquirement);
    }

    @NotNull
    public static final DecimalFormat getDEFAULT_DECIMAL_FORMAT() {
        return DEFAULT_DECIMAL_FORMAT;
    }
}

