/*
 * Decompiled with CFR 0.152.
 */
package com.rowan662.endores.world;

import com.google.common.base.Predicate;
import com.rowan662.endores.blocks.EndOresBlocks;
import com.rowan662.endores.main.EndOresMain;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenEO
implements IWorldGenerator {
    private WorldGenerator coal_ore = new WorldGenMinable(EndOresBlocks.ore_coal.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator iron_ore = new WorldGenMinable(EndOresBlocks.ore_iron.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator gold_ore = new WorldGenMinable(EndOresBlocks.ore_gold.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator lapis_ore = new WorldGenMinable(EndOresBlocks.ore_lapis.func_176223_P(), 9, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator redstone_ore = new WorldGenMinable(EndOresBlocks.ore_redstone.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator diamond_ore = new WorldGenMinable(EndOresBlocks.ore_diamond.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator emerald_ore = new WorldGenMinable(EndOresBlocks.ore_emerald.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator nether_coal_ore = new WorldGenMinable(EndOresBlocks.nether_ore_coal.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator nether_iron_ore = new WorldGenMinable(EndOresBlocks.nether_ore_iron.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator nether_gold_ore = new WorldGenMinable(EndOresBlocks.nether_ore_gold.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator nether_lapis_ore = new WorldGenMinable(EndOresBlocks.nether_ore_lapis.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator nether_redstone_ore = new WorldGenMinable(EndOresBlocks.nether_ore_redstone.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator nether_diamond_ore = new WorldGenMinable(EndOresBlocks.nether_ore_diamond.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator nether_emerald_ore = new WorldGenMinable(EndOresBlocks.nether_ore_emerald.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                break;
            }
            case 1: {
                if (!EndOresMain.generateNetherOre) break;
                this.runGenerator(this.coal_ore, world, random, chunkX, chunkZ, 50, 0, 140);
                this.runGenerator(this.iron_ore, world, random, chunkX, chunkZ, 40, 0, 140);
                this.runGenerator(this.gold_ore, world, random, chunkX, chunkZ, 30, 0, 140);
                this.runGenerator(this.lapis_ore, world, random, chunkX, chunkZ, 20, 0, 140);
                this.runGenerator(this.redstone_ore, world, random, chunkX, chunkZ, 20, 0, 140);
                this.runGenerator(this.diamond_ore, world, random, chunkX, chunkZ, 12, 0, 140);
                this.runGenerator(this.emerald_ore, world, random, chunkX, chunkZ, 12, 0, 140);
                break;
            }
            case -1: {
                if (!EndOresMain.generateEndOre) break;
                this.runGenerator(this.nether_coal_ore, world, random, chunkX, chunkZ, 20, 0, 256);
                this.runGenerator(this.nether_iron_ore, world, random, chunkX, chunkZ, 15, 0, 256);
                this.runGenerator(this.nether_gold_ore, world, random, chunkX, chunkZ, 10, 0, 256);
                this.runGenerator(this.nether_lapis_ore, world, random, chunkX, chunkZ, 6, 0, 256);
                this.runGenerator(this.nether_redstone_ore, world, random, chunkX, chunkZ, 6, 0, 256);
                this.runGenerator(this.nether_diamond_ore, world, random, chunkX, chunkZ, 4, 0, 256);
                this.runGenerator(this.nether_emerald_ore, world, random, chunkX, chunkZ, 3, 0, 256);
            }
        }
    }

    private void runGenerator(WorldGenerator gen, World world, Random rand, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > 256) {
            throw new IllegalArgumentException("Ore generated out of bounds");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

