/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import crafttweaker.CraftTweakerAPI;
import gregtech.api.GTValues;
import gregtech.api.capability.SimpleCapabilityManager;
import gregtech.api.cover.CoverBehaviorUIFactory;
import gregtech.api.items.gui.PlayerInventoryUIFactory;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.model.ResourcePackHook;
import gregtech.api.net.NetworkHandler;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.AnnotatedMaterialHandlerLoader;
import gregtech.api.util.GTLog;
import gregtech.api.util.NBTUtil;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.common.CommonProxy;
import gregtech.common.ConfigHolder;
import gregtech.common.MetaEntities;
import gregtech.common.MetaFluids;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.modelfactories.BlockCompressedFactory;
import gregtech.common.blocks.modelfactories.BlockFrameFactory;
import gregtech.common.blocks.modelfactories.BlockOreFactory;
import gregtech.common.command.GregTechCommand;
import gregtech.common.covers.CoverBehaviors;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.worldgen.LootTableHelper;
import gregtech.common.worldgen.WorldGenAbandonedBase;
import gregtech.common.worldgen.WorldGenRubberTree;
import gregtech.integration.multipart.GTMultipartFactory;
import gregtech.integration.theoneprobe.TheOneProbeCompatibility;
import gregtech.loaders.dungeon.DungeonLootLoader;
import net.minecraft.command.ICommand;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="gregtech", name="GregTech Community Edition", acceptedMinecraftVersions="[1.12,1.13)", dependencies="required:forge@[14.23.5.2838,);required-after:codechickenlib@[3.2.2,);after:forestry;after:forgemultipartcbe;after:jei@[4.8.6,);after:crafttweaker;")
public class GregTechMod {
    @Mod.Instance(value="gregtech")
    public static GregTechMod instance;
    @SidedProxy(modId="gregtech", clientSide="gregtech.common.ClientProxy", serverSide="gregtech.common.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        GTLog.init(event.getModLog());
        NetworkHandler.init();
        MetaTileEntityUIFactory.INSTANCE.init();
        PlayerInventoryUIFactory.INSTANCE.init();
        CoverBehaviorUIFactory.INSTANCE.init();
        SimpleCapabilityManager.init();
        OreDictUnifier.init();
        NBTUtil.registerSerializers();
        Materials.register();
        AnnotatedMaterialHandlerLoader.discoverAndLoadAnnotatedMaterialHandlers(event.getAsmData());
        Material.runMaterialHandlers();
        if (GTValues.isModLoaded("crafttweaker")) {
            GTLog.logger.info("Running early CraftTweaker initialization scripts...");
            this.runEarlyCraftTweakerScripts();
        }
        Material.freezeRegistry();
        MetaBlocks.init();
        MetaItems.init();
        MetaFluids.init();
        MetaTileEntities.init();
        MetaEntities.init();
        proxy.onPreLoad();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.onLoad();
        if (RecipeMap.isFoundInvalidRecipe()) {
            GTLog.logger.fatal("Seems like invalid recipe was found.");
            if (!ConfigHolder.ignoreErrorOrInvalidRecipes || !FMLForgePlugin.RUNTIME_DEOBF) {
                GTLog.logger.fatal("Loading cannot continue. Either fix or report invalid recipes, or enable ignoreErrorOrInvalidRecipes in the config as a temporary solution");
                throw new LoaderException("Found at least one invalid recipe. Please read the log above for more details.");
            }
            GTLog.logger.fatal("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            GTLog.logger.fatal("Ignoring invalid recipes and continuing loading");
            GTLog.logger.fatal("Some things may lack recipes or have invalid ones, proceed at your own risk");
            GTLog.logger.fatal("Report to GTCE github to get more help and fix the problem");
            GTLog.logger.fatal("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        if (GTValues.isModLoaded("forgemultipartcbe")) {
            GTLog.logger.info("ForgeMultiPart found. Legacy block conversion enabled.");
            this.registerForgeMultipartCompat();
        }
        if (GTValues.isModLoaded("theoneprobe")) {
            GTLog.logger.info("TheOneProbe found. Enabling integration...");
            TheOneProbeCompatibility.registerCompatibility();
        }
        WorldGenRegistry.INSTANCE.initializeRegistry();
        if (!ConfigHolder.disableRubberTreeGeneration) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenRubberTree(), (int)10000);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenAbandonedBase(), (int)20000);
        }
        LootTableHelper.initialize();
        FilterTypeRegistry.init();
        CoverBehaviors.init();
        DungeonLootLoader.init();
    }

    @Optional.Method(modid="forgemultipartcbe")
    private void registerForgeMultipartCompat() {
        GTMultipartFactory.INSTANCE.registerFactory();
    }

    @Optional.Method(modid="crafttweaker")
    private void runEarlyCraftTweakerScripts() {
        CraftTweakerAPI.tweaker.loadScript(false, "gregtech");
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        proxy.onPostLoad();
    }

    @Mod.EventHandler
    public void onServerLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new GregTechCommand());
    }

    static {
        FluidRegistry.enableUniversalBucket();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            ResourcePackHook.init();
            BlockOreFactory.init();
            BlockCompressedFactory.init();
            BlockFrameFactory.init();
        }
    }
}

