/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block.machines;

import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineItemBlock
extends ItemBlock {
    public MachineItemBlock(BlockMachine block) {
        super((Block)block);
        this.func_77627_a(true);
    }

    public static MetaTileEntity getMetaTileEntity(ItemStack itemStack) {
        return GregTechAPI.META_TILE_ENTITY_REGISTRY.getObjectById(itemStack.func_77952_i());
    }

    public String func_77667_c(ItemStack stack) {
        MetaTileEntity metaTileEntity = MachineItemBlock.getMetaTileEntity(stack);
        return metaTileEntity == null ? "unnamed" : metaTileEntity.getMetaName();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        MetaTileEntity metaTileEntity = MachineItemBlock.getMetaTileEntity(stack);
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState.func_177226_a((IProperty)BlockMachine.OPAQUE, (Comparable)Boolean.valueOf(metaTileEntity != null && metaTileEntity.isOpaqueCube())));
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        MetaTileEntity metaTileEntity = MachineItemBlock.getMetaTileEntity(itemStack);
        if (metaTileEntity == null) {
            return "gregtech";
        }
        ResourceLocation metaTileEntityId = metaTileEntity.metaTileEntityId;
        return metaTileEntityId.func_110624_b();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        MetaTileEntity metaTileEntity = MachineItemBlock.getMetaTileEntity(stack);
        return metaTileEntity == null ? null : metaTileEntity.initItemStackCapabilities(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String tierlessTooltipLocale;
        MetaTileEntity metaTileEntity = MachineItemBlock.getMetaTileEntity(stack);
        if (metaTileEntity == null) {
            return;
        }
        String tooltipLocale = metaTileEntity.getMetaName() + ".tooltip";
        if (I18n.func_188566_a((String)tooltipLocale)) {
            String[] lines = I18n.func_135052_a((String)tooltipLocale, (Object[])new Object[0]).split("/n");
            tooltip.addAll(Arrays.asList(lines));
        }
        if (metaTileEntity instanceof ITieredMetaTileEntity && !tooltipLocale.equals(tierlessTooltipLocale = ((ITieredMetaTileEntity)((Object)metaTileEntity)).getTierlessTooltipKey()) && I18n.func_188566_a((String)tierlessTooltipLocale)) {
            String[] lines = I18n.func_135052_a((String)tierlessTooltipLocale, (Object[])new Object[0]).split("/n");
            tooltip.addAll(Arrays.asList(lines));
        }
        metaTileEntity.addInformation(stack, worldIn, tooltip, flagIn.func_194127_a());
        if (flagIn.func_194127_a()) {
            tooltip.add(String.format("MetaTileEntity Id: %s", metaTileEntity.metaTileEntityId.toString()));
        }
    }
}

