/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerProxy
implements IFluidHandler {
    public final IFluidHandler input;
    public final IFluidHandler output;
    private IFluidTankProperties[] properties;

    public FluidHandlerProxy(IFluidHandler input, IFluidHandler output) {
        this.input = input;
        this.output = output;
        ArrayList tanks = Lists.newArrayList();
        Collections.addAll(tanks, input.getTankProperties());
        Collections.addAll(tanks, output.getTankProperties());
        this.properties = tanks.toArray(new IFluidTankProperties[0]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.input.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.output.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.output.drain(maxDrain, doDrain);
    }
}

