/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enchants;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentEnderDamage
extends Enchantment {
    public static final EnchantmentEnderDamage INSTANCE = new EnchantmentEnderDamage();

    private EnchantmentEnderDamage() {
        super(Enchantment.Rarity.UNCOMMON, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
    }

    public void register(RegistryEvent.Register<Enchantment> event) {
        this.setRegistryName(new ResourceLocation("gregtech", "disjunction"));
        this.func_77322_b("disjunction");
        event.getRegistry().register((IForgeRegistryEntry)this);
    }

    public int func_77321_a(int level) {
        return 5 + (level - 1) * 8;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    public int func_77325_b() {
        return 5;
    }

    public void func_151368_a(EntityLivingBase hurtEntity, Entity damagingEntity, int level) {
        String entityName = EntityList.func_75621_b((Entity)hurtEntity);
        if (hurtEntity instanceof EntityEnderman || hurtEntity instanceof EntityDragon || entityName != null && entityName.toLowerCase().contains("ender")) {
            hurtEntity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, level * 200, Math.max(1, 5 * level / 7)));
            hurtEntity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, level * 200, Math.max(1, 5 * level / 7)));
        }
    }
}

