/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import com.google.common.base.Preconditions;
import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ISizeProvider;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Widget {
    protected ModularUI gui;
    protected ISizeProvider sizes;
    protected WidgetUIAccess uiAccess;
    private Position parentPosition = Position.ORIGIN;
    private Position selfPosition;
    private Position position;
    private Size size;

    public Widget(Position selfPosition, Size size) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.selfPosition = selfPosition;
        this.size = size;
        this.position = this.parentPosition.add(selfPosition);
    }

    public void setGui(ModularUI gui) {
        this.gui = gui;
    }

    public void setSizes(ISizeProvider sizes) {
        this.sizes = sizes;
    }

    public void setUiAccess(WidgetUIAccess uiAccess) {
        this.uiAccess = uiAccess;
    }

    public void setParentPosition(Position parentPosition) {
        Preconditions.checkNotNull((Object)parentPosition, (Object)"parentPosition");
        this.parentPosition = parentPosition;
        this.recomputePosition();
    }

    protected void setSelfPosition(Position selfPosition) {
        Preconditions.checkNotNull((Object)selfPosition, (Object)"selfPosition");
        this.selfPosition = selfPosition;
        this.recomputePosition();
    }

    protected void setSize(Size size) {
        Preconditions.checkNotNull((Object)size, (Object)"size");
        this.size = size;
        this.onSizeUpdate();
    }

    public final Position getPosition() {
        return this.position;
    }

    public final Size getSize() {
        return this.size;
    }

    public Rectangle toRectangleBox() {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return new Rectangle(pos.x, pos.y, pos.x + size.width, pos.y + size.height);
    }

    private void recomputePosition() {
        this.position = this.parentPosition.add(this.selfPosition);
        this.onPositionUpdate();
    }

    protected void onPositionUpdate() {
    }

    protected void onSizeUpdate() {
    }

    protected boolean isMouseOverElement(int mouseX, int mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return Widget.isMouseOver(position.x, position.y, size.width, size.height, mouseX, mouseY);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && x + width >= mouseX && y + height >= mouseY;
    }

    public void initWidget() {
    }

    public void detectAndSendChanges() {
    }

    public void updateScreen() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean keyTyped(char charTyped, int keyCode) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
    }

    public void handleClientAction(int id, PacketBuffer buffer) {
    }

    public List<INativeWidget> getNativeWidgets() {
        if (this instanceof INativeWidget) {
            return Collections.singletonList((INativeWidget)((Object)this));
        }
        return Collections.emptyList();
    }

    protected final void writeUpdateInfo(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null && this.gui != null) {
            this.uiAccess.writeUpdateInfo(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected final void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
        if (this.uiAccess != null) {
            this.uiAccess.writeClientAction(this, id, packetBufferWriter);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawHoveringText(ItemStack itemStack, List<String> tooltip, int maxTextWidth, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText((ItemStack)itemStack, tooltip, (int)mouseX, (int)mouseY, (int)(this.sizes.getScreenWidth() - this.sizes.getGuiLeft()), (int)(this.sizes.getScreenHeight() - this.sizes.getGuiTop()), (int)maxTextWidth, (FontRenderer)mc.field_71466_p);
    }

    public static void drawSolidRect(int x, int y, int width, int height, int color) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }

    public static void drawGradientRect(int x, int y, int width, int height, int startColor, int endColor) {
        GuiUtils.drawGradientRect((int)0, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)startColor, (int)endColor);
        GlStateManager.func_179147_l();
    }

    @SideOnly(value=Side.CLIENT)
    protected void playButtonClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected static boolean isClientSide() {
        return FMLCommonHandler.instance().getSide().isClient();
    }
}

