/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.igredient.IGhostIngredientTarget;
import gregtech.api.gui.igredient.IIngredientSlot;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.network.PacketBuffer;

public class AbstractWidgetGroup
extends Widget
implements IGhostIngredientTarget,
IIngredientSlot {
    protected final List<Widget> widgets = new ArrayList<Widget>();
    private WidgetGroupUIAccess groupUIAccess = new WidgetGroupUIAccess();
    private boolean isVisible = true;
    private boolean isDynamicSized;

    public AbstractWidgetGroup(Position position) {
        super(position, Size.ZERO);
        this.isDynamicSized = true;
    }

    public AbstractWidgetGroup(Position position, Size size) {
        super(position, size);
        this.isDynamicSized = false;
    }

    @Override
    protected void onPositionUpdate() {
        Position selfPosition = this.getPosition();
        for (Widget widget : this.widgets) {
            widget.setParentPosition(selfPosition);
        }
        this.recomputeSize();
    }

    protected boolean recomputeSize() {
        Size dynamicSize;
        Size currentSize;
        if (this.isDynamicSized && !(currentSize = this.getSize()).equals(dynamicSize = this.computeDynamicSize())) {
            this.setSize(dynamicSize);
            if (this.uiAccess != null) {
                this.uiAccess.notifySizeChange();
            }
            return true;
        }
        return false;
    }

    protected Size computeDynamicSize() {
        Position selfPosition = this.getPosition();
        Size currentSize = this.getSize();
        for (Widget widget : this.widgets) {
            Position size = widget.getPosition().add(widget.getSize()).subtract(selfPosition);
            if (size.x > currentSize.width) {
                currentSize = new Size(size.x, currentSize.height);
            }
            if (size.y <= currentSize.height) continue;
            currentSize = new Size(currentSize.width, size.y);
        }
        return currentSize;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        this.widgets.stream().flatMap(it -> it.getNativeWidgets().stream()).forEach(it -> it.setEnabled(visible));
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected void addWidget(Widget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Already added");
        }
        this.widgets.add(widget);
        widget.setUiAccess(this.groupUIAccess);
        widget.setGui(this.gui);
        widget.setSizes(this.sizes);
        widget.setParentPosition(this.getPosition());
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    protected void removeWidget(Widget widget) {
        if (!this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Not added");
        }
        this.widgets.remove(widget);
        widget.setUiAccess(null);
        widget.setGui(null);
        widget.setSizes(null);
        widget.setParentPosition(Position.ORIGIN);
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    protected void clearAllWidgets() {
        this.widgets.forEach(it -> {
            it.setUiAccess(null);
            it.setGui(null);
            it.setSizes(null);
            it.setParentPosition(Position.ORIGIN);
        });
        this.widgets.clear();
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    public boolean isWidgetVisible(Widget widget) {
        return this.isVisible;
    }

    public boolean isWidgetClickable(Widget widget) {
        return this.isWidgetVisible(widget);
    }

    @Override
    public void initWidget() {
        for (Widget widget : this.widgets) {
            widget.setGui(this.gui);
            widget.setSizes(this.sizes);
            widget.initWidget();
        }
    }

    @Override
    public List<INativeWidget> getNativeWidgets() {
        ArrayList<INativeWidget> nativeWidgets = new ArrayList<INativeWidget>();
        for (Widget widget : this.widgets) {
            nativeWidgets.addAll(widget.getNativeWidgets());
        }
        if (this instanceof INativeWidget) {
            nativeWidgets.add((INativeWidget)((Object)this));
        }
        return nativeWidgets;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        ArrayList targets = new ArrayList();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof IGhostIngredientTarget)) continue;
            targets.addAll(((IGhostIngredientTarget)((Object)widget)).getPhantomTargets(ingredient));
        }
        return targets;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        for (Widget widget : this.widgets) {
            IIngredientSlot ingredientSlot;
            Object result;
            if (!(widget instanceof IIngredientSlot) || (result = (ingredientSlot = (IIngredientSlot)((Object)widget)).getIngredientOverMouse(mouseX, mouseY)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void detectAndSendChanges() {
        for (Widget widget : this.widgets) {
            widget.detectAndSendChanges();
        }
    }

    @Override
    public void updateScreen() {
        for (Widget widget : this.widgets) {
            widget.updateScreen();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetVisible(widget)) continue;
            widget.drawInForeground(mouseX, mouseY);
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        for (Widget widget : this.widgets) {
            if (!this.isWidgetVisible(widget)) continue;
            widget.drawInBackground(mouseX, mouseY, context);
        }
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        return this.widgets.stream().filter(this::isWidgetClickable).anyMatch(it -> it.mouseWheelMove(mouseX, mouseY, wheelDelta));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.widgets.stream().filter(this::isWidgetClickable).anyMatch(it -> it.mouseClicked(mouseX, mouseY, button));
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return this.widgets.stream().filter(this::isWidgetClickable).anyMatch(it -> it.mouseDragged(mouseX, mouseY, button, timeDragged));
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return this.widgets.stream().filter(this::isWidgetClickable).anyMatch(it -> it.mouseReleased(mouseX, mouseY, button));
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        return this.widgets.stream().filter(this::isWidgetClickable).anyMatch(it -> it.keyTyped(charTyped, keyCode));
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.readUpdateInfo(widgetUpdateId, buffer);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.handleClientAction(widgetUpdateId, buffer);
        }
    }

    private class WidgetGroupUIAccess
    implements WidgetUIAccess {
        private WidgetGroupUIAccess() {
        }

        @Override
        public void notifySizeChange() {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            AbstractWidgetGroup.this.recomputeSize();
            if (uiAccess != null) {
                uiAccess.notifySizeChange();
            }
        }

        @Override
        public void notifyWidgetChange() {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.notifyWidgetChange();
            }
            AbstractWidgetGroup.this.recomputeSize();
        }

        @Override
        public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            AbstractWidgetGroup.this.writeClientAction(1, buffer -> {
                buffer.func_150787_b(AbstractWidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }

        @Override
        public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            AbstractWidgetGroup.this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(AbstractWidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }
    }
}

