/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import org.lwjgl.input.Keyboard;

public class ClickButtonWidget
extends Widget {
    protected TextureArea buttonTexture = GuiTextures.VANILLA_BUTTON.getSubArea(0.0, 0.0, 1.0, 0.5);
    protected String displayText;
    protected int textColor = 0xFFFFFF;
    protected Consumer<ClickData> onPressCallback;

    public ClickButtonWidget(int xPosition, int yPosition, int width, int height, String displayText, Consumer<ClickData> onPressed) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.displayText = displayText;
        this.onPressCallback = onPressed;
    }

    public ClickButtonWidget setButtonTexture(TextureArea buttonTexture) {
        this.buttonTexture = buttonTexture;
        return this;
    }

    public ClickButtonWidget setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, context);
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(position.x, position.y, size.width, size.height, 0.0, 1.0);
        } else {
            this.buttonTexture.drawSubArea(position.x, position.y, size.width, size.height, 0.0, 0.0, 1.0, 1.0);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)this.displayText, (Object[])new Object[0]);
        fontRenderer.func_78276_b(text, position.x + size.width / 2 - fontRenderer.func_78256_a(text) / 2, position.y + size.height / 2 - fontRenderer.field_78288_b / 2, this.textColor);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.triggerButton();
            return true;
        }
        return false;
    }

    protected void triggerButton() {
        boolean isShiftClick = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean isCtrlClick = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        this.writeClientAction(1, buffer -> {
            buffer.writeBoolean(isShiftClick);
            buffer.writeBoolean(isCtrlClick);
        });
        this.playButtonClickSound();
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            boolean isShiftClick = buffer.readBoolean();
            boolean isCtrlClick = buffer.readBoolean();
            this.onPressCallback.accept(new ClickData(isShiftClick, isCtrlClick));
        }
    }

    public final class ClickData {
        public final boolean isShiftClick;
        public final boolean isCtrlClick;

        public ClickData(boolean isShiftClick, boolean isCtrlClick) {
            this.isShiftClick = isShiftClick;
            this.isCtrlClick = isCtrlClick;
        }
    }
}

