/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LabelWidget
extends Widget {
    protected boolean xCentered = false;
    protected String text;
    protected Object[] formatting;
    private int color;

    public LabelWidget(int xPosition, int yPosition, String text, Object ... formatting) {
        this(xPosition, yPosition, text, 0x404040, formatting);
    }

    public LabelWidget(int xPosition, int yPosition, String text, int color) {
        this(xPosition, yPosition, text, color, new Object[0]);
    }

    public LabelWidget(int xPosition, int yPosition, String text, int color, Object[] formatting) {
        super(new Position(xPosition, yPosition), Size.ZERO);
        this.text = text;
        this.color = color;
        this.formatting = formatting;
        this.recomputeSize();
    }

    private String getResultText() {
        return I18n.func_135052_a((String)this.text, (Object[])this.formatting);
    }

    private void recomputeSize() {
        if (LabelWidget.isClientSide()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            String resultText = this.getResultText();
            this.setSize(new Size(fontRenderer.func_78256_a(resultText), fontRenderer.field_78288_b));
            if (this.uiAccess != null) {
                this.uiAccess.notifySizeChange();
            }
        }
    }

    public LabelWidget setXCentered(boolean xCentered) {
        this.xCentered = xCentered;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        String resultText = this.getResultText();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position pos = this.getPosition();
        if (!this.xCentered) {
            fontRenderer.func_78276_b(resultText, pos.x, pos.y, this.color);
        } else {
            fontRenderer.func_78276_b(resultText, pos.x - fontRenderer.func_78256_a(resultText) / 2, pos.y, this.color);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

