/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.DoubleSupplier;
import net.minecraft.network.PacketBuffer;

public class ProgressWidget
extends Widget {
    public final DoubleSupplier progressSupplier;
    private MoveType moveType;
    private TextureArea emptyBarArea;
    private TextureArea filledBarArea;
    private double lastProgressValue;

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, TextureArea fullImage, MoveType moveType) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
        this.emptyBarArea = fullImage.getSubArea(0.0, 0.0, 1.0, 0.5);
        this.filledBarArea = fullImage.getSubArea(0.0, 0.5, 1.0, 0.5);
        this.moveType = moveType;
    }

    public ProgressWidget setProgressBar(TextureArea emptyBarArea, TextureArea filledBarArea, MoveType moveType) {
        this.emptyBarArea = emptyBarArea;
        this.filledBarArea = filledBarArea;
        this.moveType = moveType;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.emptyBarArea != null) {
            this.emptyBarArea.draw(pos.x, pos.y, size.width, size.height);
        }
        if (this.filledBarArea != null) {
            if (this.moveType == MoveType.HORIZONTAL) {
                this.filledBarArea.drawSubArea(pos.x, pos.y, (int)((double)size.width * this.lastProgressValue), size.height, 0.0, 0.0, (double)((int)((double)size.width * this.lastProgressValue)) / ((double)size.width * 1.0), 1.0);
            } else if (this.moveType == MoveType.VERTICAL) {
                int progressValueScaled = (int)((double)size.height * this.lastProgressValue);
                this.filledBarArea.drawSubArea(pos.x, pos.y + size.height - progressValueScaled, size.width, progressValueScaled, 0.0, 1.0 - (double)progressValueScaled / ((double)size.height * 1.0), 1.0, (double)progressValueScaled / ((double)size.height * 1.0));
            } else if (this.moveType == MoveType.VERTICAL_INVERTED) {
                int progressValueScaled = (int)((double)size.height * this.lastProgressValue);
                this.filledBarArea.drawSubArea(pos.x, pos.y, size.width, progressValueScaled, 0.0, 0.0, 1.0, (double)progressValueScaled / ((double)size.height * 1.0));
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        double actualValue = this.progressSupplier.getAsDouble();
        if (Math.abs(actualValue - this.lastProgressValue) > 0.005) {
            this.lastProgressValue = actualValue;
            this.writeUpdateInfo(0, buffer -> buffer.writeDouble(actualValue));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastProgressValue = buffer.readDouble();
        }
    }

    public static enum MoveType {
        VERTICAL,
        HORIZONTAL,
        VERTICAL_INVERTED;

    }
}

