/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotWidget
extends Widget
implements INativeWidget {
    protected SlotItemHandler slotReference;
    protected boolean isEnabled = true;
    protected boolean canTakeItems;
    protected boolean canPutItems;
    protected INativeWidget.SlotLocationInfo locationInfo = new INativeWidget.SlotLocationInfo(false, false);
    protected TextureArea[] backgroundTexture;
    protected Runnable changeListener;

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = new WidgetSlotDelegate((IItemHandler)itemHandler, slotIndex, xPosition + 1, yPosition + 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        if (this.isEnabled && this.backgroundTexture != null) {
            Position pos = this.getPosition();
            Size size = this.getSize();
            for (TextureArea backgroundTexture : this.backgroundTexture) {
                backgroundTexture.draw(pos.x, pos.y, size.width, size.height);
            }
        }
    }

    @Override
    protected void onPositionUpdate() {
        if (this.slotReference != null) {
            Position position = this.getPosition();
            this.slotReference.field_75223_e = position.x + 1;
            this.slotReference.field_75221_f = position.y + 1;
        }
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void detectAndSendChanges() {
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(TextureArea ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public SlotWidget setLocationInfo(boolean isPlayerInventory, boolean isHotbarSlot) {
        this.locationInfo = new INativeWidget.SlotLocationInfo(isPlayerInventory, isHotbarSlot);
        return this;
    }

    @Override
    public INativeWidget.SlotLocationInfo getSlotLocationInfo() {
        return this.locationInfo;
    }

    public boolean canPutStack(ItemStack stack) {
        return this.isEnabled && this.canPutItems;
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.isEnabled && this.canTakeItems;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return this.isEnabled;
    }

    public void onSlotChanged() {
        this.gui.holder.markAsDirty();
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return INativeWidget.VANILLA_LOGIC;
    }

    public final SlotItemHandler getHandle() {
        return this.slotReference;
    }

    protected class WidgetSlotDelegate
    extends SlotItemHandler {
        public WidgetSlotDelegate(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }
    }
}

