/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import gregtech.api.items.armor.DummyArmorLogic;
import gregtech.api.items.armor.IArmorItem;
import gregtech.api.items.armor.IArmorLogic;
import gregtech.api.items.armor.ISpecialArmorLogic;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.api.items.metaitem.stats.IMetaItemStats;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorMetaItem<T extends ArmorMetaValueItem>
extends MetaItem<T>
implements IArmorItem,
ISpecialArmor {
    public ArmorMetaItem() {
        super((short)0);
    }

    @Override
    protected T constructMetaValueItem(short metaValue, String unlocalizedName) {
        return (T)new ArmorMetaValueItem((int)metaValue, unlocalizedName);
    }

    @Nonnull
    private IArmorLogic getArmorLogic(ItemStack itemStack) {
        ArmorMetaValueItem metaValueItem = (ArmorMetaValueItem)this.getItem(itemStack);
        return metaValueItem == null ? new DummyArmorLogic() : metaValueItem.getArmorLogic();
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, stack);
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        multimap.putAll(armorLogic.getAttributeModifiers(slot, stack));
        return multimap;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(armor);
        if (armorLogic instanceof ISpecialArmor) {
            return ((ISpecialArmor)armorLogic).getProperties(player, armor, source, damage, slot);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(armor);
        if (armorLogic instanceof ISpecialArmorLogic) {
            return ((ISpecialArmorLogic)armorLogic).getArmorDisplay(player, armor, slot);
        }
        return 0;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        armorLogic.damageArmor(entity, stack, source, damage, ArmorMetaItem.getSlotByIndex(slot));
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        IArmorLogic armorLogic = this.getArmorLogic(armor);
        if (armorLogic instanceof ISpecialArmorLogic) {
            return ((ISpecialArmorLogic)armorLogic).handleUnblockableDamage(entity, armor, source, damage, ArmorMetaItem.getSlotByIndex(slot));
        }
        return false;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        armorLogic.onArmorTick(world, player, itemStack);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        return super.isValidArmor(stack, armorType, entity) && armorLogic.isValidArmor(stack, entity, armorType);
    }

    @Nullable
    public EntityEquipmentSlot getEquipmentSlot(ItemStack stack) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        return armorLogic.getEquipmentSlot(stack);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        return armorLogic.getArmorTexture(stack, entity, slot, type);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        return armorLogic.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    @Override
    public int getArmorLayersAmount(ItemStack itemStack) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        return armorLogic.getArmorLayersAmount(itemStack);
    }

    @Override
    public int getArmorLayerColor(ItemStack itemStack, int layerIndex) {
        IArmorLogic armorLogic = this.getArmorLogic(itemStack);
        return armorLogic.getArmorLayerColor(itemStack, layerIndex);
    }

    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        IArmorLogic armorLogic = this.getArmorLogic(stack);
        armorLogic.renderHelmetOverlay(stack, player, resolution, partialTicks);
    }

    private static EntityEquipmentSlot getSlotByIndex(int index) {
        switch (index) {
            case 0: {
                return EntityEquipmentSlot.FEET;
            }
            case 1: {
                return EntityEquipmentSlot.LEGS;
            }
            case 2: {
                return EntityEquipmentSlot.CHEST;
            }
        }
        return EntityEquipmentSlot.HEAD;
    }

    public class ArmorMetaValueItem
    extends MetaItem.MetaValueItem {
        private IArmorLogic armorLogic;

        protected ArmorMetaValueItem(int metaValue, String unlocalizedName) {
            super(ArmorMetaItem.this, metaValue, unlocalizedName);
            this.armorLogic = new DummyArmorLogic();
            this.setMaxStackSize(1);
        }

        @Nonnull
        public IArmorLogic getArmorLogic() {
            return this.armorLogic;
        }

        public ArmorMetaValueItem setArmorLogic(IArmorLogic armorLogic) {
            Preconditions.checkNotNull((Object)armorLogic, (Object)"Cannot set armorLogic to null");
            this.armorLogic = armorLogic;
            this.armorLogic.addToolComponents(this);
            return this;
        }

        @Override
        public ArmorMetaValueItem addStats(IMetaItemStats ... stats) {
            super.addStats(stats);
            return this;
        }

        @Override
        public ArmorMetaValueItem addComponents(IItemComponent ... stats) {
            super.addComponents(stats);
            return this;
        }
    }
}

