/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import gregtech.api.items.armor.IArmorItem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmorRenderHooks {
    public static boolean shouldNotRenderHeadItem(EntityLivingBase entityLivingBase) {
        ItemStack itemStack = entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD);
        return ArmorRenderHooks.isArmorItem(itemStack, EntityEquipmentSlot.HEAD);
    }

    public static boolean isArmorItem(ItemStack itemStack, EntityEquipmentSlot slot) {
        return itemStack.func_77973_b() instanceof IArmorItem && itemStack.func_77973_b().getEquipmentSlot(itemStack) == slot;
    }

    public static void renderArmorLayer(LayerArmorBase<ModelBase> layer, EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ItemStack itemStack = entity.func_184582_a(slotIn);
        if (ArmorRenderHooks.isArmorItem(itemStack, slotIn)) {
            IArmorItem armorItem = (IArmorItem)itemStack.func_77973_b();
            ModelBase armorModel = layer.func_188360_a(slotIn);
            if (armorModel instanceof ModelBiped) {
                armorModel = ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (EntityEquipmentSlot)slotIn, (ModelBiped)((ModelBiped)armorModel));
            }
            armorModel.func_178686_a(layer.field_177190_a.func_177087_b());
            armorModel.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
            layer.func_188359_a(armorModel, slotIn);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int layers = armorItem.getArmorLayersAmount(itemStack);
            for (int layerIndex = 0; layerIndex < layers; ++layerIndex) {
                int i = armorItem.getArmorLayerColor(itemStack, layerIndex);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)1.0f);
                String type = layerIndex == 0 ? null : "layer_" + layerIndex;
                layer.field_177190_a.func_110776_a(ArmorRenderHooks.getArmorTexture(entity, itemStack, slotIn, type));
                armorModel.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
            if (itemStack.func_77962_s()) {
                LayerArmorBase.func_188364_a((RenderLivingBase)layer.field_177190_a, (EntityLivingBase)entity, (ModelBase)armorModel, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
            }
        }
    }

    private static boolean isLegSlot(EntityEquipmentSlot equipmentSlot) {
        return equipmentSlot == EntityEquipmentSlot.LEGS;
    }

    private static ResourceLocation getArmorTexture(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, String type) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", registryName.func_110624_b(), registryName.func_110623_a(), ArmorRenderHooks.isLegSlot(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        return new ResourceLocation(ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)itemStack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
    }
}

