/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.armor;

import com.google.common.collect.Multimap;
import gregtech.api.items.armor.ArmorMetaItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IArmorLogic {
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A144-9C13A33DB5CF");
    public static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4288-B05C-BCCE9785ACA3");

    default public void addToolComponents(ArmorMetaItem.ArmorMetaValueItem metaValueItem) {
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack var1);

    public void damageArmor(EntityLivingBase var1, ItemStack var2, DamageSource var3, int var4, EntityEquipmentSlot var5);

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot var1, ItemStack var2);

    default public boolean isValidArmor(ItemStack itemStack, Entity entity, EntityEquipmentSlot equipmentSlot) {
        return this.getEquipmentSlot(itemStack) == equipmentSlot;
    }

    default public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderHelmetOverlay(ItemStack itemStack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
    }

    default public int getArmorLayersAmount(ItemStack itemStack) {
        return 1;
    }

    default public int getArmorLayerColor(ItemStack itemStack, int layerIndex) {
        return 0xFFFFFF;
    }

    public String getArmorTexture(ItemStack var1, Entity var2, EntityEquipmentSlot var3, String var4);

    @Nullable
    default public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        return null;
    }
}

