/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.materialitem;

import com.google.common.base.Preconditions;
import gnu.trove.map.hash.TShortObjectHashMap;
import gregtech.api.GregTechAPI;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.items.metaitem.StandardMetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MaterialMetaItem
extends StandardMetaItem {
    protected OrePrefix[] orePrefixes;
    private ArrayList<Short> generatedItems = new ArrayList();

    public MaterialMetaItem(OrePrefix ... orePrefixes) {
        super((short)(1000 * orePrefixes.length));
        Preconditions.checkArgument((orePrefixes.length <= 32 ? 1 : 0) != 0, (Object)"Max allowed OrePrefix count on MaterialMetaItem is 32.");
        this.orePrefixes = orePrefixes;
        Iterator<Material> iterator = Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            int i = Material.MATERIAL_REGISTRY.getIDForObject(material);
            for (int j = 0; j < orePrefixes.length; ++j) {
                OrePrefix orePrefix = orePrefixes[j];
                if (orePrefix == null || !this.canGenerate(orePrefix, material)) continue;
                short metadata = (short)(j * 1000 + i);
                this.generatedItems.add(metadata);
            }
        }
    }

    public void registerOreDict() {
        for (short metaItem : this.generatedItems) {
            OrePrefix prefix = this.orePrefixes[metaItem / 1000];
            Material material = Material.MATERIAL_REGISTRY.getObjectById(metaItem % 1000);
            OreDictUnifier.registerOre(new ItemStack((Item)this, 1, (int)metaItem), prefix, material);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        super.registerModels();
        TShortObjectHashMap alreadyRegistered = new TShortObjectHashMap();
        for (short metaItem : this.generatedItems) {
            ResourceLocation resourceLocation;
            OrePrefix prefix = this.orePrefixes[metaItem / 1000];
            MaterialIconSet materialIconSet = Material.MATERIAL_REGISTRY.getObjectById((int)(metaItem % 1000)).materialIconSet;
            short registrationKey = (short)(metaItem / 1000 * 1000 + materialIconSet.ordinal());
            if (!alreadyRegistered.containsKey(registrationKey)) {
                resourceLocation = prefix.materialIconType.getItemModelPath(materialIconSet);
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{resourceLocation});
                alreadyRegistered.put(registrationKey, (Object)new ModelResourceLocation(resourceLocation, "inventory"));
            }
            resourceLocation = (ModelResourceLocation)alreadyRegistered.get(registrationKey);
            this.metaItemsModels.put(metaItem, (Object)resourceLocation);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex == 0 && stack.func_77960_j() < this.metaItemOffset) {
            Material material = Material.MATERIAL_REGISTRY.getObjectById(stack.func_77960_j() % 1000);
            if (material == null) {
                return 0xFFFFFF;
            }
            return material.materialRGB;
        }
        return super.getColorForItemStack(stack, tintIndex);
    }

    protected boolean canGenerate(OrePrefix orePrefix, Material material) {
        return orePrefix.doGenerateItem(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemStack) {
        if (itemStack.func_77952_i() < this.metaItemOffset) {
            Material material = Material.MATERIAL_REGISTRY.getObjectById(itemStack.func_77952_i() % 1000);
            OrePrefix prefix = this.orePrefixes[itemStack.func_77952_i() / 1000];
            if (material == null || prefix == null) {
                return "";
            }
            return prefix.getLocalNameForItem(material);
        }
        return super.func_77653_i(itemStack);
    }

    @Override
    public int getItemStackLimit(ItemStack stack) {
        if (stack.func_77952_i() < this.metaItemOffset) {
            OrePrefix prefix = this.orePrefixes[stack.func_77952_i() / 1000];
            if (prefix == null) {
                return 64;
            }
            return prefix.maxStackSize;
        }
        return super.getItemStackLimit(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        super.func_150895_a(tab, subItems);
        if (tab == GregTechAPI.TAB_GREGTECH_MATERIALS || tab == CreativeTabs.field_78027_g) {
            for (short metadata : this.generatedItems) {
                subItems.add((Object)new ItemStack((Item)this, 1, (int)metadata));
            }
        }
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(itemStack, worldIn, entityIn, itemSlot, isSelected);
        if (itemStack.func_77952_i() < this.metaItemOffset && this.generatedItems.contains((short)itemStack.func_77952_i()) && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityIn;
            OrePrefix prefix = this.orePrefixes[itemStack.func_77952_i() / 1000];
            if (worldIn.func_82737_E() % 20L == 0L && (double)prefix.heatDamage != 0.0) {
                if ((double)prefix.heatDamage > 0.0) {
                    entity.func_70097_a(DamageSources.getHeatDamage(), prefix.heatDamage);
                } else if ((double)prefix.heatDamage < 0.0) {
                    entity.func_70097_a(DamageSources.getFrostDamage(), -prefix.heatDamage);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> lines, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, worldIn, lines, tooltipFlag);
        int damage = itemStack.func_77952_i();
        if (damage < this.metaItemOffset) {
            Material material = Material.MATERIAL_REGISTRY.getObjectById(damage % 1000);
            OrePrefix prefix = this.orePrefixes[damage / 1000];
            if (prefix == null || material == null) {
                return;
            }
            this.addMaterialTooltip(itemStack, prefix, material, lines, tooltipFlag);
        }
    }

    public Material getMaterial(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage < this.metaItemOffset) {
            return Material.MATERIAL_REGISTRY.getObjectById(damage % 1000);
        }
        return null;
    }

    public OrePrefix getOrePrefix(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage < this.metaItemOffset) {
            return this.orePrefixes[damage / 1000];
        }
        return null;
    }

    @Override
    public int getItemBurnTime(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage < this.metaItemOffset) {
            Material material = Material.MATERIAL_REGISTRY.getObjectById(damage % 1000);
            OrePrefix prefix = this.orePrefixes[damage / 1000];
            if (material instanceof DustMaterial) {
                DustMaterial dustMaterial = (DustMaterial)material;
                return (int)((long)dustMaterial.burnTime * prefix.materialAmount / 3628800L);
            }
        }
        return super.getItemBurnTime(itemStack);
    }

    protected void addMaterialTooltip(ItemStack itemStack, OrePrefix prefix, Material material, List<String> lines, ITooltipFlag tooltipFlag) {
    }
}

