/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import forestry.api.arboriculture.IToolGrafter;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.enchants.EnchantmentData;
import gregtech.api.items.IToolItem;
import gregtech.api.items.ToolDictNames;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.api.items.metaitem.stats.IItemContainerItemProvider;
import gregtech.api.items.metaitem.stats.IMetaItemStats;
import gregtech.api.items.toolitem.DummyToolStats;
import gregtech.api.items.toolitem.IAOEItem;
import gregtech.api.items.toolitem.IToolStats;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

@Optional.Interface(modid="forestry", iface="forestry.api.arboriculture.IToolGrafter")
public class ToolMetaItem<T extends MetaToolValueItem>
extends MetaItem<T>
implements IToolItem,
IAOEItem,
IToolGrafter {
    public ToolMetaItem() {
        super((short)0);
    }

    @Override
    protected T constructMetaValueItem(short metaValue, String unlocalizedName) {
        return (T)new MetaToolValueItem((int)metaValue, unlocalizedName);
    }

    @Override
    protected String formatModelPath(T metaValueItem) {
        String name = ((MetaToolValueItem)metaValueItem).unlocalizedName;
        return "tools/" + (name.indexOf(46) == -1 ? name : name.substring(name.indexOf(".") + 1));
    }

    @Override
    protected short formatRawItemDamage(short metaValue) {
        return (short)(metaValue % 16000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getColorForItemStack(ItemStack stack, int tintIndex) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
        if (item == null) {
            return 0xFFFFFF;
        }
        if (item.getColorProvider() != null) {
            return item.getColorProvider().getItemStackColor(stack, tintIndex);
        }
        IToolStats toolStats = item.getToolStats();
        return toolStats.getColor(stack, tintIndex);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
        if (item != null && item.getDurabilityManager() != null) {
            return item.getDurabilityManager().showsDurabilityBar(stack);
        }
        return stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null) || this.getItemDamage(stack) != 0;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
        if (item != null && item.getDurabilityManager() != null) {
            return item.getDurabilityManager().getDurabilityForDisplay(stack);
        }
        if (stack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            return 1.0 - (double)electricItem.getCharge() / ((double)electricItem.getMaxCharge() * 1.0);
        }
        return (double)this.getItemDamage(stack) / ((double)this.getMaxItemDamage(stack) * 1.0);
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        double internalDamage = (double)this.getItemDamage(stack) / ((double)this.getMaxItemDamage(stack) * 1.0);
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - internalDamage)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            toolStats.onToolCrafted(stack, playerIn);
        }
    }

    @Override
    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats;
            int toolDamagePerCraft;
            boolean canApplyDamage;
            IItemContainerItemProvider containerItemProvider = metaToolValueItem.getContainerItemProvider();
            if (containerItemProvider != null) {
                return containerItemProvider.getContainerItem(stack);
            }
            if (metaToolValueItem.toolStats != null && !(canApplyDamage = this.damageItem(stack, toolDamagePerCraft = (toolStats = metaToolValueItem.toolStats).getToolDamagePerContainerCraft(stack), false))) {
                return stack;
            }
        }
        return stack;
    }

    @Override
    public List<BlockPos> getAOEBlocks(ItemStack itemStack, EntityPlayer player, RayTraceResult rayTraceResult) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            return toolStats.getAOEBlocks(itemStack, player, rayTraceResult);
        }
        return Collections.emptyList();
    }

    public float getSaplingModifier(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            return toolStats.getSaplingModifier(stack, world, player, pos);
        }
        return 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemStack, BlockPos pos, EntityPlayer player) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            return toolStats.onBlockPreBreak(itemStack, pos, player);
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            toolStats.onBlockDestroyed(stack, world, state, pos, entity);
            this.damageItem(stack, toolStats.getToolDamagePerBlockBreak(stack), false);
        }
        return true;
    }

    public void onBlockDropsHarvested(ItemStack itemStack, World world, BlockPos pos, IBlockState blockState, EntityPlayer player, List<ItemStack> dropList) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            toolStats.convertBlockDrops(world, pos, blockState, player, dropList, itemStack);
        }
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        IToolStats toolStats;
        Preconditions.checkNotNull((Object)state, (Object)"null blockState");
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && this.isUsable(stack, (toolStats = metaToolValueItem.getToolStats()).getToolDamagePerBlockBreak(stack)) && toolStats.canMineBlock(state, stack)) {
            return this.getToolDigSpeed(stack);
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        Preconditions.checkNotNull((Object)state, (Object)"null blockState");
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null) {
            IToolStats toolStats = metaToolValueItem.getToolStats();
            return this.isUsable(stack, toolStats.getToolDamagePerBlockBreak(stack)) && toolStats.canMineBlock(state, stack);
        }
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        Preconditions.checkNotNull((Object)blockState, (Object)"null blockState");
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem == null) {
            return -1;
        }
        IToolStats toolStats = metaToolValueItem.getToolStats();
        if (this.isUsable(stack, toolStats.getToolDamagePerBlockBreak(stack)) && toolStats.canMineBlock(blockState, stack)) {
            return this.getHarvestLevel(stack);
        }
        return -1;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        MetaToolValueItem metaValueItem = (MetaToolValueItem)this.getItem(stack);
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(super.getAttributeModifiers(slot, stack));
        if (metaValueItem != null && slot == EntityEquipmentSlot.MAINHAND) {
            IToolStats toolStats = metaValueItem.getToolStats();
            if (toolStats == null) {
                return HashMultimap.create();
            }
            float attackDamage = this.getToolAttackDamage(stack);
            float attackSpeed = toolStats.getAttackSpeed(stack);
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)attackDamage, 0));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeed, 0));
        }
        return modifiers;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        int damagePerAttack;
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && !this.isUsable(stack, damagePerAttack = metaToolValueItem.getToolStats().getToolDamagePerEntityAttack(stack))) {
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        MetaToolValueItem metaValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaValueItem != null) {
            IToolStats toolStats = metaValueItem.getToolStats();
            if (!this.damageItem(stack, toolStats.getToolDamagePerEntityAttack(stack), false)) {
                return true;
            }
            float additionalDamage = toolStats.getNormalDamageBonus(target, stack, attacker);
            float additionalMagicDamage = toolStats.getMagicDamageBonus(target, stack, attacker);
            if (additionalDamage > 0.0f) {
                target.func_70097_a((DamageSource)new EntityDamageSource(attacker instanceof EntityPlayer ? "player" : "mob", (Entity)attacker), additionalDamage);
            }
            if (additionalMagicDamage > 0.0f) {
                target.func_70097_a((DamageSource)new EntityDamageSource("indirectMagic", (Entity)attacker), additionalMagicDamage);
            }
        }
        return true;
    }

    public boolean isUsable(ItemStack stack, int damage) {
        IElectricItem capability = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        int energyAmount = ConfigHolder.energyUsageMultiplier * damage;
        return capability == null || capability.canUse(energyAmount);
    }

    @Override
    public boolean damageItem(ItemStack stack, int vanillaDamage, boolean simulate) {
        IToolStats toolStats;
        IElectricItem capability = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (capability != null) {
            int energyAmount = ConfigHolder.energyUsageMultiplier * vanillaDamage;
            if (capability.discharge(energyAmount, capability.getTier(), true, false, true) < (long)energyAmount) {
                return false;
            }
            capability.discharge(energyAmount, capability.getTier(), true, false, simulate);
        }
        if (!(toolStats = ((MetaToolValueItem)this.getItem(stack)).getToolStats()).isUsingDurability(stack)) {
            return true;
        }
        int newDamageValue = this.getItemDamage(stack) + ToolMetaItem.calculateToolDamage(stack, field_77697_d, vanillaDamage);
        if (!simulate && !this.setInternalDamage(stack, newDamageValue)) {
            GTUtility.setItem(stack, toolStats.getBrokenStack(stack));
        }
        return true;
    }

    public int regainItemDurability(ItemStack itemStack, int maxDurabilityRegain) {
        IToolStats toolStats = ((MetaToolValueItem)this.getItem(itemStack)).getToolStats();
        if (!toolStats.isUsingDurability(itemStack)) {
            return 0;
        }
        int toolDamage = this.getItemDamage(itemStack);
        int durabilityRegained = Math.min(toolDamage, maxDurabilityRegain);
        this.setInternalDamage(itemStack, toolDamage - durabilityRegained);
        return durabilityRegained;
    }

    private static int calculateToolDamage(ItemStack itemStack, Random random, int amount) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemStack);
        int damageNegated = 0;
        for (int k = 0; level > 0 && k < amount; ++k) {
            if (!EnchantmentDurability.func_92097_a((ItemStack)itemStack, (int)level, (Random)random)) continue;
            ++damageNegated;
        }
        return Math.max(0, amount - damageNegated);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        ICapabilityProvider capabilityProvider = super.initCapabilities(stack, nbt);
        if (capabilityProvider != null && capabilityProvider.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) {
            IElectricItem electricItem = (IElectricItem)capabilityProvider.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            electricItem.addChargeListener((itemStack, newCharge) -> {
                int newDamage = (newCharge == 0L ? 16000 : 0) + itemStack.func_77952_i() % 16000;
                if (newDamage != itemStack.func_77952_i()) {
                    itemStack.func_77964_b(newDamage);
                }
            });
        }
        return capabilityProvider;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() >= this.metaItemOffset) {
            MetaToolValueItem item = (MetaToolValueItem)this.getItem(stack);
            SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(stack);
            String materialName = primaryMaterial == null ? "" : String.valueOf(primaryMaterial.getLocalizedName());
            return I18n.func_135052_a((String)("metaitem." + item.unlocalizedName + ".name"), (Object[])new Object[]{materialName});
        }
        return super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> lines, ITooltipFlag tooltipFlag) {
        MetaToolValueItem item = (MetaToolValueItem)this.getItem(itemStack);
        if (item == null) {
            return;
        }
        IToolStats toolStats = item.getToolStats();
        SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(itemStack);
        int maxInternalDamage = this.getMaxItemDamage(itemStack);
        if (toolStats.isUsingDurability(itemStack) && maxInternalDamage > 0) {
            lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.durability", (Object[])new Object[]{maxInternalDamage - this.getItemDamage(itemStack), maxInternalDamage}));
        }
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.primary_material", (Object[])new Object[]{primaryMaterial.getLocalizedName(), this.getHarvestLevel(itemStack)}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.attack_damage", (Object[])new Object[]{Float.valueOf(toolStats.getBaseDamage(itemStack) + (float)primaryMaterial.harvestLevel)}));
        lines.add(I18n.func_135052_a((String)"metaitem.tool.tooltip.mining_speed", (Object[])new Object[]{Float.valueOf(this.getToolDigSpeed(itemStack))}));
        super.func_77624_a(itemStack, worldIn, lines, tooltipFlag);
        toolStats.addInformation(itemStack, lines, tooltipFlag.func_194127_a());
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Override
    public int getItemEnchantability(ItemStack stack) {
        SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(stack);
        return ToolMetaItem.getMaterialEnchantability(primaryMaterial);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(stack);
        if (metaToolValueItem != null && metaToolValueItem.toolStats != null) {
            return metaToolValueItem.toolStats.canApplyEnchantment(stack, enchantment);
        }
        return false;
    }

    public static int getMaterialEnchantability(SolidMaterial material) {
        if (material.materialIconSet == MaterialIconSet.SHINY || material.materialIconSet == MaterialIconSet.RUBY) {
            return 33;
        }
        if (material.materialIconSet == MaterialIconSet.DULL || material.materialIconSet == MaterialIconSet.METALLIC) {
            return 21;
        }
        if (material.materialIconSet == MaterialIconSet.GEM_VERTICAL || material.materialIconSet == MaterialIconSet.GEM_HORIZONTAL || material.materialIconSet == MaterialIconSet.DIAMOND || material.materialIconSet == MaterialIconSet.OPAL || material.materialIconSet == MaterialIconSet.NETHERSTAR) {
            return 15;
        }
        if (material.materialIconSet == MaterialIconSet.WOOD || material.materialIconSet == MaterialIconSet.ROUGH || material.materialIconSet == MaterialIconSet.FINE) {
            return 11;
        }
        return 10;
    }

    @Override
    public int getMaxItemDamage(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            int materialDurability = 0;
            if (toolTag != null && toolTag.func_74764_b("MaxDurability")) {
                materialDurability = toolTag.func_74762_e("MaxDurability");
            } else if (toolMaterial != null) {
                materialDurability = toolMaterial.toolDurability;
            }
            float multiplier = toolStats.getMaxDurabilityMultiplier(itemStack);
            return (int)((float)materialDurability * multiplier);
        }
        return 0;
    }

    public float getToolDigSpeed(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            float toolSpeed = 0.0f;
            if (toolTag != null && toolTag.func_74764_b("DigSpeed")) {
                toolSpeed = toolTag.func_74760_g("DigSpeed");
            } else if (toolMaterial != null) {
                toolSpeed = toolMaterial.toolSpeed;
            }
            float multiplier = toolStats.getDigSpeedMultiplier(itemStack);
            return toolSpeed * multiplier;
        }
        return 0.0f;
    }

    public int getHarvestLevel(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            int harvestLevel = 0;
            if (toolTag != null && toolTag.func_74764_b("HarvestLevel")) {
                harvestLevel = toolTag.func_74762_e("HarvestLevel");
            } else if (toolMaterial != null) {
                harvestLevel = toolMaterial.harvestLevel;
            }
            int baseHarvestLevel = toolStats.getBaseQuality(itemStack);
            return baseHarvestLevel + harvestLevel;
        }
        return 0;
    }

    public float getToolAttackDamage(ItemStack itemStack) {
        MetaToolValueItem metaToolValueItem = (MetaToolValueItem)this.getItem(itemStack);
        if (metaToolValueItem != null) {
            NBTTagCompound toolTag = ToolMetaItem.getToolStatsTag(itemStack);
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(itemStack);
            IToolStats toolStats = metaToolValueItem.getToolStats();
            float attackDamage = 0.0f;
            if (toolTag != null && toolTag.func_74764_b("AttackDamage")) {
                attackDamage = toolTag.func_74760_g("AttackDamage");
            } else if (toolTag != null && toolTag.func_74764_b("HarvestLevel")) {
                attackDamage = toolTag.func_74762_e("HarvestLevel");
            } else if (toolMaterial != null) {
                attackDamage = toolMaterial.toolAttackDamage;
            }
            float baseAttackDamage = toolStats.getBaseDamage(itemStack);
            return baseAttackDamage + attackDamage;
        }
        return 0.0f;
    }

    @Override
    public int getItemDamage(ItemStack itemStack) {
        NBTTagCompound statsTag = ToolMetaItem.getToolStatsTag(itemStack);
        if (statsTag == null) {
            return 0;
        }
        if (statsTag.func_74764_b("Damage")) {
            boolean isElectricItem = itemStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            int oldToolDamage = statsTag.func_74762_e("Damage");
            return isElectricItem ? oldToolDamage : oldToolDamage / 10;
        }
        return statsTag.func_74762_e("Dmg");
    }

    private boolean setInternalDamage(ItemStack itemStack, int damage) {
        NBTTagCompound statsTag = ToolMetaItem.getOrCreateToolStatsTag(itemStack);
        statsTag.func_74768_a("Dmg", damage);
        statsTag.func_82580_o("Damage");
        return this.getItemDamage(itemStack) < this.getMaxItemDamage(itemStack);
    }

    private static NBTTagCompound getToolStatsTag(ItemStack itemStack) {
        return itemStack.func_179543_a("GT.ToolStats");
    }

    private static NBTTagCompound getOrCreateToolStatsTag(ItemStack itemStack) {
        return itemStack.func_190925_c("GT.ToolStats");
    }

    public static SolidMaterial getToolMaterial(ItemStack itemStack) {
        String toolMaterialName;
        NBTTagCompound statsTag = ToolMetaItem.getToolStatsTag(itemStack);
        if (statsTag == null) {
            return Materials.Aluminium;
        }
        if (statsTag.func_74764_b("Material")) {
            toolMaterialName = statsTag.func_74779_i("Material");
        } else if (statsTag.func_74764_b("PrimaryMaterial")) {
            toolMaterialName = statsTag.func_74779_i("PrimaryMaterial");
        } else {
            return Materials.Aluminium;
        }
        Material material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(toolMaterialName);
        if (material instanceof SolidMaterial) {
            return (SolidMaterial)material;
        }
        return Materials.Aluminium;
    }

    public class MetaToolValueItem
    extends MetaItem.MetaValueItem {
        protected IToolStats toolStats;
        protected double amountOfMaterialToRepair;

        protected MetaToolValueItem(int metaValue, String unlocalizedName) {
            super(ToolMetaItem.this, metaValue, unlocalizedName);
            this.toolStats = new DummyToolStats();
            this.amountOfMaterialToRepair = 0.0;
            this.setMaxStackSize(1);
        }

        @Override
        @Deprecated
        public MetaToolValueItem addStats(IMetaItemStats ... stats) {
            super.addStats(stats);
            return this;
        }

        @Override
        public MetaToolValueItem addComponents(IItemComponent ... stats) {
            super.addComponents(stats);
            return this;
        }

        public MetaToolValueItem setFullRepairCost(double amountOfMaterialToRepair) {
            this.amountOfMaterialToRepair = amountOfMaterialToRepair;
            return this;
        }

        public MetaToolValueItem setToolStats(IToolStats toolStats) {
            Preconditions.checkNotNull((Object)toolStats, (Object)"Cannot set toolStats to null");
            this.toolStats = toolStats;
            toolStats.onStatsAddedToTool(this);
            return this;
        }

        public MetaToolValueItem addOreDict(ToolDictNames ... oreDictNames) {
            Validate.notNull((Object)oreDictNames, (String)"Cannot add null ToolDictName.", (Object[])new Object[0]);
            Validate.noNullElements((Object[])oreDictNames, (String)"Cannot add null ToolDictName.", (Object[])new Object[0]);
            for (ToolDictNames oreDict : oreDictNames) {
                OreDictionary.registerOre((String)oreDict.name(), (ItemStack)this.getStackForm());
            }
            return this;
        }

        @Nonnull
        public IToolStats getToolStats() {
            return this.toolStats;
        }

        public double getAmountOfMaterialToRepair(ItemStack toolStack) {
            return this.amountOfMaterialToRepair;
        }

        @Override
        public ItemStack getStackForm(int amount) {
            ItemStack rawStack = super.getStackForm(amount);
            this.setToolMaterial(rawStack, Materials.Darmstadtium);
            return rawStack;
        }

        public ItemStack getStackForm(SolidMaterial primaryMaterial) {
            ItemStack rawStack = super.getStackForm(1);
            this.setToolMaterial(rawStack, primaryMaterial);
            return rawStack;
        }

        public ItemStack getChargedStack(SolidMaterial primaryMaterial, long chargeAmount) {
            ItemStack rawStack = super.getChargedStack(chargeAmount);
            this.setToolMaterial(rawStack, primaryMaterial);
            return rawStack;
        }

        public ItemStack getMaxChargeOverrideStack(SolidMaterial primaryMaterial, long maxCharge) {
            ItemStack rawStack = super.getMaxChargeOverrideStack(maxCharge);
            this.setToolMaterial(rawStack, primaryMaterial);
            return rawStack;
        }

        public final ItemStack getStackForm(SolidMaterial primaryMaterial, int amount) {
            ItemStack stack = new ItemStack((Item)ToolMetaItem.this, amount, ToolMetaItem.this.metaItemOffset + this.metaValue);
            this.setToolMaterial(stack, primaryMaterial);
            return stack;
        }

        public void setToolMaterial(ItemStack stack, SolidMaterial toolMaterial) {
            NBTTagCompound toolNBT = new NBTTagCompound();
            ArrayList<SolidMaterial> materials = new ArrayList<SolidMaterial>();
            toolNBT.func_74778_a("Material", toolMaterial.toString());
            materials.add(toolMaterial);
            NBTTagCompound nbtTag = stack.func_77978_p();
            if (nbtTag == null) {
                nbtTag = new NBTTagCompound();
            }
            nbtTag.func_74782_a("GT.ToolStats", (NBTBase)toolNBT);
            stack.func_77982_d(nbtTag);
            Map<Enchantment, Integer> enchantments = this.bakeEnchantmentsMap(stack, materials);
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
        }

        public ItemStack setToolData(ItemStack stack, SolidMaterial toolMaterial, int maxDurability, int harvestLevel, float digSpeed, float attackDamage) {
            NBTTagCompound nbtTag;
            NBTTagCompound toolNBT = new NBTTagCompound();
            ArrayList<SolidMaterial> materials = new ArrayList<SolidMaterial>();
            toolNBT.func_74778_a("Material", toolMaterial.toString());
            materials.add(toolMaterial);
            if (maxDurability > -1) {
                toolNBT.func_74768_a("MaxDurability", maxDurability);
            }
            if (harvestLevel > -1) {
                toolNBT.func_74768_a("HarvestLevel", harvestLevel);
            }
            if (digSpeed > -1.0f) {
                toolNBT.func_74776_a("DigSpeed", digSpeed);
            }
            if (attackDamage > -1.0f) {
                toolNBT.func_74776_a("AttackDamage", attackDamage);
            }
            if ((nbtTag = stack.func_77978_p()) == null) {
                nbtTag = new NBTTagCompound();
            }
            nbtTag.func_74782_a("GT.ToolStats", (NBTBase)toolNBT);
            stack.func_77982_d(nbtTag);
            Map<Enchantment, Integer> enchantments = this.bakeEnchantmentsMap(stack, materials);
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
            return stack;
        }

        private Map<Enchantment, Integer> bakeEnchantmentsMap(ItemStack itemStack, Collection<SolidMaterial> materials) {
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (SolidMaterial material : materials) {
                for (EnchantmentData enchantmentData : material.toolEnchantments) {
                    if (enchantments.containsKey(enchantmentData.enchantment)) {
                        int level = Math.min((Integer)enchantments.get(enchantmentData.enchantment) + enchantmentData.level, enchantmentData.enchantment.func_77325_b());
                        enchantments.put(enchantmentData.enchantment, level);
                        continue;
                    }
                    enchantments.put(enchantmentData.enchantment, enchantmentData.level);
                }
            }
            for (EnchantmentData enchantmentData : this.toolStats.getEnchantments(itemStack)) {
                if (enchantments.containsKey(enchantmentData.enchantment)) {
                    int level = Math.min((Integer)enchantments.get(enchantmentData.enchantment) + enchantmentData.level, enchantmentData.enchantment.func_77325_b());
                    enchantments.put(enchantmentData.enchantment, level);
                    continue;
                }
                enchantments.put(enchantmentData.enchantment, enchantmentData.level);
            }
            enchantments.keySet().removeIf(enchantment -> !enchantment.func_92089_a(itemStack));
            return enchantments;
        }
    }
}

