/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multiblock;

import com.google.common.base.Joiner;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.util.IntRange;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FactoryBlockPattern {
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    private final List<String[]> depth = new ArrayList<String[]>();
    private final List<int[]> aisleRepetitions = new ArrayList<int[]>();
    private final Map<Character, IntRange> countLimits = new HashMap<Character, IntRange>();
    private final Map<Character, Predicate<BlockWorldState>> symbolMap = new HashMap<Character, Predicate<BlockWorldState>>();
    private final TIntObjectMap<Predicate<PatternMatchContext>> layerValidators = new TIntObjectHashMap();
    private final List<Predicate<PatternMatchContext>> contextValidators = new ArrayList<Predicate<PatternMatchContext>>();
    private int aisleHeight;
    private int rowWidth;
    private BlockPattern.RelativeDirection[] structureDir = new BlockPattern.RelativeDirection[3];

    private FactoryBlockPattern(BlockPattern.RelativeDirection charDir, BlockPattern.RelativeDirection stringDir, BlockPattern.RelativeDirection aisleDir) {
        this.structureDir[0] = charDir;
        this.structureDir[1] = stringDir;
        this.structureDir[2] = aisleDir;
        int flags = 0;
        block5: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i]) {
                case UP: 
                case DOWN: {
                    flags |= 1;
                    continue block5;
                }
                case LEFT: 
                case RIGHT: {
                    flags |= 2;
                    continue block5;
                }
                case FRONT: 
                case BACK: {
                    flags |= 4;
                }
            }
        }
        if (flags != 7) {
            throw new IllegalArgumentException("Must have 3 different axes!");
        }
        this.symbolMap.put(Character.valueOf(' '), k -> true);
    }

    public FactoryBlockPattern aisleRepeatable(int minRepeat, int maxRepeat, String ... aisle) {
        if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
            if (this.depth.isEmpty()) {
                this.aisleHeight = aisle.length;
                this.rowWidth = aisle[0].length();
            }
            if (aisle.length != this.aisleHeight) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length + ")");
            }
            for (String s : aisle) {
                if (s.length() != this.rowWidth) {
                    throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + s.length() + ")");
                }
                for (char c0 : s.toCharArray()) {
                    if (this.symbolMap.containsKey(Character.valueOf(c0))) continue;
                    this.symbolMap.put(Character.valueOf(c0), null);
                }
            }
            this.depth.add(aisle);
            if (minRepeat > maxRepeat) {
                throw new IllegalArgumentException("Lower bound of repeat counting must smaller than upper bound!");
            }
            this.aisleRepetitions.add(new int[]{minRepeat, maxRepeat});
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public FactoryBlockPattern aisle(String ... aisle) {
        return this.aisleRepeatable(1, 1, aisle);
    }

    public FactoryBlockPattern setRepeatable(int minRepeat, int maxRepeat) {
        if (minRepeat > maxRepeat) {
            throw new IllegalArgumentException("Lower bound of repeat counting must smaller than upper bound!");
        }
        this.aisleRepetitions.set(this.aisleRepetitions.size() - 1, new int[]{minRepeat, maxRepeat});
        return this;
    }

    public FactoryBlockPattern setRepeatable(int repeatCount) {
        return this.setRepeatable(repeatCount, repeatCount);
    }

    public FactoryBlockPattern setAmountLimit(char symbol, int minAmount, int maxLimit) {
        this.symbolMap.put(Character.valueOf(symbol), null);
        this.countLimits.put(Character.valueOf(symbol), new IntRange(minAmount, maxLimit));
        return this;
    }

    public FactoryBlockPattern setAmountAtLeast(char symbol, int minValue) {
        return this.setAmountLimit(symbol, minValue, Integer.MAX_VALUE);
    }

    public FactoryBlockPattern setAmountAtMost(char symbol, int maxValue) {
        return this.setAmountLimit(symbol, 0, maxValue);
    }

    public static FactoryBlockPattern start() {
        return new FactoryBlockPattern(BlockPattern.RelativeDirection.RIGHT, BlockPattern.RelativeDirection.UP, BlockPattern.RelativeDirection.BACK);
    }

    public static FactoryBlockPattern start(BlockPattern.RelativeDirection charDir, BlockPattern.RelativeDirection stringDir, BlockPattern.RelativeDirection aisleDir) {
        return new FactoryBlockPattern(charDir, stringDir, aisleDir);
    }

    public FactoryBlockPattern where(char symbol, Predicate<BlockWorldState> blockMatcher) {
        this.symbolMap.put(Character.valueOf(symbol), blockMatcher);
        return this;
    }

    public FactoryBlockPattern validateContext(Predicate<PatternMatchContext> validator) {
        this.contextValidators.add(validator);
        return this;
    }

    public FactoryBlockPattern validateLayer(int layerIndex, Predicate<PatternMatchContext> layerValidator) {
        this.layerValidators.put(layerIndex, layerValidator);
        return this;
    }

    public BlockPattern build() {
        return new BlockPattern(this.makePredicateArray(), this.makeCountLimitsList(), this.layerValidators, this.contextValidators, this.structureDir, (int[][])this.aisleRepetitions.toArray((T[])new int[this.aisleRepetitions.size()][]));
    }

    private Predicate<BlockWorldState>[][][] makePredicateArray() {
        this.checkMissingPredicates();
        Predicate[][][] predicate = (Predicate[][][])Array.newInstance(Predicate.class, this.depth.size(), this.aisleHeight, this.rowWidth);
        for (int i = 0; i < this.depth.size(); ++i) {
            for (int j = 0; j < this.aisleHeight; ++j) {
                for (int k = 0; k < this.rowWidth; ++k) {
                    predicate[i][j][k] = this.symbolMap.get(Character.valueOf(this.depth.get(i)[j].charAt(k)));
                }
            }
        }
        return predicate;
    }

    private List<Pair<Predicate<BlockWorldState>, IntRange>> makeCountLimitsList() {
        ArrayList<Pair<Predicate<BlockWorldState>, IntRange>> array = new ArrayList<Pair<Predicate<BlockWorldState>, IntRange>>(this.countLimits.size());
        for (Map.Entry<Character, IntRange> entry : this.countLimits.entrySet()) {
            Predicate<BlockWorldState> predicate = this.symbolMap.get(entry.getKey());
            array.add((Pair<Predicate<BlockWorldState>, IntRange>)Pair.of(predicate, (Object)entry.getValue()));
        }
        return array;
    }

    private void checkMissingPredicates() {
        ArrayList<Character> list = new ArrayList<Character>();
        for (Map.Entry<Character, Predicate<BlockWorldState>> entry : this.symbolMap.entrySet()) {
            if (entry.getValue() != null) continue;
            list.add(entry.getKey());
        }
        if (!list.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + COMMA_JOIN.join(list) + " are missing");
        }
    }
}

