/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block.material;

import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.IMaterialPipeTile;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.type.Material;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public abstract class BlockMaterialPipe<PipeType extends Enum<PipeType>, NodeDataType, WorldPipeNetType extends WorldPipeNet<NodeDataType, ? extends PipeNet<NodeDataType>>>
extends BlockPipe<PipeType, NodeDataType, WorldPipeNetType> {
    @Override
    public NodeDataType createProperties(IPipeTile<PipeType, NodeDataType> pipeTile) {
        PipeType pipeType = pipeTile.getPipeType();
        Material material = ((IMaterialPipeTile)pipeTile).getPipeMaterial();
        if (pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(pipeType, material);
    }

    @Override
    public NodeDataType createItemProperties(ItemStack itemStack) {
        PipeType pipeType = this.getItemPipeType(itemStack);
        Material material = this.getItemMaterial(itemStack);
        if (pipeType == null || material == null) {
            return this.getFallbackType();
        }
        return this.createProperties(pipeType, material);
    }

    public ItemStack getItem(PipeType pipeType, Material material) {
        if (pipeType == null || material == null) {
            return ItemStack.field_190927_a;
        }
        int materialId = Material.MATERIAL_REGISTRY.getIDForObject(material);
        return new ItemStack((Block)this, 1, ((Enum)pipeType).ordinal() * 1000 + materialId);
    }

    @Override
    public PipeType getItemPipeType(ItemStack itemStack) {
        return (PipeType)((Enum[])this.getPipeTypeClass().getEnumConstants())[itemStack.func_77960_j() / 1000];
    }

    public Material getItemMaterial(ItemStack itemStack) {
        return Material.MATERIAL_REGISTRY.getObjectById(itemStack.func_77960_j() % 1000);
    }

    @Override
    public void setTileEntityData(TileEntityPipeBase<PipeType, NodeDataType> pipeTile, ItemStack itemStack) {
        ((TileEntityMaterialPipeBase)pipeTile).setPipeData(this, this.getItemPipeType(itemStack), this.getItemMaterial(itemStack));
    }

    @Override
    public ItemStack getDropItem(IPipeTile<PipeType, NodeDataType> pipeTile) {
        Material material = ((IMaterialPipeTile)pipeTile).getPipeMaterial();
        return this.getItem(pipeTile.getPipeType(), material);
    }

    protected abstract NodeDataType createProperties(PipeType var1, Material var2);
}

