/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.block.material;

import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.material.IMaterialPipeTile;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public abstract class TileEntityMaterialPipeBase<PipeType extends Enum<PipeType>, NodeDataType>
extends TileEntityPipeBase<PipeType, NodeDataType>
implements IMaterialPipeTile<PipeType, NodeDataType> {
    private Material pipeMaterial = Materials.Aluminium;

    @Override
    public Material getPipeMaterial() {
        return this.pipeMaterial;
    }

    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType, Material pipeMaterial) {
        this.pipeMaterial = pipeMaterial;
        super.setPipeData(pipeBlock, pipeType);
    }

    @Override
    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType) {
        throw new UnsupportedOperationException("Unsupported for TileEntityMaterialMaterialPipeBase");
    }

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> tileEntity) {
        super.transferDataFrom(tileEntity);
        this.pipeMaterial = ((IMaterialPipeTile)tileEntity).getPipeMaterial();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("PipeMaterial", this.pipeMaterial.toString());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pipeMaterial = (Material)Material.MATERIAL_REGISTRY.func_82594_a(compound.func_74779_i("PipeMaterial"));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(Material.MATERIAL_REGISTRY.getIDForObject(this.pipeMaterial));
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.pipeMaterial = Material.MATERIAL_REGISTRY.getObjectById(buf.func_150792_a());
    }
}

