/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.Validate;

public class Recipe {
    private final List<CountableIngredient> inputs;
    private final NonNullList<ItemStack> outputs;
    private final List<ChanceEntry> chancedOutputs;
    private final List<FluidStack> fluidInputs;
    private final List<FluidStack> fluidOutputs;
    private final int duration;
    private final int EUt;
    private final boolean hidden;
    private final Map<String, Object> recipeProperties;

    public static int getMaxChancedValue() {
        return 10000;
    }

    public static String formatChanceValue(int outputChance) {
        return String.format("%.2f", (double)outputChance / ((double)Recipe.getMaxChancedValue() * 1.0) * 100.0);
    }

    public Recipe(List<CountableIngredient> inputs, List<ItemStack> outputs, List<ChanceEntry> chancedOutputs, List<FluidStack> fluidInputs, List<FluidStack> fluidOutputs, Map<String, Object> recipeProperties, int duration, int EUt, boolean hidden) {
        this.recipeProperties = ImmutableMap.copyOf(recipeProperties);
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(inputs);
        this.outputs = NonNullList.func_191196_a();
        this.outputs.addAll(outputs);
        this.chancedOutputs = new ArrayList<ChanceEntry>(chancedOutputs);
        this.fluidInputs = ImmutableList.copyOf(fluidInputs);
        this.fluidOutputs = ImmutableList.copyOf(fluidOutputs);
        this.duration = duration;
        this.EUt = EUt;
        this.hidden = hidden;
        this.inputs.sort(Comparator.comparing(CountableIngredient::getCount).reversed());
    }

    public final boolean matches(boolean consumeIfSuccessful, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.matches(consumeIfSuccessful, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs));
    }

    public boolean matches(boolean consumeIfSuccessful, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        int i;
        boolean isNotConsumed;
        int fluidAmount;
        ItemStack itemInSlot;
        int i2;
        int[] fluidAmountInTank = new int[fluidInputs.size()];
        int[] itemAmountInSlot = new int[inputs.size()];
        for (i2 = 0; i2 < fluidAmountInTank.length; ++i2) {
            FluidStack fluidInTank = fluidInputs.get(i2);
            fluidAmountInTank[i2] = fluidInTank == null ? 0 : fluidInTank.amount;
        }
        for (i2 = 0; i2 < itemAmountInSlot.length; ++i2) {
            itemInSlot = inputs.get(i2);
            itemAmountInSlot[i2] = itemInSlot.func_190926_b() ? 0 : itemInSlot.func_190916_E();
        }
        for (FluidStack fluid : this.fluidInputs) {
            fluidAmount = fluid.amount;
            isNotConsumed = false;
            if (fluidAmount == 0) {
                fluidAmount = 1;
                isNotConsumed = true;
            }
            for (i = 0; i < fluidInputs.size(); ++i) {
                FluidStack tankFluid = fluidInputs.get(i);
                if (tankFluid == null || !tankFluid.isFluidEqual(fluid)) continue;
                int fluidAmountToConsume = Math.min(fluidAmountInTank[i], fluidAmount);
                fluidAmount -= fluidAmountToConsume;
                if (!isNotConsumed) {
                    int n = i;
                    fluidAmountInTank[n] = fluidAmountInTank[n] - fluidAmountToConsume;
                }
                if (fluidAmount == 0) break;
            }
            if (fluidAmount <= 0) continue;
            return false;
        }
        for (CountableIngredient ingredient : this.inputs) {
            int ingredientAmount = ingredient.getCount();
            isNotConsumed = false;
            if (ingredientAmount == 0) {
                ingredientAmount = 1;
                isNotConsumed = true;
            }
            for (i = 0; i < inputs.size(); ++i) {
                ItemStack inputStack = inputs.get(i);
                if (inputStack.func_190926_b() || !ingredient.getIngredient().apply(inputStack)) continue;
                int itemAmountToConsume = Math.min(itemAmountInSlot[i], ingredientAmount);
                ingredientAmount -= itemAmountToConsume;
                if (!isNotConsumed) {
                    int n = i;
                    itemAmountInSlot[n] = itemAmountInSlot[n] - itemAmountToConsume;
                }
                if (ingredientAmount == 0) break;
            }
            if (ingredientAmount <= 0) continue;
            return false;
        }
        if (consumeIfSuccessful) {
            int i3;
            for (i3 = 0; i3 < fluidAmountInTank.length; ++i3) {
                FluidStack fluidStack = fluidInputs.get(i3);
                fluidAmount = fluidAmountInTank[i3];
                if (fluidStack == null || fluidStack.amount == fluidAmount) continue;
                fluidStack.amount = fluidAmount;
                if (fluidStack.amount != 0) continue;
                fluidInputs.set(i3, null);
            }
            for (i3 = 0; i3 < itemAmountInSlot.length; ++i3) {
                itemInSlot = inputs.get(i3);
                int itemAmount = itemAmountInSlot[i3];
                if (itemInSlot.func_190926_b() || itemInSlot.func_190916_E() == itemAmount) continue;
                itemInSlot.func_190920_e(itemAmountInSlot[i3]);
            }
        }
        return true;
    }

    public List<CountableIngredient> getInputs() {
        return this.inputs;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<ItemStack> getResultItemOutputs(int maxOutputSlots, Random random, int tier) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        List<ChanceEntry> chancedOutputsList = this.getChancedOutputs();
        int maxChancedSlots = maxOutputSlots - outputs.size();
        if (chancedOutputsList.size() > maxChancedSlots) {
            chancedOutputsList = chancedOutputsList.subList(0, maxChancedSlots);
        }
        for (ChanceEntry chancedOutput : chancedOutputsList) {
            int outputChance = chancedOutput.getChance() + chancedOutput.getBoostPerTier() * tier;
            if (random.nextInt(Recipe.getMaxChancedValue()) > outputChance) continue;
            outputs.add(chancedOutput.getItemStack().func_77946_l());
        }
        return outputs;
    }

    public List<ItemStack> getAllItemOutputs(int maxOutputSlots) {
        List<Object> outputs = new ArrayList<ItemStack>();
        outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        outputs.addAll(this.getChancedOutputs().stream().map(ChanceEntry::getItemStack).collect(Collectors.toList()));
        if (outputs.size() > maxOutputSlots) {
            outputs = outputs.subList(0, maxOutputSlots);
        }
        return outputs;
    }

    public List<ChanceEntry> getChancedOutputs() {
        return this.chancedOutputs;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public boolean hasInputFluid(FluidStack fluid) {
        for (FluidStack fluidStack : this.fluidInputs) {
            if (!fluidStack.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEUt() {
        return this.EUt;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean hasValidInputsForDisplay() {
        boolean hasValidInputs = true;
        for (CountableIngredient ingredient : this.inputs) {
            ItemStack[] matchingItems = ingredient.getIngredient().func_193365_a();
            hasValidInputs &= Arrays.stream(matchingItems).anyMatch(s -> !s.func_190926_b());
        }
        return hasValidInputs;
    }

    public Set<String> getPropertyKeys() {
        return this.recipeProperties.keySet();
    }

    public boolean getBooleanProperty(String key) {
        Validate.notNull((Object)key);
        Object o = this.recipeProperties.get(key);
        if (!(o instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        return (Boolean)o;
    }

    public int getIntegerProperty(String key) {
        Validate.notNull((Object)key);
        Object o = this.recipeProperties.get(key);
        if (!(o instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        return (Integer)o;
    }

    public <T> T getProperty(String key) {
        Validate.notNull((Object)key);
        Object o = this.recipeProperties.get(key);
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return (T)o;
    }

    public String getStringProperty(String key) {
        Validate.notNull((Object)key);
        Object o = this.recipeProperties.get(key);
        if (!(o instanceof String)) {
            throw new IllegalArgumentException();
        }
        return (String)o;
    }

    public static class ChanceEntry {
        private final ItemStack itemStack;
        private final int chance;
        private final int boostPerTier;

        public ChanceEntry(ItemStack itemStack, int chance, int boostPerTier) {
            this.itemStack = itemStack.func_77946_l();
            this.chance = chance;
            this.boostPerTier = boostPerTier;
        }

        public ItemStack getItemStack() {
            return this.itemStack.func_77946_l();
        }

        public int getChance() {
            return this.chance;
        }

        public int getBoostPerTier() {
            return this.boostPerTier;
        }
    }
}

