/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.recipes.AssemblyLineRecipe;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AssemblyLineRecipeBuilder {
    private ItemStack researchItem;
    private int researchTime;
    private List<ItemStack> inputs = new ArrayList<ItemStack>();
    private List<FluidStack> fluidInputs = new ArrayList<FluidStack>();
    private ItemStack output;
    private int duration;
    private int EUt;

    private AssemblyLineRecipeBuilder() {
    }

    public static AssemblyLineRecipeBuilder start() {
        return new AssemblyLineRecipeBuilder();
    }

    public AssemblyLineRecipeBuilder researchItem(ItemStack researchItem) {
        this.researchItem = researchItem;
        return this;
    }

    public AssemblyLineRecipeBuilder researchTime(int researchTime) {
        this.researchTime = researchTime;
        return this;
    }

    public AssemblyLineRecipeBuilder inputs(ItemStack ... inputs) {
        Collections.addAll(this.inputs, inputs);
        return this;
    }

    public AssemblyLineRecipeBuilder fluidInputs(FluidStack ... inputs) {
        Collections.addAll(this.fluidInputs, inputs);
        return this;
    }

    public AssemblyLineRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public AssemblyLineRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public AssemblyLineRecipeBuilder EUt(int EUt) {
        this.EUt = EUt;
        return this;
    }

    public ValidationResult<AssemblyLineRecipe> build() {
        return ValidationResult.newResult(this.validate(), new AssemblyLineRecipe(this.researchItem, this.researchTime, this.inputs, this.fluidInputs, this.output, this.duration, this.EUt));
    }

    protected EnumValidationResult validate() {
        EnumValidationResult result = EnumValidationResult.VALID;
        if (this.inputs.contains(null)) {
            GTLog.logger.error("Input cannot contain null ItemStacks", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.fluidInputs.contains(null)) {
            GTLog.logger.error("Fluid input cannot contain null FluidStacks", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.output == null || this.output.func_190926_b()) {
            GTLog.logger.error("Output ItemStack cannot be null or empty", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.researchItem == null || this.output.func_190926_b()) {
            GTLog.logger.error("Research ItemStack cannot be null or empty", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.researchTime <= 0) {
            GTLog.logger.error("Research Time cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.duration <= 0) {
            GTLog.logger.error("Duration cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (this.EUt <= 0) {
            GTLog.logger.error("EUt cannot be less or equal to 0", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(4L, 16L, this.inputs.size())) {
            GTLog.logger.error("Invalid amount of recipe inputs. Should be between {} and {} inclusive", (Object)4, (Object)16);
            GTLog.logger.error("", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(0L, 4L, this.fluidInputs.size())) {
            GTLog.logger.error("Invalid amount of recipe fluid inputs. Should be between {} and {} inclusive", (Object)0, (Object)4);
            GTLog.logger.error("", (Throwable)new IllegalArgumentException());
            result = EnumValidationResult.INVALID;
        }
        return result;
    }

    public void buildAndRegister() {
        ValidationResult<AssemblyLineRecipe> result = this.build();
        if (result.getType() == EnumValidationResult.VALID) {
            // empty if block
        }
    }
}

