/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import com.google.common.collect.ImmutableMap;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CutterRecipeBuilder
extends RecipeBuilder<CutterRecipeBuilder> {
    public CutterRecipeBuilder() {
    }

    public CutterRecipeBuilder(Recipe recipe, RecipeMap<CutterRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public CutterRecipeBuilder(RecipeBuilder<CutterRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public CutterRecipeBuilder copy() {
        return new CutterRecipeBuilder(this);
    }

    @Override
    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult(this.finalizeAndValidate(), new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, (Map<String, Object>)ImmutableMap.of(), this.duration, this.EUt, this.hidden));
    }

    @Override
    public void buildAndRegister() {
        if (this.fluidInputs.isEmpty()) {
            this.recipeMap.addRecipe(((CutterRecipeBuilder)((CutterRecipeBuilder)this.copy().fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, this.duration * this.EUt / 320))))).duration(this.duration * 2)).build());
            this.recipeMap.addRecipe(((CutterRecipeBuilder)((CutterRecipeBuilder)this.copy().fluidInputs(ModHandler.getDistilledWater(Math.max(3, Math.min(750, this.duration * this.EUt / 426))))).duration((int)((double)this.duration * 1.3))).build());
            this.recipeMap.addRecipe(((CutterRecipeBuilder)((CutterRecipeBuilder)this.copy().fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, this.duration * this.EUt / 1280))))).duration(Math.max(1, this.duration / 2))).build());
        } else {
            this.recipeMap.addRecipe(this.build());
        }
    }
}

