/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import com.google.common.collect.ImmutableMap;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import stanhebben.zenscript.annotations.ZenMethod;

public class ImplosionRecipeBuilder
extends RecipeBuilder<ImplosionRecipeBuilder> {
    protected int explosivesAmount;

    public ImplosionRecipeBuilder() {
    }

    public ImplosionRecipeBuilder(Recipe recipe, RecipeMap<ImplosionRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public ImplosionRecipeBuilder(RecipeBuilder<ImplosionRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public ImplosionRecipeBuilder copy() {
        return new ImplosionRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(String key, Object value) {
        if (key.equals("explosives")) {
            this.explosivesAmount((Integer)value);
            return true;
        }
        return false;
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosivesAmount(int explosivesAmount) {
        if (!GTUtility.isBetweenInclusive(1L, 64L, explosivesAmount)) {
            GTLog.logger.error("Amount of explosives should be from 1 to 64 inclusive", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.explosivesAmount = explosivesAmount;
        return this;
    }

    @Override
    public void buildAndRegister() {
        int tntAmount = Math.max(1, this.explosivesAmount / 2);
        this.recipeMap.addRecipe(((ImplosionRecipeBuilder)this.copy().inputs(new ItemStack(Blocks.field_150335_W, tntAmount))).build());
    }

    @Override
    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult(this.finalizeAndValidate(), new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, (Map<String, Object>)ImmutableMap.of(), this.duration, this.EUt, this.hidden));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("explosivesAmount", this.explosivesAmount).toString();
    }
}

