/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.crafttweaker.ChancedEntry;
import gregtech.api.recipes.crafttweaker.InputIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.Recipe")
@ZenRegister
public class CTRecipe {
    private final RecipeMap<?> recipeMap;
    private final Recipe backingRecipe;

    public CTRecipe(RecipeMap<?> recipeMap, Recipe backingRecipe) {
        this.recipeMap = recipeMap;
        this.backingRecipe = backingRecipe;
    }

    @ZenGetter(value="inputs")
    public List<InputIngredient> getInputs() {
        return this.backingRecipe.getInputs().stream().map(InputIngredient::new).collect(Collectors.toList());
    }

    @ZenGetter(value="outputs")
    public List<IItemStack> getOutputs() {
        return this.backingRecipe.getOutputs().stream().map(MCItemStack::new).collect(Collectors.toList());
    }

    @ZenMethod
    public List<IItemStack> getResultItemOutputs(@Optional(valueLong=-1L) long randomSeed, @Optional(valueLong=1L) int tier) {
        return this.backingRecipe.getResultItemOutputs(Integer.MAX_VALUE, randomSeed == -1L ? new Random() : new Random(randomSeed), tier).stream().map(MCItemStack::new).collect(Collectors.toList());
    }

    @ZenGetter(value="changedOutputs")
    public List<ChancedEntry> getChancedOutputs() {
        ArrayList<ChancedEntry> result = new ArrayList<ChancedEntry>();
        this.backingRecipe.getChancedOutputs().forEach(chanceEntry -> result.add(new ChancedEntry((IItemStack)new MCItemStack(chanceEntry.getItemStack()), chanceEntry.getChance(), chanceEntry.getBoostPerTier())));
        return result;
    }

    @ZenGetter(value="fluidInputs")
    public List<ILiquidStack> getFluidInputs() {
        return this.backingRecipe.getFluidInputs().stream().map(MCLiquidStack::new).collect(Collectors.toList());
    }

    @ZenMethod
    public boolean hasInputFluid(ILiquidStack liquidStack) {
        return this.backingRecipe.hasInputFluid(CraftTweakerMC.getLiquidStack((ILiquidStack)liquidStack));
    }

    @ZenGetter(value="fluidOutputs")
    public List<ILiquidStack> getFluidOutputs() {
        return this.backingRecipe.getFluidOutputs().stream().map(MCLiquidStack::new).collect(Collectors.toList());
    }

    @ZenGetter(value="duration")
    public int getDuration() {
        return this.backingRecipe.getDuration();
    }

    @ZenGetter(value="EUt")
    public int getEUt() {
        return this.backingRecipe.getEUt();
    }

    @ZenGetter(value="hidden")
    public boolean isHidden() {
        return this.backingRecipe.isHidden();
    }

    @ZenGetter(value="propertyKeys")
    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.backingRecipe.getPropertyKeys());
    }

    @ZenMethod
    public Object getProperty(String key) {
        return this.backingRecipe.getProperty(key);
    }

    @ZenMethod
    public boolean remove() {
        return this.recipeMap.removeRecipe(this.backingRecipe);
    }
}

