/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.machines;

import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.recipes.FluidKey;
import gregtech.api.recipes.recipes.FuelRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

public class FuelRecipeMap {
    private static final List<FuelRecipeMap> RECIPE_MAPS = new ArrayList<FuelRecipeMap>();
    public final String unlocalizedName;
    private final Map<FluidKey, FuelRecipe> recipeFluidMap = new HashMap<FluidKey, FuelRecipe>();
    private final List<FuelRecipe> recipeList = new ArrayList<FuelRecipe>();

    public FuelRecipeMap(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        RECIPE_MAPS.add(this);
    }

    @ZenGetter(value="recipeMaps")
    public static List<FuelRecipeMap> getRecipeMaps() {
        return RECIPE_MAPS;
    }

    @ZenMethod
    public void addRecipe(FuelRecipe fuelRecipe) {
        FluidKey fluidKey = new FluidKey(fuelRecipe.getRecipeFluid());
        if (this.recipeFluidMap.containsKey(fluidKey)) {
            FuelRecipe oldRecipe = this.recipeFluidMap.remove(fluidKey);
            this.recipeList.remove(oldRecipe);
        }
        this.recipeFluidMap.put(fluidKey, fuelRecipe);
        this.recipeList.add(fuelRecipe);
    }

    @ZenMethod
    public boolean removeRecipe(FuelRecipe recipe) {
        if (this.recipeList.contains(recipe)) {
            this.recipeList.remove(recipe);
            this.recipeFluidMap.remove(new FluidKey(recipe.getRecipeFluid()));
            return true;
        }
        return false;
    }

    public FuelRecipe findRecipe(long maxVoltage, FluidStack inputFluid) {
        if (inputFluid == null) {
            return null;
        }
        FluidKey fluidKey = new FluidKey(inputFluid);
        FuelRecipe fuelRecipe = this.recipeFluidMap.get(fluidKey);
        return fuelRecipe != null && fuelRecipe.matches(maxVoltage, inputFluid) ? fuelRecipe : null;
    }

    @ZenMethod(value="findRecipe")
    @Optional.Method(modid="crafttweaker")
    public FuelRecipe ctFindRecipe(long maxVoltage, ILiquidStack inputFluid) {
        return this.findRecipe(maxVoltage, CraftTweakerMC.getLiquidStack((ILiquidStack)inputFluid));
    }

    @ZenGetter(value="recipes")
    public List<FuelRecipe> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @SideOnly(value=Side.CLIENT)
    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return I18n.func_135052_a((String)("recipemap." + this.unlocalizedName + ".name"), (Object[])new Object[0]);
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }
}

